-- SPDX-FileCopyrightText: 2023 The CC: Tweaked Developers
--
-- SPDX-License-Identifier: MPL-2.0

--[[- A parser for Lua programs and expressions.

> [!DANGER]
> This is an internal module and SHOULD NOT be used in your own code. It may
> be removed or changed at any time.

Most of the code in this module is automatically generated from the Lua grammar,
hence being mostly unreadable!

@local
]]

-- Lazily load our map of errors
local errors = setmetatable({}, {
    __index = function(self, key)
        setmetatable(self, nil)
        for k, v in pairs(require "cc.internal.syntax.errors") do self[k] = v end

        return self[key]
    end,
})

-- Everything below this line is auto-generated. DO NOT EDIT.

--- A lookup table of valid Lua tokens
local tokens = (function() return {} end)() -- Make tokens opaque to illuaminate. Nasty!
for i, token in ipairs({
    "WHILE", "UNTIL", "TRUE", "THEN", "SUB", "STRING", "SEMICOLON", "RETURN",
    "REPEAT", "POW", "OSQUARE", "OR", "OPAREN", "OBRACE", "NUMBER", "NOT",
    "NIL", "NE", "MUL", "MOD", "LT", "LOCAL", "LEN", "LE", "IN", "IF",
    "IDENT", "GT", "GOTO", "GE", "FUNCTION", "FOR", "FALSE", "EQUALS", "EQ",
    "EOF", "END", "ELSEIF", "ELSE", "DOUBLE_COLON", "DOTS", "DOT", "DO",
    "DIV", "CSQUARE", "CPAREN", "CONCAT", "COMMA", "COLON", "CBRACE",
    "BREAK", "AND", "ADD", "COMMENT", "ERROR",
}) do tokens[token] = i end
setmetatable(tokens, { __index = function(_, name) error("No such token " .. tostring(name), 2) end })

--- Read a integer with a given size from a string.
local function get_int(str, offset, size)
    if size == 1 then
        return str:byte(offset + 1)
    elseif size == 2 then
        local hi, lo = str:byte(offset + 1, offset + 2)
        return hi * 256 + lo
    elseif size == 3 then
        local b1, b2, b3 = str:byte(offset + 1, offset + 3)
        return b1 * 256 + b2 + b3 * 65536 -- Don't ask.
    else
        error("Unsupported size", 2)
    end
end

--[[ Error handling:

Errors are extracted from the current parse state in a two-stage process:
 - Run a DFA over the current state of the LR1 stack. For each accepting state,
   register a parse error.
 - Once all possible errors are found, pick the best of these and report it to
   the user.

This process is performed by a tiny register-based virtual machine. The bytecode
for this machine is stored in `error_message_program`, and the accompanying
transition table in `error_message_table`.

It would be more efficient to use tables here (`string.byte` is 2-3x slower than
a table lookup) or even define the DFA as a Lua program, however this approach
is much more space efficient - shaving off several kilobytes.

See https://github.com/let-def/lrgrep/ (namely ./support/lrgrep_runtime.ml) for
more information.
]]

local function is_same_line(context, previous, token, token_start)
    local prev_line = context.get_pos(previous)
    local tok_line = context.get_pos(token_start)
    return prev_line == tok_line and token ~= tokens.EOF
end
local error_message = {
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        if token == tokens.EQUALS then
            -- parse_errors.mlyl, line 13
            return errors.table_key_equals(_startloc_token_, _endloc_token_)
        end
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        if token == tokens.EQUALS then
            -- parse_errors.mlyl, line 17
            return errors.use_double_equals(_startloc_token_, _endloc_token_)
        end
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        if token == tokens.STRING or token == tokens.NUMBER or token == tokens.TRUE or token == tokens.FALSE or token == tokens.NIL or token == tokens.OSQUARE or token == tokens.OPAREN or token == tokens.IDENT then
            local _startloc_last_ = stack[regs[1] + 1]
            local _endloc_last_ = stack[regs[2] + 2]
            -- parse_errors.mlyl, line 21
            return errors.missing_table_comma(token, _startloc_token_, _endloc_token_, _endloc_last_)
        end
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        if token == tokens.CPAREN then
            local comma = stack[regs[1]]
            local _startloc_comma_ = stack[regs[1] + 1]
            local _endloc_comma_ = stack[regs[1] + 2]
            -- parse_errors.mlyl, line 28
            return errors.trailing_call_comma(_startloc_comma_, _endloc_comma_, _startloc_token_, _endloc_token_)
        end
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        local open_ = stack[regs[1]]
        local _startloc_open__ = stack[regs[1] + 1]
        local _endloc_open__ = stack[regs[1] + 2]
        -- parse_errors.mlyl, line 34
        return errors.unclosed_brackets(_startloc_open__, _endloc_open__, token, _startloc_token_, _endloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        local start = stack[regs[1]]
        local _startloc_start_ = stack[regs[1] + 1]
        local _endloc_start_ = stack[regs[1] + 2]
        -- parse_errors.mlyl, line 37
        return errors.unclosed_label(_startloc_start_, _endloc_start_, token, _startloc_token_, _endloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        if token == tokens.DOT then
            local local_ = stack[regs[1]]
            local _startloc_local__ = stack[regs[1] + 1]
            local _endloc_local__ = stack[regs[1] + 2]
            -- parse_errors.mlyl, line 41
            return errors.local_function_dot(_startloc_local__, _endloc_local__, _startloc_token_, _endloc_token_)
        end
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        local _startloc_expr_ = stack[regs[1] + 1]
        local _endloc_expr_ = stack[regs[2] + 2]
        local if_ = stack[regs[3]]
        local _startloc_if__ = stack[regs[3] + 1]
        local _endloc_if__ = stack[regs[3] + 2]
        -- parse_errors.mlyl, line 45
        local start
    if is_same_line(context, _endloc_expr_, token, _startloc_token_) then
        start = _startloc_token_
    else
        start = _endloc_expr_ + 1
    end
    return errors.expected_then(_startloc_if__, _endloc_if__, start)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        local start = stack[regs[1]]
        local _startloc_start_ = stack[regs[1] + 1]
        local _endloc_start_ = stack[regs[1] + 2]
        -- parse_errors.mlyl, line 64
        return errors.expected_end(_startloc_start_, _endloc_start_, token, _startloc_token_, _endloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        local func = stack[regs[1]]
        local _startloc_func_ = stack[regs[1] + 1]
        local _endloc_func_ = stack[regs[1] + 2]
        local loc = stack[regs[2]]
        local _startloc_loc_ = stack[regs[2] + 1]
        local _endloc_loc_ = stack[regs[2] + 2]
        -- parse_errors.mlyl, line 68
        return errors.expected_end(_startloc_loc_, _endloc_func_, token, _startloc_token_, _endloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        local _startloc_x_ = stack[regs[1] + 1]
        local _endloc_x_ = stack[regs[2] + 2]
        -- parse_errors.mlyl, line 72
        if not is_same_line(context, _endloc_x_, token, _startloc_token_) then
        return errors.standalone_name_call(token, _endloc_x_)
    end
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        -- parse_errors.mlyl, line 79
        return errors.standalone_name(token, _startloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        -- parse_errors.mlyl, line 82
        return errors.standalone_names(token, _startloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        -- parse_errors.mlyl, line 86
        if token == tokens.END then
        return errors.unexpected_end(_startloc_token_, _endloc_token_)
    elseif token ~= tokens.EOF then
        return errors.expected_statement(token, _startloc_token_, _endloc_token_)
    end
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        -- parse_errors.mlyl, line 96
        return errors.expected_function_args(token, _startloc_token_, _endloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        -- parse_errors.mlyl, line 100
        return errors.expected_expression(token, _startloc_token_, _endloc_token_)
    end,
    function(context, stack, stack_n, regs, token, _startloc_token_, _endloc_token_)
        -- parse_errors.mlyl, line 104
        return errors.expected_var(token, _startloc_token_, _endloc_token_)
    end,
}
local error_message_program_start, error_message_program = 3845, "\7\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\18\168\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\18O\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\18\241\0\8\0\1\2\1\4\18\241\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\4\18%\0\4\18%\0\4\17z\0\1\0\4\16\168\0\4\18%\0\1\0\4\16\168\0\4\18%\0\4\18%\0\4\17z\0\1\0\4\16\168\0\4\18%\0\1\0\4\16\168\0\4\17\1\0\4\17\199\0\1\3\1\2\1\1\1\0\4\15:\0\4\17\199\0\1\3\1\2\1\1\1\0\4\15:\0\4\17\199\0\1\0\4\17\19\0\4\17\199\0\1\3\1\2\1\1\1\0\4\15:\0\4\17\199\0\1\3\1\2\1\1\1\0\4\15:\0\4\17\199\0\1\5\1\4\1\3\1\2\1\1\1\0\4\15\n\0\1\5\1\4\1\3\1\2\1\1\1\0\4\15\18\0\4\18C\0\1\0\4\16\239\0\4\16\1\0\4\18I\0\4\16z\0\1\3\1\2\1\1\1\0\4\16r\0\1\3\1\2\1\1\1\0\4\15:\0\1\3\1\2\1\1\1\0\4\15:\0\1\5\1\4\1\3\1\2\1\1\1\0\4\16G\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\4\17\199\0\1\5\1\4\1\3\1\2\1\1\1\0\4\18?\0\1\0\4\17\19\0\1\0\4\18X\0\1\5\1\4\1\3\1\2\1\1\1\0\4\18;\0\4\17\199\0\4\18\0\0\4\18\0\0\4\17\199\0\1\5\1\4\1\3\1\2\1\1\1\0\4\17\178\0\1\5\1\4\1\3\1\2\1\1\1\0\4\17\174\0\4\16%\0\4\17\131\0\4\16\198\0\4\18\223\0\4\0178\0\4\17\1\0\4\17\199\0\4\18I\0\4\17`\0\4\17\199\0\4\18I\0\4\17\199\0\4\17l\0\4\17`\0\4\17\199\0\4\17l\0\1\0\4\17\182\0\4\16\228\0\1\5\1\4\1\3\1\2\1\1\1\0\4\16\150\0\4\18I\0\4\16\224\0\4\16\224\0\4\17\131\0\4\18I\0\4\17\199\0\4\16%\0\4\17\222\0\4\17\199\0\4\16%\0\4\17\226\0\4\17\199\0\4\16%\0\4\17\214\0\4\17X\0\1\0\4\17\182\0\4\17X\0\4\16\198\0\4\17\199\0\4\18I\0\4\17\199\0\4\15B\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15B\0\4\15B\0\1\0\4\19@\0\4\18\206\0\4\19\12\0\4\19\30\0\4\19\30\0\4\19\30\0\4\19\21\0\4\19\3\0\4\19\12\0\4\19\12\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\18\250\0\1\0\4\19@\0\4\19/\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\17+\0\4\17+\0\2\3\1\2\2\0\1\2\4\18o\0\4\17\247\0\4\15B\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15B\0\4\15B\0\1\0\4\16\143\0\4\16\133\0\1\0\4\19@\0\4\18\206\0\4\19\12\0\4\19\30\0\4\19\30\0\4\19\30\0\4\19\21\0\4\19\3\0\4\19\12\0\4\19\12\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\18\250\0\1\0\4\19@\0\4\19/\0\4\19<\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\17+\0\4\16\198\0\4\16Y\0\4\17+\0\4\16\164\0\2\3\1\2\2\0\1\2\4\18o\0\4\16\198\0\4\16Y\0\1\0\4\16\232\0\4\17\247\0\4\19Z\0\4\16\133\0\4\15:\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15:\0\4\15:\0\4\15\"\0\1\0\4\19@\0\4\19'\0\4\18\159\0\4\18\177\0\4\18\177\0\4\18\177\0\4\18\168\0\4\18f\0\4\18\159\0\4\18\159\0\4\18f\0\4\18f\0\4\18f\0\4\18f\0\4\18f\0\4\18\197\0\1\0\4\19@\0\4\18O\0\4\0187\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\18\241\0\4\18\241\0\2\3\1\2\2\0\1\2\4\18o\0\4\15\"\0\4\17\247\0\4\0187\0\4\17\243\0\4\17\243\0\4\17\243\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\19\21\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\19/\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\17+\0\8\0\1\2\1\4\17+\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\4\15:\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15:\0\4\15:\0\1\0\4\19@\0\4\19'\0\4\18\159\0\4\18\177\0\4\18\177\0\4\18\177\0\4\18\168\0\4\18f\0\4\18\159\0\4\18\159\0\4\18f\0\4\18f\0\4\18f\0\4\18f\0\4\18f\0\4\18\197\0\1\0\4\19@\0\4\18O\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\18\241\0\4\18\241\0\2\3\1\2\2\0\1\2\4\18o\0\4\17\247\0\4\16\198\0\4\18\142\0\4\18\131\0\4\16\202\0\1\0\4\16~\0\2\5\1\2\4\0\4\16\206\0\4\15B\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15B\0\4\15B\0\1\0\4\19@\0\4\18\206\0\4\19\12\0\4\19\30\0\4\19\30\0\4\19\30\0\4\19\21\0\4\19\3\0\4\19\12\0\4\19\12\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\18\250\0\1\0\4\19@\0\4\19/\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\17+\0\4\17+\0\2\3\1\2\2\0\1\2\4\18o\0\4\17\247\0\4\19Z\0\2\5\1\2\4\0\4\16\206\0\4\15B\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15B\0\4\15B\0\1\0\4\16\143\0\4\16\133\0\1\0\4\19@\0\4\18\206\0\4\19\12\0\4\19\30\0\4\19\30\0\4\19\30\0\4\19\21\0\4\19\3\0\4\19\12\0\4\19\12\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\18\250\0\1\0\4\19@\0\4\19/\0\4\19<\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\17+\0\4\16\198\0\4\16Y\0\4\17+\0\4\16\164\0\2\3\1\2\2\0\1\2\4\18o\0\4\16\198\0\4\16Y\0\1\0\4\16\232\0\4\17\247\0\4\19Z\0\4\18\0\0\1\0\4\17\12\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\19\12\0\1\2\8\0\1\2\1\4\19\21\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\12\0\1\2\8\0\1\2\1\4\19\12\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\18\250\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\19/\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\17+\0\8\0\1\2\1\4\17+\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\18\159\0\1\2\8\0\1\2\1\4\18\168\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18\159\0\1\2\8\0\1\2\1\4\18\159\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18\197\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\18O\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\18\241\0\8\0\1\2\1\4\18\241\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\18O\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\18\241\0\8\0\1\2\1\4\18\241\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\19/\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\17+\0\8\0\1\2\1\4\17+\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\19\21\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\12\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\19\3\0\1\2\8\0\1\2\1\4\18\250\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\19/\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\17+\0\8\0\1\2\1\4\17+\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\18\168\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18\159\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18f\0\1\2\8\0\1\2\1\4\18\197\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\18O\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\18\241\0\8\0\1\2\1\4\18\241\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\18\168\0\1\2\8\0\1\2\1\4\18\197\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\18O\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\18\241\0\8\0\1\2\1\4\18\241\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\17<\0\1\0\8\0\1\2\1\4\19@\0\1\2\8\0\1\2\1\4\19\21\0\1\2\8\0\1\2\1\4\18\250\0\1\0\8\0\1\2\1\4\19@\0\8\0\1\2\1\4\19/\0\8\0\1\2\1\4\18\4\0\8\0\1\2\1\4\17\135\0\8\0\1\2\1\4\17\230\0\8\0\1\2\1\4\18\214\0\8\0\1\2\1\4\17+\0\8\0\1\2\1\4\17+\0\2\3\1\2\2\0\1\2\8\0\1\2\1\4\18o\0\8\0\1\2\1\4\17\247\0\1\0\4\16\143\0\4\18\210\0\4\17d\0\4\17T\0\4\17$\0\4\18\186\0\2\5\1\2\4\0\4\18\r\0\4\15B\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15B\0\4\15B\0\1\0\4\19@\0\4\18\206\0\4\19\12\0\4\19\30\0\4\19\30\0\4\19\30\0\4\19\21\0\4\19\3\0\4\19\12\0\4\19\12\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\18\250\0\1\0\4\19@\0\4\19/\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\17+\0\4\17+\0\2\3\1\2\2\0\1\2\4\18o\0\4\17\247\0\1\0\4\16\143\0\4\18\210\0\4\17X\0\4\0174\0\4\0167\0\4\17h\0\1\0\4\16~\0\4\0167\0\1\0\4\16~\0\2\5\1\2\4\0\4\15\204\0\4\15B\0\1\0\4\19@\0\1\2\4\17<\0\1\0\4\19@\0\4\15B\0\4\15B\0\1\0\4\19@\0\4\18\206\0\4\19\12\0\4\19\30\0\4\19\30\0\4\19\30\0\4\19\21\0\4\19\3\0\4\19\12\0\4\19\12\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\19\3\0\4\18\250\0\1\0\4\19@\0\4\19/\0\4\18\4\0\4\17\135\0\4\17\230\0\4\18\214\0\4\17+\0\4\17+\0\2\3\1\2\2\0\1\2\4\18o\0\4\17\247\0\6\0\1\0\7\6\0\183\0\4\19T\0\6\1I\0\4\19T\0\6\1\198\0\4\19T\0\6\2&\0\4\19T\0\6\2n\0\4\19T\0\6\2\206\0\4\19T\0\6\3\22\0\4\19T\0\6\3v\0\4\19T\0\6\3\188\0\8\0\1\2\1\4\19T\0\6\4\2\0\8\0\1\2\1\4\19T\0\6\4H\0\8\0\1\2\1\4\19T\0\6\4\142\0\8\0\1\2\1\4\19T\0\6\0\194\0\8\0\1\2\1\4\19T\0\6\4\149\0\8\0\1\2\1\4\19T\0\6\4\219\0\8\0\1\2\1\4\19T\0\6\5\24\0\8\0\1\2\1\4\19T\0\6\5!\0\8\0\1\2\1\4\19T\0\6\5^\0\8\0\1\2\1\4\19T\0\5\0\n\1\2\0\1\6\0\2\0\4\16\24\0\6\0-\0\4\16\24\0\5\0\r\1\0\6\0c\0\7\6\0%\0\7\6\0002\0\7\6\0\6\0\1\0\4\16\168\0\6\0\3\0\1\0\4\16\143\0\6\0\t\0\4\17\170\0\6\0\7\0\7\5\0\r\1\0\6\0\21\0\4\16?\0\5\0\r\1\0\5\0\16\1\0\6\0\25\0\4\16?\0\6\0\27\0\4\16?\0\6\0\17\0\4\17\218\0\6\0\4\0\4\15\"\0\6\0\5\0\1\0\4\16\143\0\5\0\14\1\0\6\0\n\0\7\6\0\11\0\1\2\4\16\180\0\6\0\8\0\7\4\16v\0\4\16\160\0\4\18+\0\5\0\8\1\1\0\7\4\16\137\0\1\0\4\16\143\0\5\0\4\1\1\0\7\2\5\1\2\4\0\4\16\206\0\4\15:\0\4\16\19\0\5\0\8\1\1\0\5\0\r\1\0\7\5\0\2\1\2\0\1\5\0\4\1\1\2\7\4\17\222\0\4\15\219\0\4\17\210\0\5\0\n\1\2\0\1\5\0\11\1\0\5\0\12\1\0\7\4\17\160\0\4\17\214\0\5\0\5\1\1\0\7\5\0\4\1\1\0\5\0\16\1\0\7\5\0\12\1\0\7\5\0\r\1\0\5\0\16\1\0\7\5\0\6\1\1\0\7\5\0\4\1\1\0\5\0\15\1\0\5\0\16\1\0\7\5\0\3\1\1\0\7\5\0\1\1\0\4\17T\0\4\16\198\0\4\0198\0\5\0\0\1\0\5\0\1\1\0\5\0\2\1\2\0\1\5\0\4\1\1\2\7\4\16\198\0\4\0174\0\4\17X\0\4\17\131\0\4\17T\0\4\18}\0\5\0\r\1\0\5\0\16\1\0\4\18}\0\5\0\r\1\0\4\18}\0\4\17\\\0\5\0\0\1\0\5\0\1\1\0\5\0\2\1\2\0\1\4\16O\0\4\18C\0\4\17\156\0\1\0\4\16~\0\4\17\164\0\4\18\21\0\4\0183\0\5\0\8\1\1\0\5\0\r\1\0\5\0\16\1\0\7\5\0\15\1\0\5\0\16\1\0\7\4\17\170\0\4\17`\0\4\16\11\0\4\16\228\0\4\16\194\0\5\0\1\1\0\4\16c\0\4\17\164\0\4\17\239\0\5\0\1\1\0\4\16\198\0\4\16O\0\5\0\1\1\0\4\18!\0\5\0\n\1\2\0\1\7\4\0152\0\4\16c\0\4\19<\0\4\18\25\0\5\0\r\1\0\7\4\15\247\0\4\16G\0\4\15\26\0\4\19+\0\4\18/\0\4\18\29\0\5\0\14\1\0\7\5\0\16\1\0\7\5\0\1\1\0\4\15\242\0\5\0\15\1\0\5\0\16\1\0\4\16m\0\5\0\1\1\0\4\15~\0\5\0\1\1\0\5\0\7\1\3\0\1\2\7\1\0\4\16~\0\5\0\r\1\0\1\0\4\16~\0\5\0\r\1\0\1\0\4\18\153\0\1\1\4\19L\0\5\0\1\1\0\4\15q\0\5\0\1\1\0\4\15\178\0\5\0\1\1\0\4\15W\0\5\0\2\1\2\0\1\4\16O\0\5\0\1\1\0\4\15\152\0\4\15B\0\4\15\227\0\5\0\1\1\0\4\15\227\0\5\0\15\1\0\5\0\16\1\0\4\15\227\0\4\16\251\0\5\0\1\1\0\4\0174\0\5\0\1\1\0\4\15\165\0\5\0\1\1\0\4\15\139\0\5\0\1\1\0\4\15d\0\5\0\1\1\0\4\15\191\0\5\0\1\1\0\4\15J\0\4\15:\0\4\15\"\0\5\0\1\1\0\4\15\237\0\4\18\210\0\4\15*\0\5\0\1\1\0\5\0\4\1\1\0\7\5\0\t\1\2\0\1\7\5\0\1\1\0\7\4\18\237\0"
local error_message_table = "\1\2\0\0\0\1\0\201\1\0\145\0\0\0\0\0\0\5\0\205\6\0\209\7\0\221\8\0\225\t\0\237\n\0\241\11\0\247\12\0\251\r\1\7\14\1\11\15\1\23\16\1\27\17\1+\18\1;\19\1?\20\1E\5\6\5\0\0\0\23\1I\0\0\0\23\4!\0\0\0\27\1M\0\0\0\0\0\0\29\0\145\31\1Q \1]!\1i\0\0\0\0\0\0\0\0\0%\1u&\1\133\0\0\0\0\0\0)\1\137\0\0\0\0\0\0\0\0\0\1\0\173.\1\141\0\0\0000\1\145\0\0\0002\1\149\0\0\0004\1\153\0\0\0006\1\157\0\0\0008\1\161\0\0\0:\1\165\0\0\0<\1\169\0\0\0>\1\173\0\0\0@\1\177\0\0\0B\1\181\0\0\0D\1\185\0\0\0F\1\189\0\0\0H\1\193\29\0\173J\1\197K\1\213\0\0\0M\1\219\0\0\0\0\0\0P\1\225\0\0\0K\r\155" .. ("\0"):rep(15) .. "U\4\195\0\0\0\0\0\0\0\0\0\0\0\0]\1\241\0\0\0\0\0\0`\1\245a\1\249\0\0\0\0\0\0\0\0\0e\1\253b\7s\0\0\0\0\0\0i\2\1\0\0\0k\2\17b\r\159\0\0\0n\2!K\r\137p\2%q\2)r\2-\0\0\0t\0021u\0025u\0\149w\0029\0\0\0y\2=z\2=\0\0\0K\14?|\0\149~\2Ay\5\245{\5\249\129\2Ey\7w\131\2I\0\0\0\133\2M\0\0\0\135\2Q\135\0\153\0\0\0\138\2U\139\2Y\0\0\0\141\2]\141\0\153\143\2a\143\0\157\145\2g\146\2k\0\0\0\148\2{\0\0\0r\r\143\0\0\0\152\2\127\0\0\0\154\2\131\150\5\253\155\0\163\157\2\135\158\2\139\0\0\0\160\2\143u\0\177\162\2\143r\14E\164\2\147\129\r\147\166\2\151\167\2\155|\0\177\169\2\159\162\6\1\171\2\163\0\0\0\173\2\167\0\0\0\175\2\171\0\0\0\177\2\175\129\14I\135\0\181\180\2\179\181\2\183\181\0\167\183\2\189\184\2\193\141\0\181\4\6\171\143\0\185\188\2\197\7\6\181\190\2\201\t\6\185\n\6\191\11\6\197\174\4\207\r\6\203\196\2\205\15\6\207\174\4\203\155\0\191\174\4\199\19\6\211\t\12S\n\12^\11\12i\23\6\217\0\0\0\0\0\0n\14Q" .. ("\0"):rep(33) .. "&\6\221\0\0\0\0\0\0)\6\227\188\r\151\181\0\195\0\0\0\0\0\0.\6\231\0\0\0000\6\235&\12i2\6\239\135\14U4\6\243\0\0\0006\6\247\188\14M8\6\251\141\14U:\6\255\143\14Y<\7\3\0\0\0>\7\7\0\0\0@\7\0116\12tB\7\15\0\0\0D\7\19\0\0\0F\7\23\0\0\0H\7\27\0\0\0\0\0\0K\7\31\0\0\0M\7%\0\0\0\0\0\0\164\14_\0\0\0R\7)H\12\127T\0\0\169\14_K\12\138\0\0\0M\12\149\0\0\0\0\0\0\175\14_\0\0\0]\7-\0\0\0\0\0\0\0\0\0\181\14cb\0071\0\0\0\0\0\0e\0075\0\0\0\0\0\0]\12\158\0\0\0\0\0\0\0\0\0\0\0\0b\12\167\0\0\0\0\0\0e\12\176\0\0\0r\0079\0\0\0\0\0\0\0\0\0\0\0\0w\7=\0\0\0y\7Az\7E\0\0\0\0\0\0r\12\185\0\0\0\0\0\0\0\0\0\129\7Iw\12\194\131\7M\0\0\0\133\7Q" .. ("\0"):rep(15) .. "\139\7Q\129\12\203\0\0\0\0\0\0\0\0\0\133\12\212\0\0\0\146\7]\0\0\0\148\7a\0\0\0\139\12\212\0\0\0\0\0\0\7\3c\0\0\0\t\3g\n\3m\11\3s\158\0\0\r\3y\0\0\0\15\3}\0\0\0\0\0\0\0\0\0\19\3\129\0\0\0\0\0\0\0\0\0\23\3\135" .. ("\0"):rep(24) .. "\178\7e" .. ("\0"):rep(15) .. "&\3\139\0\0\0\0\0\0)\3\145\188\7k\0\0\0\190\7o\0\0\0.\3\149\0\0\0000\3\153\0\0\0002\3\157\0\0\0004\3\161\188\12\2296\3\165\0\0\0008\3\169\0\0\0:\3\173\0\0\0<\3\177\0\0\0>\3\181\0\0\0@\3\185\0\0\0B\3\189\0\0\0D\3\193\0\0\0F\3\197\0\0\0H\3\201\0\0\0\0\0\0K\3\205\0\0\0M\3\211\0\0\0\0\0\0\0\0\0\0\0\0R\3\215\0\0\0T" .. ("\0"):rep(26) .. "]\3\219\0\0\0\0\0\0\0\0\0\0\0\0b\3\223\0\0\0\0\0\0e\3\227" .. ("\0"):rep(36) .. "r\3\231\0\0\0\0\0\0\0\0\0\0\0\0w\3\235\0\0\0y\3\239z\3\243" .. ("\0"):rep(18) .. "\129\3\247\0\0\0\131\3\251\7\4%\133\3\255\t\4)\n\4/\11\0045\0\0\0\r\4;\139\3\255\15\4?" .. ("\0"):rep(15) .. "\146\4\11\0\0\0\148\4\15" .. ("\0"):rep(27) .. "\158\0\0\0\0\0\0\0\0$\4C\0\0\0&\4G\0\0\0\0\0\0)\4M\0\0\0\0\0\0\0\0\0\0\0\0.\4Q\0\0\0000\4U\0\0\0002\4Y\0\0\0004\4]\178\4\0196\4a\0\0\0008\4e\0\0\0:\4i\0\0\0<\4m\0\0\0>\4q\188\4\25@\4u\190\4\29B\4y\0\0\0D\4}\0\0\0F\4\129\0\0\0H\4\133\0\0\0\0\0\0K\4\137\0\0\0M\4\143" .. ("\0"):rep(21) .. "U\4\147" .. ("\0"):rep(21) .. "]\4\151\0\0\0\0\0\0\0\0\0\0\0\0b\4\155\0\0\0\4\14ie\4\159\0\0\0\7\14s\0\0\0\t\14w\n\14}\11\14\131\0\0\0\r\14\137\0\0\0\15\14\141\0\0\0\0\0\0r\4\163\0\0\0\0\0\0\0\0\0\0\0\0w\4\167" .. ("\0"):rep(27) .. "\129\4\171\0\0\0\0\0\0\0\0\0\133\4\175&\14\145\0\0\0\0\0\0)\14\151\0\0\0\139\4\175\0\0\0\0\0\0.\14\155\0\0\0000\14\159\0\0\0002\14\163\0\0\0004\14\167\0\0\0006\14\171\0\0\0008\14\175\0\0\0:\14\179\0\0\0<\14\183\0\0\0>\14\187\0\0\0@\14\191\0\0\0B\14\195\0\0\0D\14\199\0\0\0F\14\203\0\0\0H\14\207\0\0\0\0\0\0K\14\211\4\6\11M\14\217\0\0\0\7\6\21\0\0\0\t\6\25\n\6\31\11\6%\0\0\0\r\6+\0\0\0\15\6/\0\0\0\0\0\0\186\4\187\0\0\0\188\4\191]\14\221\0\0\0\0\0\0\0\0\0\0\0\0b\14\225\0\0\0\0\0\0e\14\229" .. ("\0"):rep(24) .. "&\0063\0\0\0\0\0\0)\0069r\14\233\0\0\0\0\0\0\0\0\0.\6=w\14\2370\6A\0\0\0002\6E\0\0\0004\6I\0\0\0006\6M\0\0\0008\6Q\129\14\241:\6U\0\0\0<\6Y\133\14\245>\6]\0\0\0@\6a\0\0\0B\6e\139\14\245D\6i\0\0\0F\6m\0\0\0H\6q\0\0\0\0\0\0K\6u\0\0\0M\6{" .. ("\0"):rep(45) .. "]\6\127\0\0\0\0\0\0\0\0\0\0\0\0b\6\131\0\0\0\4\r\163e\6\135\0\0\0\7\r\173\0\0\0\t\r\177\n\r\183\11\r\189\0\0\0\r\r\195\0\0\0\15\r\199\0\0\0\0\0\0r\6\139\0\0\0\188\15\1\0\0\0\190\0\0w\6\143" .. ("\0"):rep(27) .. "\129\6\147\0\0\0\0\0\0\0\0\0\133\6\151&\r\203\0\0\0\0\0\0)\r\209\0\0\0\139\6\151\0\0\0\0\0\0.\r\213\0\0\0000\r\217\0\0\0002\r\221\0\0\0004\r\225\0\0\0006\r\229\0\0\0008\r\233\0\0\0:\r\237\0\0\0<\r\241\0\0\0>\r\245\0\0\0@\r\249\0\0\0B\r\253\0\0\0D\14\1\0\0\0F\14\5\0\0\0H\14\t\0\0\0\0\0\0K\14\r\0\0\0M\14\19\0\0\0\7\5c\0\0\0\t\5g\n\5m\11\5s\0\0\0\r\5y\0\0\0\15\5}\0\0\0\0\0\0\0\0\0\0\0\0\188\6\163]\14\23\190\6\167\0\0\0\0\0\0\0\0\0b\14\27\0\0\0\0\0\0e\14\31" .. ("\0"):rep(24) .. "&\5\129\0\0\0\0\0\0)\5\135r\14#\0\0\0\0\0\0\0\0\0.\5\139w\14'0\5\143\0\0\0002\5\147\0\0\0004\5\151\0\0\0006\5\155\0\0\0008\5\159\129\14+:\5\163\0\0\0<\5\167\133\14/>\5\171\0\0\0@\5\175\0\0\0B\5\179\139\14/D\5\183\0\0\0F\5\187\0\0\0H\5\191\0\0\0\0\0\0K\5\195\0\0\0M\5\201" .. ("\0"):rep(45) .. "]\5\205\0\0\0\0\0\0\0\0\0\0\0\0b\5\209\0\0\0\0\0\0e\5\213\0\0\0\7\2\209\0\0\0\t\2\213\n\2\219\11\2\225\0\0\0\r\2\231\0\0\0\15\2\235\0\0\0\0\0\0r\5\217\0\0\0\188\14;\0\0\0\190\0\0w\5\221" .. ("\0"):rep(27) .. "\129\5\225\0\0\0\0\0\0\0\0\0\133\5\229&\2\239\0\0\0\0\0\0)\2\245\0\0\0\139\5\229\0\0\0\0\0\0.\2\249\0\0\0000\2\253\0\0\0002\3\1\0\0\0004\3\5\0\0\0006\3\t\0\0\0008\3\r\0\0\0:\3\17\0\0\0<\3\21\0\0\0>\3\25\0\0\0@\3\29\0\0\0B\3!\0\0\0D\3%\0\0\0F\3)\0\0\0H\3-\0\0\0\0\0\0K\0031\0\0\0M\0037\0\0\0\t\7}\n\7\136\11\7\147" .. ("\0"):rep(30) .. "\188\5\241]\3;\0\0\0\0\0\0\0\0\0\0\0\0b\3?\0\0\0\0\0\0e\3C" .. ("\0"):rep(18) .. "&\7\147" .. ("\0"):rep(15) .. "r\3G\0\0\0.\7\158\0\0\0\0\0\0w\3K\0\0\0\0\0\0\0\0\0\0\0\0006\7\169\0\0\0008\7\180\0\0\0:\7\191\129\3O<\7\202\0\0\0>\7\213\133\3S@\7\224\0\0\0B\7\235\0\0\0D\7\246\139\3SF\8\1\0\0\0H\8\12\0\0\0\0\0\0K\8\23\0\0\0M\8\"\0\0\0\t\8{\n\8\134\11\8\145" .. ("\0"):rep(33) .. "]\8+\0\0\0\0\0\0\0\0\0\0\0\0b\0084\0\0\0\0\0\0e\8=" .. ("\0"):rep(18) .. "&\8\145" .. ("\0"):rep(15) .. "r\8F\0\0\0.\8\156\0\0\0\188\3_w\8O\0\0\0\0\0\0\0\0\0\0\0\0006\8\167\0\0\0008\8\178\0\0\0:\8\189\129\8X<\8\200\0\0\0>\8\211\133\8a@\8\222\0\0\0B\8\233\0\0\0D\8\244\139\8aF\8\255\0\0\0H\t\n\0\0\0\0\0\0K\t\21\0\0\0M\t \0\0\0\t\n\131\n\n\142\11\n\153" .. ("\0"):rep(33) .. "]\t)\0\0\0\0\0\0\0\0\0\0\0\0b\t2\0\0\0\0\0\0e\t;" .. ("\0"):rep(18) .. "&\n\153" .. ("\0"):rep(15) .. "r\tD\0\0\0\0\0\0\0\0\0\188\8rw\tM\0\0\0\0\0\0\0\0\0\0\0\0006\n\164\0\0\0008\n\175\0\0\0:\n\186\129\tV\0\0\0\0\0\0>\n\197\133\t_@\n\208\0\0\0B\n\219\0\0\0D\n\230\139\t_F\n\241\0\0\0H\n\252\0\0\0\0\0\0K\11\7\0\0\0M\11\18\0\0\0\t\11k\n\11v\11\11\129\0\0\0\0\0\0\0\0\0\0\0\0\t\12\238\n\12\249\11\r\4\0\0\0\0\0\0\0\0\0\0\0\0]\11\27\0\0\0\0\0\0\0\0\0\0\0\0b\11$\0\0\0\0\0\0e\11-" .. ("\0"):rep(18) .. "&\11\129" .. ("\0"):rep(15) .. "r\0116&\r\4\0\0\0\0\0\0\188\tpw\11?\0\0\0\0\0\0\0\0\0\0\0\0006\11\140\0\0\0008\11\151\0\0\0:\11\162\129\11H\0\0\0006\r\15>\11\173\133\11Q@\11\184\0\0\0B\11\195\0\0\0D\11\206\139\11QF\11\217\0\0\0H\11\228\0\0\0\0\0\0K\11\239\0\0\0M\11\250\0\0\0H\r\26\0\0\0\0\0\0K\r%\0\0\0M\r0\0\0\0\t\0\1\n\0\12\11\0\23\0\0\0\0\0\0\0\0\0\0\0\0]\12\3\0\0\0\0\0\0\0\0\0\0\0\0b\12\12\0\0\0]\r9e\12\21\0\0\0\0\0\0\0\0\0b\rB\0\0\0\0\0\0e\rK" .. ("\0"):rep(15) .. "r\12\30&\0\23\0\0\0\0\0\0\188\11bw\12'\0\0\0r\rT\0\0\0\0\0\0\0\0\0\0\0\0w\r]\0\0\0\0\0\0\129\0120\0\0\0006\0\"\0\0\0\133\0129\0\0\0\0\0\0\129\rf\0\0\0\0\0\0\139\0129\133\ro" .. ("\0"):rep(15) .. "\139\ro\t\4\211\n\4\222\11\4\233\0\0\0\0\0\0K\0-\0\0\0M\0008\0\0\0\t\ty\n\t\132\11\t\143" .. ("\0"):rep(33) .. "]\0A\0\0\0\0\0\0\0\0\0\0\0\0b\0J&\4\233\0\0\0e\0S" .. ("\0"):rep(18) .. "&\t\143\0\0\0\0\0\0\188\12J\0\0\0\0\0\0r\0\\6\4\244\0\0\0\0\0\0\188\r\128w\0e" .. ("\0"):rep(27) .. "\129\0n\0\0\0\0\0\0\0\0\0\133\0w\0\0\0\0\0\0K\4\255\0\0\0M\5\n\139\0w\t\t\254\n\n\t\11\n\20\0\0\0\0\0\0K\t\154\0\0\0M\t\165" .. ("\0"):rep(18) .. "]\5\19\0\0\0\0\0\0\0\0\0\0\0\0b\5\28\0\0\0\0\0\0e\5%]\t\174\0\0\0\0\0\0\0\0\0\0\0\0b\t\183&\n\20\0\0\0e\t\192\0\0\0\0\0\0\0\0\0r\5.\0\0\0\0\0\0\0\0\0\0\0\0w\0057\0\0\0\0\0\0\0\0\0r\t\201\0\0\0\0\0\0\0\0\0\188\0\136w\t\210\129\5@\0\0\0\0\0\0\0\0\0\133\5I\0\0\0\0\0\0\0\0\0\0\0\0\129\t\219\139\5I\0\0\0\0\0\0\133\t\228\0\0\0\0\0\0K\n\31\0\0\0M\n*\139\t\228" .. ("\0"):rep(42) .. "]\n3\0\0\0\0\0\0\0\0\0\0\0\0b\n<\0\0\0\0\0\0e\nE" .. ("\0"):rep(36) .. "r\nN\0\0\0\0\0\0\0\0\0\188\5Zw\nW" .. ("\0"):rep(21) .. "\188\t\245\0\0\0\129\n`\0\0\0\0\0\0\0\0\0\133\ni" .. ("\0"):rep(15) .. "\139\ni" .. ("\0"):rep(144) .. "\188\nz"

local function handle_error(context, stack, stack_n, token, token_start, token_end)
    -- Run our error handling virtual machine.
    local pc, top, registers, messages = error_message_program_start, stack_n, {}, {}
    while true do
        local instruction = error_message_program:byte(pc + 1)
        if instruction == 1 then -- Store(reg:8b)
            local reg = error_message_program:byte(pc + 2)
            registers[reg + 1] = top
            pc = pc + 2
        elseif instruction == 2 then -- Move(r1:8b, r2:8b)
            local r1 = error_message_program:byte(pc + 2)
            local r2 = error_message_program:byte(pc + 3)
            registers[r2 + 1] = registers[r1 + 1]
            pc = pc + 3
        elseif instruction == 3 then -- Clear(reg:8b)
            local reg = error_message_program:byte(pc + 2)
            registers[reg + 1] = nil
            pc = pc + 2
        elseif instruction == 4 then -- Yield (Pop one item from the stack and jump)
            -- TODO: Add support for interpret_last. Do we need this?
            if top > 1 then top = top - 3 end
            pc = get_int(error_message_program, pc + 1, 3)
        elseif instruction == 5 then -- Accept
            local clause = get_int(error_message_program, pc + 1, 2)
            local priority, arity = error_message_program:byte(pc + 4, pc + 5)
            local accept = { clause = clause + 1, priority = priority }
            for i = 1, arity do accept[i] = registers[error_message_program:byte(pc + 5 + i) + 1] end
            messages[#messages + 1] = accept

            pc = pc + 5 + arity
        elseif instruction == 6 then -- Match(index:24b)
            local index = get_int(error_message_program, pc + 1, 3)
            local lr1 = stack[top] - 1

            local ksize, vsize = error_message_table:byte(1, 2)
            local offset = 2 + (index + lr1) * (ksize + vsize)
            if offset + 4 + ksize <= #error_message_table and
                get_int(error_message_table, offset, ksize) == lr1 + 1 then
                pc = get_int(error_message_table, offset + ksize, vsize)
            else
                pc = pc + 4
            end
        elseif instruction == 7 then -- Halt
            break
        elseif instruction == 8 then -- Priority(clause:16b, p1:8b, p2:8b)
            local clause = get_int(error_message_program, pc + 1, 2)
            local p1, p2 = error_message_program:byte(pc + 3, pc + 5)

            for i = 1, #messages do
                local msg = messages[i]
                if msg.clause == clause and msg.priority == p1 then msg.priority = p2 end
            end
            pc = pc + 5
        else
            error("Illegal instruction while handling errors " .. tostring(instruction))
        end
    end

    -- Sort the list to ensure earlier patterns are used first.
    table.sort(messages, function(a, b)
        if a.clause == b.clause then
            return a.priority < b.priority
        else
            return a.clause < b.clause
        end
    end)

    -- Then loop until we find an error message which actually works!
    for i = 1, #messages do
        local action = messages[i]
        local message = error_message[action.clause](context, stack, stack_n, action, token, token_start, token_end)
        if message then
            context.report(message)
            return false
        end
    end

    context.report(errors.unexpected_token, token, token_start, token_end)
    return false
end

--- The list of productions in our grammar. Each is a tuple of `terminal * production size`.
local productions = {
    { 55, 1 }, { 54, 1 }, { 84, 1 }, { 84, 1 }, { 83, 3 }, { 82, 1 },
    { 82, 1 }, { 82, 1 }, { 82, 1 }, { 82, 1 }, { 82, 1 }, { 82, 1 },
    { 82, 1 }, { 82, 4 }, { 81, 2 }, { 81, 4 }, { 80, 3 }, { 80, 1 },
    { 80, 1 }, { 79, 1 }, { 79, 3 }, { 79, 3 }, { 79, 3 }, { 79, 3 },
    { 79, 3 }, { 79, 3 }, { 79, 3 }, { 79, 3 }, { 79, 3 }, { 79, 3 },
    { 79, 3 }, { 79, 3 }, { 79, 3 }, { 79, 3 }, { 78, 1 }, { 78, 3 },
    { 78, 2 }, { 78, 2 }, { 78, 2 }, { 77, 1 }, { 77, 3 }, { 77, 3 },
    { 76, 1 }, { 76, 1 }, { 75, 0 }, { 75, 2 }, { 75, 3 }, { 74, 1 },
    { 74, 3 }, { 74, 4 }, { 73, 2 }, { 72, 2 }, { 71, 0 }, { 71, 5 },
    { 70, 0 }, { 70, 2 }, { 69, 0 }, { 69, 1 }, { 68, 0 }, { 68, 1 },
    { 67, 1 }, { 67, 3 }, { 66, 1 }, { 66, 3 }, { 65, 1 }, { 65, 3 },
    { 64, 1 }, { 64, 3 }, { 63, 1 }, { 63, 3 }, { 63, 1 }, { 62, 3 },
    { 62, 3 }, { 62, 5 }, { 62, 4 }, { 62, 6 }, { 62, 8 }, { 62, 9 },
    { 62, 11 }, { 62, 7 }, { 62, 2 }, { 62, 4 }, { 62, 6 }, { 62, 5 },
    { 62, 1 }, { 62, 1 }, { 62, 1 }, { 62, 2 }, { 62, 3 }, { 61, 2 },
    { 60, 3 }, { 59, 0 }, { 59, 1 }, { 59, 3 }, { 58, 1 }, { 58, 3 },
    { 58, 5 }, { 57, 1 }, { 57, 1 }, { 56, 1 },
}

local f = false

--[[- The state machine used for our grammar.

Most LR(1) parsers will encode the transition table in a compact binary format,
optimised for space and fast lookups. However, without access to built-in
bitwise operations, this is harder to justify in Lua. Instead, the transition
table is a 2D lookup table of `action = transitions[state][value]`, where
`action` can be one of the following:

 - `action = false`: This transition is undefined, and thus a parse error. We
   use this (rather than nil) to ensure our tables are dense, and thus stored as
   arrays rather than maps.

 - `action > 0`: Shift this terminal or non-terminal onto the stack, then
   transition to `state = action`.

 - `action < 0`: Apply production `productions[-action]`. This production is a
   tuple composed of the next state and the number of values to pop from the
   stack.
]]
local transitions = {
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, -55, f, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 2, f, f, f, f, f, f, f, f, 4, f, f, 195 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 3 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -51 },
    { 5, -45, f, f, f, f, 113, 114, 117, f, f, f, 9, f, f, f, f, f, f, f, f, 121, f, f, f, 133, 16, f, 146, f, 148, 158, f, f, f, -45, -45, -45, -45, 178, f, f, 181, f, f, f, f, f, f, f, 184, f, f, f, f, 34, f, f, f, f, f, 185, 186, f, 187, f, f, f, f, f, f, f, f, 192, 193, 24, f, f, f, f, 194 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 109, f, 43, 44 },
    { -9, -9, f, -9, -9, f, -9, -9, -9, -9, f, -9, -9, f, f, f, f, -9, -9, -9, -9, -9, f, -9, f, -9, -9, -9, -9, -9, -9, -9, f, f, -9, -9, -9, -9, -9, -9, f, f, -9, -9, -9, -9, -9, -9, f, -9, -9, -9, -9 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 108, f, f, 43, 44 },
    { -13, -13, f, -13, -13, f, -13, -13, -13, -13, f, -13, -13, f, f, f, f, -13, -13, -13, -13, -13, f, -13, f, -13, -13, -13, -13, -13, -13, -13, f, f, -13, -13, -13, -13, -13, -13, f, f, -13, -13, -13, -13, -13, -13, f, -13, -13, -13, -13 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 106, f, 43, 44 },
    { f, f, 6, f, 7, 8, f, f, f, f, 11, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, -92, f, f, f, f, f, 34, f, 95, 104, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 100, f, 40, 103, f, 43, 44 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 91, f, 43, 44 },
    { -12, -12, f, -12, -12, f, -12, -12, -12, -12, f, -12, -12, f, f, f, f, -12, -12, -12, -12, -12, f, -12, f, -12, -12, -12, -12, -12, -12, -12, f, f, -12, -12, -12, -12, -12, -12, f, f, -12, -12, -12, -12, -12, -12, f, -12, -12, -12, -12 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 90, f, f, 43, 44 },
    { -8, -8, f, -8, -8, f, -8, -8, -8, -8, f, -8, -8, f, f, f, f, -8, -8, -8, -8, -8, f, -8, f, -8, -8, -8, -8, -8, -8, -8, f, f, -8, -8, -8, -8, -8, -8, f, f, -8, -8, -8, -8, -8, -8, f, -8, -8, -8, -8 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 89, f, f, 43, 44 },
    { -43, -43, f, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, f, f, f, -43, -43, -43, -43, -43, f, -43, -43, -43, -43, -43, -43, -43, -43, -43, f, -43, -43, -43, -43, -43, -43, -43, f, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43, -43 },
    { -44, -44, f, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, f, f, f, -44, -44, -44, -44, -44, f, -44, -44, -44, -44, -44, -44, -44, -44, -44, f, -44, -44, -44, -44, -44, -44, -44, f, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44 },
    { f, f, f, f, f, f, f, f, f, f, f, f, 19, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 29 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, 20, f, f, f, f, -57, f, f, f, f, f, f, f, f, f, 21, f, f, f, f, f, f, f, f, f, f, 22, f, 26, f, f, f, f, f, f, 24, f, f, f, f, f, f, f, 28 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -4, f, -4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -3, f, -3 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -58, f, 23 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, 20, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 21, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 24, f, f, f, f, f, f, f, 25 },
    { -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -62, f, -62 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 27 },
    { -5, f, f, f, f, f, -5, -5, -5, f, f, f, -5, f, f, f, f, f, f, f, f, -5, f, f, f, -5, -5, f, -5, f, -5, -5, f, f, f, f, -5, f, f, -5, f, f, -5, f, f, f, f, f, f, f, -5 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -61, f, -61 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 30, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 31 },
    { -14, -14, f, -14, -14, f, -14, -14, -14, -14, f, -14, -14, f, f, f, f, -14, -14, -14, -14, -14, f, -14, f, -14, -14, -14, -14, -14, -14, -14, f, f, -14, -14, -14, -14, -14, -14, f, f, -14, -14, -14, -14, -14, -14, f, -14, -14, -14, -14 },
    { -10, -10, f, -10, -10, f, -10, -10, -10, -10, f, -10, -10, f, f, f, f, -10, -10, -10, -10, -10, f, -10, f, -10, -10, -10, -10, -10, -10, -10, f, f, -10, -10, -10, -10, -10, -10, f, f, -10, -10, -10, -10, -10, -10, f, -10, -10, -10, -10 },
    { -11, -11, f, -11, -11, f, -11, -11, -11, -11, f, -11, -11, f, f, f, f, -11, -11, -11, -11, -11, f, -11, f, -11, -11, -11, -11, -11, -11, -11, f, f, -11, -11, -11, -11, -11, -11, f, f, -11, -11, -11, -11, -11, -11, f, -11, -11, -11, -11 },
    { -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48, -48 },
    { -7, -7, f, -7, -7, f, -7, -7, -7, -7, f, -7, -7, f, f, f, f, -7, -7, -7, -7, -7, f, -7, f, -7, -7, -7, -7, -7, -7, -7, f, f, -7, -7, -7, -7, -7, -7, f, f, -7, -7, -7, -7, -7, -7, f, -7, -7, -7, -7 },
    { -6, -6, f, -6, -6, 37, -6, -6, -6, -6, 38, -6, 75, 10, f, f, f, -6, -6, -6, -6, -6, f, -6, f, -6, -6, -6, -6, -6, -6, -6, f, f, -6, -6, -6, -6, -6, -6, f, 82, -6, -6, -6, -6, -6, -6, 84, -6, -6, -6, -6, f, f, f, f, f, f, 86, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 88 },
    { -18, -18, f, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, f, f, f, -18, -18, -18, -18, -18, f, -18, f, -18, -18, -18, -18, -18, -18, -18, f, f, -18, -18, -18, -18, -18, -18, f, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 45, f, 43, 44 },
    { -69, -69, f, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, f, f, f, -69, -69, -69, -69, -69, f, -69, f, -69, -69, -69, -69, -69, -69, -69, f, f, -69, -69, -69, -69, -69, -69, f, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69, -69 },
    { -20, -20, f, -20, -20, f, -20, -20, -20, 41, f, -20, -20, f, f, f, f, -20, -20, -20, -20, -20, f, -20, f, -20, -20, -20, -20, -20, -20, -20, f, f, -20, -20, -20, -20, -20, -20, f, f, -20, -20, -20, -20, -20, -20, f, -20, -20, -20, -20 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 42, f, f, 43, 44 },
    { -36, -36, -36, -36, -36, -36, -36, -36, -36, 41, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36 },
    { -71, -71, f, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, f, f, f, -71, -71, -71, -71, -71, f, -71, f, -71, -71, -71, -71, -71, -71, -71, f, f, -71, -71, -71, -71, -71, -71, f, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71, -71 },
    { -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35 },
    { f, f, f, f, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, 74, f, 58, f, f, f, f, 72, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 47, f, 43, 44 },
    { -24, -24, f, -24, -24, f, -24, -24, -24, f, f, -24, -24, f, f, f, f, -24, 48, 50, -24, -24, f, -24, f, -24, -24, -24, -24, -24, -24, -24, f, f, -24, -24, -24, -24, -24, -24, f, f, -24, 52, -24, -24, -24, -24, f, -24, -24, -24, -24 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 49, f, 43, 44 },
    { -25, -25, f, -25, -25, f, -25, -25, -25, f, f, -25, -25, f, f, f, f, -25, -25, -25, -25, -25, f, -25, f, -25, -25, -25, -25, -25, -25, -25, f, f, -25, -25, -25, -25, -25, -25, f, f, -25, -25, -25, -25, -25, -25, f, -25, -25, -25, -25 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 51, f, 43, 44 },
    { -27, -27, f, -27, -27, f, -27, -27, -27, f, f, -27, -27, f, f, f, f, -27, -27, -27, -27, -27, f, -27, f, -27, -27, -27, -27, -27, -27, -27, f, f, -27, -27, -27, -27, -27, -27, f, f, -27, -27, -27, -27, -27, -27, f, -27, -27, -27, -27 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 53, f, 43, 44 },
    { -26, -26, f, -26, -26, f, -26, -26, -26, f, f, -26, -26, f, f, f, f, -26, -26, -26, -26, -26, f, -26, f, -26, -26, -26, -26, -26, -26, -26, f, f, -26, -26, -26, -26, -26, -26, f, f, -26, -26, -26, -26, -26, -26, f, -26, -26, -26, -26 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 55, f, 43, 44 },
    { -22, -22, f, -22, 46, f, -22, -22, -22, f, f, -22, -22, f, f, f, f, 56, 48, 50, 62, -22, f, 64, f, -22, -22, 66, -22, 68, -22, -22, f, f, 70, -22, -22, -22, -22, -22, f, f, -22, 52, -22, -22, 58, -22, f, -22, -22, 72, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 57, f, 43, 44 },
    { -30, -30, f, -30, 46, f, -30, -30, -30, f, f, -30, -30, f, f, f, f, -30, 48, 50, -30, -30, f, -30, f, -30, -30, -30, -30, -30, -30, -30, f, f, -30, -30, -30, -30, -30, -30, f, f, -30, 52, -30, -30, 58, -30, f, -30, -30, -30, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 59, f, 43, 44 },
    { -28, -28, f, -28, 46, f, -28, -28, -28, f, f, -28, -28, f, f, f, f, -28, 48, 50, -28, -28, f, -28, f, -28, -28, -28, -28, -28, -28, -28, f, f, -28, -28, -28, -28, -28, -28, f, f, -28, 52, -28, -28, 58, -28, f, -28, -28, -28, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 61, f, 43, 44 },
    { -23, -23, f, -23, -23, f, -23, -23, -23, f, f, -23, -23, f, f, f, f, -23, 48, 50, -23, -23, f, -23, f, -23, -23, -23, -23, -23, -23, -23, f, f, -23, -23, -23, -23, -23, -23, f, f, -23, 52, -23, -23, -23, -23, f, -23, -23, -23, -23 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 63, f, 43, 44 },
    { -31, -31, f, -31, 46, f, -31, -31, -31, f, f, -31, -31, f, f, f, f, -31, 48, 50, -31, -31, f, -31, f, -31, -31, -31, -31, -31, -31, -31, f, f, -31, -31, -31, -31, -31, -31, f, f, -31, 52, -31, -31, 58, -31, f, -31, -31, -31, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 65, f, 43, 44 },
    { -32, -32, f, -32, 46, f, -32, -32, -32, f, f, -32, -32, f, f, f, f, -32, 48, 50, -32, -32, f, -32, f, -32, -32, -32, -32, -32, -32, -32, f, f, -32, -32, -32, -32, -32, -32, f, f, -32, 52, -32, -32, 58, -32, f, -32, -32, -32, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 67, f, 43, 44 },
    { -33, -33, f, -33, 46, f, -33, -33, -33, f, f, -33, -33, f, f, f, f, -33, 48, 50, -33, -33, f, -33, f, -33, -33, -33, -33, -33, -33, -33, f, f, -33, -33, -33, -33, -33, -33, f, f, -33, 52, -33, -33, 58, -33, f, -33, -33, -33, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 69, f, 43, 44 },
    { -34, -34, f, -34, 46, f, -34, -34, -34, f, f, -34, -34, f, f, f, f, -34, 48, 50, -34, -34, f, -34, f, -34, -34, -34, -34, -34, -34, -34, f, f, -34, -34, -34, -34, -34, -34, f, f, -34, 52, -34, -34, 58, -34, f, -34, -34, -34, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 71, f, 43, 44 },
    { -29, -29, f, -29, 46, f, -29, -29, -29, f, f, -29, -29, f, f, f, f, -29, 48, 50, -29, -29, f, -29, f, -29, -29, -29, -29, -29, -29, -29, f, f, -29, -29, -29, -29, -29, -29, f, f, -29, 52, -29, -29, 58, -29, f, -29, -29, -29, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 73, f, 43, 44 },
    { -21, -21, f, -21, 46, f, -21, -21, -21, f, f, -21, -21, f, f, f, f, 56, 48, 50, 62, -21, f, 64, f, -21, -21, 66, -21, 68, -21, -21, f, f, 70, -21, -21, -21, -21, -21, f, f, -21, 52, -21, -21, 58, -21, f, -21, -21, -21, 60 },
    { -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, -59, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, 76, f, 79, f, f, f, f, f, 39, f, 24, f, 40, 81, f, 43, 44 },
    { f, -60, f, f, f, f, -60, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -60, -60, -60, -60, f, f, f, f, f, f, -60, f, 77 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 78, f, 43, 44 },
    { -64, -64, f, f, 46, f, -64, -64, -64, f, f, 54, -64, f, f, f, f, 56, 48, 50, 62, -64, f, 64, f, -64, -64, 66, -64, 68, -64, -64, f, f, 70, -64, -64, -64, -64, -64, f, f, -64, 52, f, -64, 58, -64, f, f, -64, 72, 60 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 80 },
    { -17, -17, f, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, f, f, f, -17, -17, -17, -17, -17, f, -17, f, -17, -17, -17, -17, -17, -17, -17, f, f, -17, -17, -17, -17, -17, -17, f, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17 },
    { -63, -63, f, f, 46, f, -63, -63, -63, f, f, 54, -63, f, f, f, f, 56, 48, 50, 62, -63, f, 64, f, -63, -63, 66, -63, 68, -63, -63, f, f, 70, -63, -63, -63, -63, -63, f, f, -63, 52, f, -63, 58, -63, f, f, -63, 72, 60 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 83 },
    { -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 85 },
    { f, f, f, f, f, 37, f, f, f, f, f, f, 75, 10, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 86, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 87 },
    { -19, -19, f, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, f, f, f, -19, -19, -19, -19, -19, f, -19, f, -19, -19, -19, -19, -19, -19, -19, f, f, -19, -19, -19, -19, -19, -19, f, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19 },
    { -16, -16, f, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, f, f, f, -16, -16, -16, -16, -16, f, -16, f, -16, -16, -16, -16, -16, -16, -16, f, f, -16, -16, -16, -16, -16, -16, f, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16 },
    { -15, -15, f, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, f, f, f, -15, -15, -15, -15, -15, f, -15, f, -15, -15, -15, -15, -15, -15, -15, f, f, -15, -15, -15, -15, -15, -15, f, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15 },
    { -38, -38, -38, -38, -38, -38, -38, -38, -38, 41, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38 },
    { -39, -39, -39, -39, -39, -39, -39, -39, -39, 41, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39, -39 },
    { f, f, f, f, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, 92, f, 58, f, f, f, f, 72, 60 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 93 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 94, f, 43, 44 },
    { f, f, f, f, 46, f, -97, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, f, f, 58, -97, f, -97, f, 72, 60 },
    { f, f, f, f, f, f, 96, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 97, f, -93, f, f, f, f, f, f, 98 },
    { f, f, -98, f, -98, -98, f, f, f, f, -98, f, -98, -98, -98, -98, -98, f, f, f, f, f, -98, f, f, f, -98, f, -98, f, -98, f, -98, f, f, f, f, f, f, f, -98, f, f, f, f, f, f, f, f, -98 },
    { f, f, -99, f, -99, -99, f, f, f, f, -99, f, -99, -99, -99, -99, -99, f, f, f, f, f, -99, f, f, f, -99, f, -99, f, -99, f, -99, f, f, f, f, f, f, f, -99, f, f, f, f, f, f, f, f, -99 },
    { f, f, 6, f, 7, 8, f, f, f, f, 11, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, -92, f, f, f, f, f, 34, f, 95, 99, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 100, f, 40, 103, f, 43, 44 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -94 },
    { -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, 101, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 102, f, 43, 44 },
    { f, f, f, f, 46, f, -96, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, f, f, 58, -96, f, -96, f, 72, 60 },
    { f, f, f, f, 46, f, -95, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, f, f, 58, -95, f, -95, f, 72, 60 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 105 },
    { -91, -91, f, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, f, f, f, -91, -91, -91, -91, -91, f, -91, f, -91, -91, -91, -91, -91, -91, -91, f, f, -91, -91, -91, -91, -91, -91, f, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91, -91 },
    { f, f, f, f, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, f, 107, 58, f, f, f, f, 72, 60 },
    { -70, -70, f, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, f, f, f, -70, -70, -70, -70, -70, f, -70, f, -70, -70, -70, -70, -70, -70, -70, f, f, -70, -70, -70, -70, -70, -70, f, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70, -70 },
    { -37, -37, -37, -37, -37, -37, -37, -37, -37, 41, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37 },
    { f, f, f, f, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, 110, 52, f, f, 58, f, f, f, f, 72, 60 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 111, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 112 },
    { -74, -74, f, f, f, f, -74, -74, -74, f, f, f, -74, f, f, f, f, f, f, f, f, -74, f, f, f, -74, -74, f, -74, f, -74, -74, f, f, f, -74, -74, -74, -74, -74, f, f, -74, f, f, f, f, f, f, f, -74 },
    { -86, -86, f, f, f, f, -86, -86, -86, f, f, f, -86, f, f, f, f, f, f, f, f, -86, f, f, f, -86, -86, f, -86, f, -86, -86, f, f, f, -86, -86, -86, -86, -86, f, f, -86, f, f, f, f, f, f, f, -86 },
    { f, -59, 6, f, 7, 8, -59, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, -59, -59, -59, -59, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, 76, f, 115, f, f, f, f, f, 39, f, 24, f, 40, 81, f, 43, 44 },
    { f, -46, f, f, f, f, 116, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -46, -46, -46, -46 },
    { f, -47, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -47, -47, -47, -47 },
    { -55, -55, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, f, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 118, f, f, f, f, f, f, f, f, 4 },
    { f, 119 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 120, f, 43, 44 },
    { -75, -75, f, f, 46, f, -75, -75, -75, f, f, 54, -75, f, f, f, f, 56, 48, 50, 62, -75, f, 64, f, -75, -75, 66, -75, 68, -75, -75, f, f, 70, -75, -75, -75, -75, -75, f, f, -75, 52, f, f, 58, f, f, f, -75, 72, 60 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, 122, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 127, f, f, f, f, f, f, f, 128, f, f, f, f, f, f, f, f, f, f, f, 24 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 123, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 24 },
    { f, f, f, f, f, f, f, f, f, f, f, f, 19, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 124 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 125, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 126 },
    { -83, -83, f, f, f, f, -83, -83, -83, f, f, f, -83, f, f, f, f, f, f, f, f, -83, f, f, f, -83, -83, f, -83, f, -83, -83, f, f, f, -83, -83, -83, -83, -83, f, f, -83, f, f, f, f, f, f, f, -83 },
    { -67, -67, f, f, f, f, -67, -67, -67, f, f, f, -67, f, f, f, f, f, f, f, f, -67, f, f, f, -67, -67, f, -67, f, -67, -67, f, -67, f, -67, -67, -67, -67, -67, f, f, -67, f, f, f, f, -67, f, f, -67 },
    { -81, -81, f, f, f, f, -81, -81, -81, f, f, f, -81, f, f, f, f, f, f, f, f, -81, f, f, f, -81, -81, f, -81, f, -81, -81, f, 129, f, -81, -81, -81, -81, -81, f, f, -81, f, f, f, f, 131, f, f, -81 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, 130, f, f, f, f, f, f, f, 39, f, 24, f, 40, 81, f, 43, 44 },
    { -82, -82, f, f, f, f, -82, -82, -82, f, f, f, -82, f, f, f, f, f, f, f, f, -82, f, f, f, -82, -82, f, -82, f, -82, -82, f, f, f, -82, -82, -82, -82, -82, f, f, -82, f, f, f, f, 77, f, f, -82 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 132, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 24 },
    { -68, -68, f, f, f, f, -68, -68, -68, f, f, f, -68, f, f, f, f, f, f, f, f, -68, f, f, -68, -68, -68, f, -68, f, -68, -68, f, -68, f, -68, -68, -68, -68, -68, f, f, -68, f, f, f, f, -68, f, f, -68 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 134, f, 43, 44 },
    { f, f, f, 135, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, f, f, 58, f, f, f, f, 72, 60 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, -55, -55, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 136, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -53, -53, -53, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 137 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 138, 139, 143 },
    { -76, -76, f, f, f, f, -76, -76, -76, f, f, f, -76, f, f, f, f, f, f, f, f, -76, f, f, f, -76, -76, f, -76, f, -76, -76, f, f, f, -76, -76, -76, -76, -76, f, f, -76, f, f, f, f, f, f, f, -76 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 140, f, 43, 44 },
    { f, f, f, 141, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, f, f, 58, f, f, f, f, 72, 60 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, -55, -55, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 142, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -54, -54, -54 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 144, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 145 },
    { -77, -77, f, f, f, f, -77, -77, -77, f, f, f, -77, f, f, f, f, f, f, f, f, -77, f, f, f, -77, -77, f, -77, f, -77, -77, f, f, f, -77, -77, -77, -77, -77, f, f, -77, f, f, f, f, f, f, f, -77 },
    { f, f, f, f, f, -44, f, f, f, f, -44, f, -44, -44, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, -44, f, f, f, f, f, f, f, -44, f, f, f, f, f, -44, -44, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 147 },
    { -88, -88, f, f, f, f, -88, -88, -88, f, f, f, -88, f, f, f, f, f, f, f, f, -88, f, f, f, -88, -88, f, -88, f, -88, -88, f, f, f, -88, -88, -88, -88, -88, f, f, -88, f, f, f, f, f, f, f, -88 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 149, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 24, 150 },
    { f, f, f, f, f, f, f, f, f, f, f, f, -40, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -40, f, f, f, f, f, f, -40 },
    { f, f, f, f, f, f, f, f, f, f, f, f, 19, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 151, f, f, f, f, f, f, 153, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 155 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 152 },
    { f, f, f, f, f, f, f, f, f, f, f, f, -41, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -41, f, f, f, f, f, f, -41 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 154 },
    { f, f, f, f, f, f, f, f, f, f, f, f, -42, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -42, f, f, f, f, f, f, -42 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 156, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 157 },
    { -84, -84, f, f, f, f, -84, -84, -84, f, f, f, -84, f, f, f, f, f, f, f, f, -84, f, f, f, -84, -84, f, -84, f, -84, -84, f, f, f, -84, -84, -84, -84, -84, f, f, -84, f, f, f, f, f, f, f, -84 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 159, f, f, f, f, f, f, f, 172, f, f, f, f, f, f, f, f, f, f, f, 24 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -67, f, f, f, f, f, f, f, f, 160, f, f, f, f, f, f, f, f, f, f, f, f, f, -67 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 161, f, 43, 44 },
    { f, f, f, f, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, f, 52, f, f, 58, 162, f, f, f, 72, 60 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 163, f, 43, 44 },
    { f, f, f, f, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, 164, 52, f, f, 58, 167, f, f, f, 72, 60 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 165, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 166 },
    { -78, -78, f, f, f, f, -78, -78, -78, f, f, f, -78, f, f, f, f, f, f, f, f, -78, f, f, f, -78, -78, f, -78, f, -78, -78, f, f, f, -78, -78, -78, -78, -78, f, f, -78, f, f, f, f, f, f, f, -78 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, f, f, f, f, f, f, f, f, 39, f, 24, f, 40, 168, f, 43, 44 },
    { f, f, f, f, 46, f, f, f, f, f, f, 54, f, f, f, f, f, 56, 48, 50, 62, f, f, 64, f, f, f, 66, f, 68, f, f, f, f, 70, f, f, f, f, f, f, f, 169, 52, f, f, 58, f, f, f, f, 72, 60 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 170, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 171 },
    { -79, -79, f, f, f, f, -79, -79, -79, f, f, f, -79, f, f, f, f, f, f, f, f, -79, f, f, f, -79, -79, f, -79, f, -79, -79, f, f, f, -79, -79, -79, -79, -79, f, f, -79, f, f, f, f, f, f, f, -79 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 173, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 131 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, 174, f, f, f, f, f, f, f, 39, f, 24, f, 40, 81, f, 43, 44 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 175, f, f, f, f, 77 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 176, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 177 },
    { -80, -80, f, f, f, f, -80, -80, -80, f, f, f, -80, f, f, f, f, f, f, f, f, -80, f, f, f, -80, -80, f, -80, f, -80, -80, f, f, f, -80, -80, -80, -80, -80, f, f, -80, f, f, f, f, f, f, f, -80 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 179 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 180 },
    { -89, -89, f, f, f, f, -89, -89, -89, f, f, f, -89, f, f, f, f, f, f, f, f, -89, f, f, f, -89, -89, f, -89, f, -89, -89, f, f, f, -89, -89, -89, -89, -89, f, f, -89, f, f, f, f, f, f, f, -89 },
    { -55, f, f, f, f, f, -55, -55, -55, f, f, f, -55, f, f, f, f, f, f, f, f, -55, f, f, f, -55, -55, f, -55, f, -55, -55, f, f, f, f, -55, f, f, -55, f, f, -55, f, f, f, f, f, f, f, -55, f, f, f, f, f, f, f, f, f, 182, f, f, f, f, f, f, f, f, 4 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 183 },
    { -72, -72, f, f, f, f, -72, -72, -72, f, f, f, -72, f, f, f, f, f, f, f, f, -72, f, f, f, -72, -72, f, -72, f, -72, -72, f, f, f, -72, -72, -72, -72, -72, f, f, -72, f, f, f, f, f, f, f, -72 },
    { -87, -87, f, f, f, f, -87, -87, -87, f, f, f, -87, f, f, f, f, f, f, f, f, -87, f, f, f, -87, -87, f, -87, f, -87, -87, f, f, f, -87, -87, -87, -87, -87, f, f, -87, f, f, f, f, f, f, f, -87 },
    { -56, -56, f, f, f, f, -56, -56, -56, f, f, f, -56, f, f, f, f, f, f, f, f, -56, f, f, f, -56, -56, f, -56, f, -56, -56, f, f, f, -56, -56, -56, -56, -56, f, f, -56, f, f, f, f, f, f, f, -56 },
    { f, f, f, f, f, 37, f, f, f, f, 38, f, 75, 10, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 82, f, f, f, f, f, f, 84, f, f, f, f, f, f, f, f, f, f, 86, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 88 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 188, f, f, f, f, f, f, f, f, f, f, f, f, f, 190 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, 189, f, f, f, f, f, f, f, 39, f, 24, f, 40, 81, f, 43, 44 },
    { -73, -73, f, f, f, f, -73, -73, -73, f, f, f, -73, f, f, f, f, f, f, f, f, -73, f, f, f, -73, -73, f, -73, f, -73, -73, f, f, f, -73, -73, -73, -73, -73, f, f, -73, f, f, f, f, 77, f, f, -73 },
    { f, f, f, f, f, f, f, f, f, f, f, f, 9, f, f, f, f, f, f, f, f, f, f, f, f, f, 16, f, 17, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, f, f, f, 186, f, f, f, f, f, f, f, f, f, f, 191, f, 24, f, f, f, f, 43 },
    { f, f, f, f, f, -69, f, f, f, f, -69, f, -69, -69, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -66, f, f, f, f, f, f, f, -69, f, f, f, f, f, -66, -69 },
    { f, f, f, f, f, -69, f, f, f, f, -69, f, -69, -69, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -65, f, f, f, f, f, f, f, -69, f, f, f, f, f, -65, -69 },
    { -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90 },
    { -85, -85, f, f, f, -71, -85, -85, -85, f, -71, f, -71, -71, f, f, f, f, f, f, f, -85, f, f, f, -85, -85, f, -85, f, -85, -85, f, f, f, -85, -85, -85, -85, -85, f, -71, -85, f, f, f, f, f, -71, f, -85 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -1 },
    { f, f, 6, f, 7, 8, f, f, f, f, f, f, 9, 10, 12, 13, 14, f, f, f, f, f, 15, f, f, f, 16, f, 17, f, 18, f, 32, f, f, f, f, f, f, f, 33, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 34, f, f, f, 35, f, f, 36, f, f, 197, f, f, f, f, f, 199, f, 39, f, 24, f, 40, 81, f, 43, 44 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, 198, f, f, f, f, f, f, f, f, f, f, f, 77 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -52 },
    { f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, f, -2 },
}

--- Run the parser across a sequence of tokens.
--
-- @tparam table context The current parser context.
-- @tparam function get_next A stateful function which returns the next token.
-- @treturn boolean Whether the parse succeeded or not.
local function parse(context, get_next, start)
    local stack, stack_n = { start or 1, 1, 1 }, 1
    local reduce_stack = {}

    while true do
        local token, token_start, token_end = get_next()
        local state = stack[stack_n]
        local action = transitions[state][token]

        if not action then -- Error
            return handle_error(context, stack, stack_n, token, token_start, token_end)
        elseif action >= 0 then -- Shift
            stack_n = stack_n + 3
            stack[stack_n], stack[stack_n + 1], stack[stack_n + 2] = action, token_start, token_end
        elseif action >= -2 then -- Accept
            return true
        else -- Reduce
            -- Reduction is quite complex to get right, as the error code expects the parser
            -- to be shifting rather than reducing. Menhir achieves this by making the parser
            -- stack be immutable, but that's hard to do efficiently in Lua: instead we track
            -- what symbols we've pushed/popped, and only perform this change when we're ready
            -- to shift again.

            local popped, pushed = 0, 0
            while true do
                -- Look at the current item to reduce
                local reduce = productions[-action]
                local terminal, to_pop = reduce[1], reduce[2]

                -- Find the state at the start of this production. If to_pop == 0
                -- then use the current state.
                local lookback = state
                if to_pop > 0 then
                    pushed = pushed - to_pop
                    if pushed <= 0 then
                        -- If to_pop >= pushed, then clear the reduction stack
                        -- and consult the normal stack.
                        popped = popped - pushed
                        pushed = 0
                        lookback = stack[stack_n - popped * 3]
                    else
                        -- Otherwise consult the stack of temporary reductions.
                        lookback = reduce_stack[pushed]
                    end
                end

                state = transitions[lookback][terminal]
                if not state or state <= 0 then error("reduce must shift!") end

                -- And fetch the next action
                action = transitions[state][token]

                if not action then -- Error
                    return handle_error(context, stack, stack_n, token, token_start, token_end)
                elseif action >= 0 then -- Shift
                    break
                elseif action >= -2 then -- Accept
                    return true
                else
                    pushed = pushed + 1
                    reduce_stack[pushed] = state
                end
            end

            if popped == 1 and pushed == 0 then
                -- Handle the easy case: Popped one item and replaced it with another
                stack[stack_n] = state
            else
                -- Otherwise pop and push.
                -- FIXME: The positions of everything here are entirely wrong.
                local end_pos = stack[stack_n + 2]
                stack_n = stack_n - popped * 3
                local start_pos = stack[stack_n + 1]

                for i = 1, pushed do
                    stack_n = stack_n + 3
                    stack[stack_n], stack[stack_n + 1], stack[stack_n + 2] = reduce_stack[i], end_pos, end_pos
                end

                stack_n = stack_n + 3
                stack[stack_n], stack[stack_n + 1], stack[stack_n + 2] = state, start_pos, end_pos
            end

            -- Shift the token onto the stack
            stack_n = stack_n + 3
            stack[stack_n], stack[stack_n + 1], stack[stack_n + 2] = action, token_start, token_end
        end
    end
end

return {
    tokens = tokens,
    parse = parse,
    repl_exprs = 196, --[[- The repl_exprs starting state. ]]
    program = 1, --[[- The program starting state. ]]
}
