/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.function.BiConsumer;
import me.jellysquid.mods.lithium.common.LithiumMod;
import me.jellysquid.mods.lithium.common.compat.worldedit.WorldEditCompat;
import net.caffeinemc.caffeineconfig.AbstractCaffeineConfigMixinPlugin;
import net.caffeinemc.caffeineconfig.CaffeineConfig;
import net.caffeinemc.caffeineconfig.Option;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;

public class LithiumConfig
extends AbstractCaffeineConfigMixinPlugin {
    private CaffeineConfig applyLithiumCompat(CaffeineConfig config) {
        Option option;
        if (LoadingModList.get().getModFileById("ferritecore") != null) {
            config.getOption("mixin.alloc.blockstate").addModOverride(false, "ferritecore");
        }
        if (!(option = config.getOption("mixin.block.hopper.worldedit_compat")).isEnabled() && WorldEditCompat.WORLD_EDIT_PRESENT) {
            option.addModOverride(true, "radium");
        }
        if (!LoadingModList.get().getErrors().isEmpty()) {
            for (Option op : config.getOptions().values()) {
                op.addModOverride(false, "fml-loading-error");
            }
        }
        return config;
    }

    public LithiumConfig() {
        LithiumMod.CONFIG = this;
    }

    protected CaffeineConfig createConfig() {
        CaffeineConfig.Builder builder = CaffeineConfig.builder((String)"Radium").withInfoUrl("https://github.com/jellysquid3/lithium-fabric/wiki/Configuration-File").withSettingsKey("lithium:options");
        InputStream defaultPropertiesStream = LithiumConfig.class.getResourceAsStream("/assets/lithium/lithium-mixin-config-default.properties");
        if (defaultPropertiesStream == null) {
            throw new IllegalStateException("Lithium mixin config default properties could not be read!");
        }
        try (BufferedReader propertiesReader = new BufferedReader(new InputStreamReader(defaultPropertiesStream));){
            Properties properties = new Properties();
            properties.load(propertiesReader);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(ruleName, enabled) -> builder.addMixinRule((String)ruleName, Boolean.parseBoolean((String)enabled))));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Lithium mixin config default properties could not be read!");
        }
        InputStream dependenciesStream = LithiumConfig.class.getResourceAsStream("/assets/lithium/lithium-mixin-config-dependencies.properties");
        if (dependenciesStream == null) {
            throw new IllegalStateException("Lithium mixin config dependencies could not be read!");
        }
        try (BufferedReader propertiesReader = new BufferedReader(new InputStreamReader(dependenciesStream));){
            Properties properties = new Properties();
            properties.load(propertiesReader);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o1, o2) -> {
                String[] dependenciesSplit;
                String rulename = (String)o1;
                String dependencies = (String)o2;
                for (String dependency : dependenciesSplit = dependencies.split(",")) {
                    String[] split = dependency.split(":");
                    if (split.length != 2) {
                        return;
                    }
                    String dependencyName = split[0];
                    String requiredState = split[1];
                    builder.addRuleDependency(rulename, dependencyName, Boolean.parseBoolean(requiredState));
                }
            }));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Lithium mixin config dependencies could not be read!");
        }
        return this.applyLithiumCompat(builder.build(FMLPaths.CONFIGDIR.get().resolve("lithium.properties")));
    }

    protected String mixinPackageRoot() {
        return "me.jellysquid.mods.lithium.mixin.";
    }
}

