/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.stopMaster;

import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlockEntity;
import com.finchy.pipeorgans.content.midi.stopMaster.StopMasterLinkBehaviour;
import com.finchy.pipeorgans.content.midi.stopMaster.StopMasterSlotPositioning;
import com.finchy.pipeorgans.gui.StopMasterMenu;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.midi.pitchMappings.AllPitchMappings;
import com.finchy.pipeorgans.midi.pitchMappings.PitchMapping;
import com.finchy.pipeorgans.midi.server.MidiMessageServerObject;
import com.finchy.pipeorgans.util.MathUtils;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.link.RedstoneLinkFrequencySlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class StopMasterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
MenuProvider {
    private BlockPos linkedCoord = null;
    private PitchMapping mapping;
    private StopMasterLinkBehaviour link;
    private int transmittedSignal;
    private FilteringBehaviour filtering;
    private int channels = 0;
    private int activeNotes;

    public StopMasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AllBlockEntities.STOP_MASTER_BLOCK_ENTITY.get(), pos, state);
        this.toggleChannel(0);
        this.toggleChannel(1);
        this.setChannel(2, true);
        this.setChannel(3, true);
        this.mapping = AllPitchMappings.PIPE_CENTRIC;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new StopMasterSlotPositioning());
        this.filtering.withCallback(this::setKeyFrequency);
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.createLink();
        behaviours.add(this.link);
    }

    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        if (this.linkedCoord != null) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", this.linkedCoord.m_123341_());
            posTag.m_128405_("y", this.linkedCoord.m_123342_());
            posTag.m_128405_("z", this.linkedCoord.m_123343_());
            tag.m_128365_("source_coord", (Tag)posTag);
        }
        tag.m_128405_("channels", this.channels);
        if (this.mapping != null) {
            tag.m_128359_("mapping", this.mapping.name());
        } else {
            tag.m_128359_("mapping", "pipe_centric");
        }
        super.write(tag, clientPacket);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        CompoundTag posTag = (CompoundTag)tag.m_128423_("source_coord");
        if (posTag != null) {
            int x = posTag.m_128451_("x");
            int y = posTag.m_128451_("y");
            int z = posTag.m_128451_("z");
            this.linkedCoord = new BlockPos(x, y, z);
        }
        this.channels = tag.m_128451_("channels");
        String mappingID = tag.m_128461_("mapping");
        this.mapping = AllPitchMappings.getMapping(mappingID);
        super.read(tag, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String link = this.linkedCoord == null ? "None" : "(%d, %d, %d)".formatted(this.linkedCoord.m_123341_(), this.linkedCoord.m_123342_(), this.linkedCoord.m_123343_());
        CreateLang.translate((String)"goggles.stop_master_source", (Object[])new Object[]{link}).forGoggles(tooltip);
        return true;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.pipeorgans.stop_master");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new StopMasterMenu(pContainerId, pPlayerInventory, (BlockEntity)this);
    }

    protected void createLink() {
        Pair slots = ValueBoxTransform.Dual.makeSlots(RedstoneLinkFrequencySlot::new);
        this.link = StopMasterLinkBehaviour.transmitter(this, (Pair<ValueBoxTransform, ValueBoxTransform>)slots, this::getSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setKeyFrequency(ItemStack a) {
        this.link.setKeyFrequency(a);
    }

    public void setNoteFrequency(int pitch, int velocity) {
        ItemStack freq = this.mapping.getStack(pitch);
        this.link.setNoteFrequency(freq, velocity > 0);
        int mappedStrength = Math.round(MathUtils.map(velocity, 0.0f, 127.0f, 0.0f, 15.0f));
        this.transmit(mappedStrength);
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    public PitchMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(String newMapping) {
        if (!Objects.equals(newMapping, "")) {
            this.mapping = AllPitchMappings.getMapping(newMapping);
        }
    }

    public boolean getChannel(int channel) {
        int mask = 1 << channel;
        return (this.channels & mask) != 0;
    }

    public void setChannel(int channel, boolean state) {
        if (channel < 0) {
            return;
        }
        this.channels = state ? this.channels | 1 << channel : this.channels & (int)Math.pow(2.0, 16.0) - 1 - (int)Math.pow(2.0, channel);
        this.notifyUpdate();
    }

    public void toggleChannel(int channel) {
        if (channel < 0) {
            return;
        }
        int mask = 1 << channel;
        this.channels ^= mask;
        this.notifyUpdate();
    }

    public void linkToSource(KeyboardRelayBlockEntity source) {
        if (this.linkedCoord == null) {
            this.linkedCoord = source.m_58899_();
            source.linkStopMaster(this);
            this.notifyUpdate();
        }
    }

    public void linkToSource(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KeyboardRelayBlockEntity) {
            KeyboardRelayBlockEntity be = (KeyboardRelayBlockEntity)blockEntity;
            this.linkToSource(be);
        }
    }

    public void removeSource() {
        this.linkedCoord = null;
        this.notifyUpdate();
    }

    public void onBlockRemoved() {
        BlockEntity blockEntity;
        if (this.linkedCoord != null && (blockEntity = this.f_58857_.m_7702_(this.linkedCoord)) instanceof KeyboardRelayBlockEntity) {
            KeyboardRelayBlockEntity kbr = (KeyboardRelayBlockEntity)blockEntity;
            kbr.removeStopMaster(this);
        }
    }

    public void receiveMidiSignal(MidiMessageServerObject mm) {
        if (!this.getChannel(mm.channel)) {
            return;
        }
        if (mm.velocity > 0) {
            this.handleNoteOn(mm.note, mm.velocity);
        } else {
            this.handleNoteOff(mm.note, mm.velocity);
        }
    }

    private void handleNoteOn(int pitch, int velocity) {
        this.setNoteFrequency(pitch, velocity);
        if (this.activeNotes == 0) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 3);
        }
        ++this.activeNotes;
    }

    private void handleNoteOff(int pitch, int velocity) {
        this.setNoteFrequency(pitch, velocity);
        if (this.activeNotes > 0) {
            --this.activeNotes;
            if (this.activeNotes == 0) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }
}

