/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.array.LongArrayLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class LongLoadable
implements Loadable<Long> {
    public static final LongLoadable ANY = LongLoadable.range(Long.MIN_VALUE, Long.MAX_VALUE);
    public static final LongLoadable FROM_ZERO = LongLoadable.min(0L);
    public static final LongLoadable FROM_ONE = LongLoadable.min(1L);
    private final long min;
    private final long max;
    private final boolean var;

    public static LongLoadable range(long min, long max) {
        return new LongLoadable(min, max, true);
    }

    public static LongLoadable min(long min) {
        return LongLoadable.range(min, Long.MAX_VALUE);
    }

    protected long validate(long value, String key) {
        if (this.min <= value && value <= this.max) {
            return value;
        }
        if (this.min == Long.MIN_VALUE) {
            throw new JsonSyntaxException(key + " must not be greater than " + this.max);
        }
        if (this.max == Long.MAX_VALUE) {
            throw new JsonSyntaxException(key + " must not be less than " + this.min);
        }
        throw new JsonSyntaxException(key + " must be between " + this.min + " and " + this.max);
    }

    @Override
    public Long convert(JsonElement element, String key, TypedMap context) {
        return this.validate(GsonHelper.m_13891_((JsonElement)element, (String)key), key);
    }

    @Override
    public JsonElement serialize(Long value) {
        return new JsonPrimitive((Number)this.validate(value, "Value"));
    }

    @Override
    public Long decode(FriendlyByteBuf buffer, TypedMap context) {
        return this.var ? buffer.m_130258_() : buffer.readLong();
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Long value) {
        if (this.var) {
            buffer.m_130103_(value.longValue());
        } else {
            buffer.writeLong(value.longValue());
        }
    }

    public ArrayLoadable<long[]> array(int minSize, int maxSize) {
        return new LongArrayLoadable(this, minSize, maxSize);
    }

    public ArrayLoadable<long[]> array(int minSize) {
        return this.array(minSize, Integer.MAX_VALUE);
    }

    public StringLoadable<Long> asString(int radix) {
        return new StringLongLoadable(this.min, this.max, radix, this.var);
    }

    public LongLoadable(long min, long max, boolean var) {
        this.min = min;
        this.max = max;
        this.var = var;
    }

    private static class StringLongLoadable
    extends LongLoadable
    implements StringLoadable<Long> {
        private final int radix;

        public StringLongLoadable(long min, long max, int radix, boolean var) {
            super(min, max, var);
            if (radix < 2 || radix > 36) {
                throw new IllegalArgumentException("Invalid radix " + radix + ", must be between 2 and 36");
            }
            this.radix = radix;
        }

        @Override
        public Long parseString(String value, String key, TypedMap context) {
            try {
                return this.validate(Long.parseLong(value, this.radix), key);
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException("Failed to parse long at " + key, (Throwable)e);
            }
        }

        @Override
        public Long convert(JsonElement element, String key, TypedMap context) {
            return this.parseString(GsonHelper.m_13805_((JsonElement)element, (String)key), key, context);
        }

        @Override
        public String getString(Long value) {
            return Long.toString(value, this.radix);
        }

        @Override
        public JsonElement serialize(Long value) {
            return new JsonPrimitive(this.getString(value));
        }
    }
}

