/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.IngredientData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.client.screen.book.element.TooltipElement;

public class ContentSmelting
extends PageContent {
    public static final ResourceLocation ID = Mantle.getResource("smelting");
    private static final NonNullList<ItemStack> FUELS;
    public static final transient int TEX_SIZE = 128;
    public static final transient ImageData IMG_SMELTING;
    public static final transient int INPUT_X = 5;
    public static final transient int INPUT_Y = 5;
    public static final transient int RESULT_X = 74;
    public static final transient int RESULT_Y = 41;
    public static final transient int FUEL_X = 5;
    public static final transient int FUEL_Y = 77;
    public static final transient float ITEM_SCALE = 2.0f;
    public String title = "Smelting";
    public IngredientData input;
    public IngredientData result;
    public IngredientData fuel;
    public int cookTime = 200;
    public TextData[] description;
    public String recipe;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int y;
        int x = 91 - ContentSmelting.IMG_SMELTING.width / 2;
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
            y = this.getTitleHeight();
        }
        list.add(new ImageElement(x, y, ContentSmelting.IMG_SMELTING.width, ContentSmelting.IMG_SMELTING.height, IMG_SMELTING, book.appearance.slotColor));
        list.add(new TooltipElement(List.of(Component.m_237110_((String)"mantle:tooltip.cooktime", (Object[])new Object[]{this.cookTime / 20})), x + 7, y + 42, 60, 28));
        if (this.input != null && !this.input.getItems().isEmpty()) {
            list.add(new ItemElement(x + 5, y + 5, 2.0f, (Collection<ItemStack>)this.input.getItems(), this.input.action));
        }
        if (this.result != null && !this.result.getItems().isEmpty()) {
            list.add(new ItemElement(x + 74, y + 41, 2.0f, (Collection<ItemStack>)this.result.getItems(), this.result.action));
        }
        list.add(new ItemElement(x + 5, y + 77, 2.0f, (Collection<ItemStack>)this.getFuelsList()));
        if (this.description != null && this.description.length > 0) {
            list.add(new TextElement(0, ContentSmelting.IMG_SMELTING.height + y + 5, 182, 176 - y - 5, this.description));
        }
    }

    public NonNullList<ItemStack> getFuelsList() {
        if (this.fuel != null) {
            return this.fuel.getItems();
        }
        return FUELS;
    }

    @Override
    public void load() {
        super.load();
        if (!StringUtils.isEmpty((CharSequence)this.recipe) && ResourceLocation.m_135830_((String)this.recipe)) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            Recipe recipe = level.m_7465_().m_44043_(new ResourceLocation(this.recipe)).orElse(null);
            if (recipe instanceof AbstractCookingRecipe) {
                this.input = IngredientData.getItemStackData((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
                this.cookTime = ((AbstractCookingRecipe)recipe).m_43753_();
                this.result = IngredientData.getItemStackData(recipe.m_8043_(level.m_9598_()));
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    static {
        IMG_SMELTING = new ImageData(Textures.TEX_SMELTING, 0, 0, 110, 114, 128, 128);
        FUELS = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50398_), new ItemStack((ItemLike)Blocks.f_50399_), new ItemStack((ItemLike)Blocks.f_50400_), new ItemStack((ItemLike)Blocks.f_50401_), new ItemStack((ItemLike)Blocks.f_50402_), new ItemStack((ItemLike)Blocks.f_50403_), new ItemStack((ItemLike)Blocks.f_50705_), new ItemStack((ItemLike)Blocks.f_50741_), new ItemStack((ItemLike)Blocks.f_50742_), new ItemStack((ItemLike)Blocks.f_50743_), new ItemStack((ItemLike)Blocks.f_50744_), new ItemStack((ItemLike)Blocks.f_50745_), new ItemStack((ItemLike)Blocks.f_50353_), new ItemStack((ItemLike)Items.f_42422_), new ItemStack((ItemLike)Items.f_42420_), new ItemStack((ItemLike)Items.f_42424_), new ItemStack((ItemLike)Items.f_42398_), new ItemStack((ItemLike)Items.f_42413_), new ItemStack((ItemLike)Items.f_42448_), new ItemStack((ItemLike)Blocks.f_50746_), new ItemStack((ItemLike)Blocks.f_50747_), new ItemStack((ItemLike)Blocks.f_50748_), new ItemStack((ItemLike)Blocks.f_50749_), new ItemStack((ItemLike)Blocks.f_50750_), new ItemStack((ItemLike)Blocks.f_50751_), new ItemStack((ItemLike)Items.f_42585_), new ItemStack((ItemLike)Items.f_42421_), new ItemStack((ItemLike)Items.f_42423_)});
    }
}

