/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackEquipSlot;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.base.BackpackStorageSlot;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SlotManager {
    public static void repositionBackpackInventorySlots(AbstractContainerMenu menu, Inventory inventory, int backpackSlotStartIndex, int baseHeight, int xOffset, int yOffset) {
        ItemStack stack = BackpackPlatform.getEquipped(inventory.f_35978_);
        Item item = stack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            int columns = backpackItem.getBackpackType().getColumns();
            int rows = backpackItem.getBackpackType().getRows();
            for (int row = 0; row < rows; ++row) {
                for (int column = 0; column < columns; ++column) {
                    Slot slot;
                    int slotIndex = backpackSlotStartIndex + row * columns + column;
                    if (slotIndex >= menu.f_38839_.size() || !((slot = (Slot)menu.f_38839_.get(slotIndex)) instanceof BackpackStorageSlot)) continue;
                    slot.f_40220_ = -25 - (columns - 1) * 18 + column * 18 + xOffset;
                    slot.f_40221_ = (baseHeight - 166) / 2 + 3 + row * 18 + yOffset;
                }
            }
        }
    }

    public static void repositionBackpackEquipSlot(AbstractContainerMenu menu, int baseHeight, int xOffset, int yOffset) {
        for (Slot slot : menu.f_38839_) {
            if (!(slot instanceof BackpackEquipSlot)) continue;
            slot.f_40220_ = 77 + xOffset;
            slot.f_40221_ = (baseHeight - 166) / 2 + 8 + 36 + yOffset;
            break;
        }
    }

    public static void addBackpackInventorySlots(AbstractContainerMenu screenHandler, Inventory inventory) {
        for (int count = 0; count < BackpackHelper.getMaxBackpackSize(); ++count) {
            screenHandler.m_38897_((Slot)new BackpackStorageSlot(screenHandler, inventory, 36 + count, 0, 0));
        }
    }

    public static void addBackpackEquipSlot(AbstractContainerMenu screenHandler, Inventory inventory) {
        if (BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            return;
        }
        screenHandler.m_38897_((Slot)new BackpackEquipSlot((Container)inventory, 36 + BackpackHelper.getMaxBackpackSize(), 77, 44));
    }

    public static void updateBackpackSlotPositions(Screen screen, AbstractContainerMenu menu, Inventory inventory, int imageHeight) {
        if (screen instanceof CreativeModeInventoryScreen) {
            return;
        }
        if (menu instanceof BackpackMenu) {
            int baseHeight = imageHeight;
            int backpackSlotStartIndex = -1;
            for (int i = 0; i < menu.f_38839_.size(); ++i) {
                if (!(menu.f_38839_.get(i) instanceof BackpackStorageSlot)) continue;
                backpackSlotStartIndex = i;
                break;
            }
            if (backpackSlotStartIndex == -1) {
                return;
            }
            int xOffset = ((BackpackMenu)menu).getBackpackGuiX();
            int yOffset = ((BackpackMenu)menu).getBackpackGuiY();
            int equipXOffset = ((BackpackMenu)menu).getBackpackEquipSlotX();
            int equipYOffset = ((BackpackMenu)menu).getBackpackEquipSlotY();
            SlotManager.repositionBackpackInventorySlots(menu, inventory, backpackSlotStartIndex, baseHeight, xOffset, yOffset);
            SlotManager.repositionBackpackEquipSlot(menu, baseHeight, equipXOffset, equipYOffset);
        }
    }
}

