/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SmeltingRecipeTemplate
implements IRecipeTemplate<SimpleCookingRecipeBuilder.Result> {
    private final List<Object> conditions = new ArrayList<Object>();
    private final CookingBookCategory category;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float experience;
    private final int cookingTime;
    private final SimpleCookingSerializer<?> serializer;

    public SmeltingRecipeTemplate(JsonObject json, SimpleCookingSerializer<?> serializer) {
        this.serializer = serializer;
        AtomicReference cat = new AtomicReference();
        AtomicReference ing = new AtomicReference();
        AtomicReference res = new AtomicReference();
        AtomicReference exp = new AtomicReference();
        AtomicReference time = new AtomicReference();
        SimpleCookingSerializer dummy = new SimpleCookingSerializer((resourceLocation, string, cookingBookCategory, ingredient1, itemStack, f, i) -> {
            cat.set(cookingBookCategory);
            ing.set(ingredient1);
            res.set(itemStack);
            exp.set(Float.valueOf(f));
            time.set(i);
            return null;
        }, serializer.f_44327_);
        dummy.m_6729_(new ResourceLocation("dummy"), json);
        this.category = (CookingBookCategory)cat.get();
        this.ingredient = (Ingredient)ing.get();
        this.result = (ItemStack)res.get();
        this.experience = ((Float)exp.get()).floatValue();
        this.cookingTime = (Integer)time.get();
    }

    @Override
    public <T extends BlockType> SimpleCookingRecipeBuilder.Result createSimilar(T originalMat, T destinationMat, Item unlockItem, @Nullable String id) {
        Ingredient newIngredient = IRecipeTemplate.convertIngredients(originalMat, destinationMat, this.ingredient);
        ItemStack newResult = BlockType.changeItemType(this.result.m_41720_(), originalMat, destinationMat).m_7968_();
        if (newResult == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s", this.result, originalMat, destinationMat));
        }
        if (newIngredient == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s", this.ingredient, originalMat, destinationMat));
        }
        SimpleCookingRecipeBuilder builder = new SimpleCookingRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, this.category, (ItemLike)newResult.m_41720_(), newIngredient, this.experience, this.cookingTime, this.serializer);
        builder.m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{unlockItem}));
        AtomicReference newRecipe = new AtomicReference();
        if (id == null) {
            builder.m_176498_(r -> newRecipe.set((SimpleCookingRecipeBuilder.Result)r));
        } else {
            builder.m_176500_(r -> newRecipe.set((SimpleCookingRecipeBuilder.Result)r), id);
        }
        return (SimpleCookingRecipeBuilder.Result)newRecipe.get();
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    @Override
    public List<Object> getConditions() {
        return this.conditions;
    }
}

