/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ScreenHelper {
    public static boolean isMouseWithin(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static Button button(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        return Button.m_253074_((Component)label, (Button.OnPress)onPress).m_252794_(x, y).m_253046_(width, height).m_253136_();
    }

    public static void drawOutlinedBox(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.m_280509_(x, y, x + width, y + 1, color);
        graphics.m_280509_(x, y + 1, x + 1, y + height - 1, color);
        graphics.m_280509_(x, y + height - 1, x + width, y + height, color);
        graphics.m_280509_(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public static void drawRoundedBox(GuiGraphics graphics, int x, int y, int width, int height, int backgroundColor) {
        graphics.m_280509_(x - 3 + 1, y, x + width + 2 - 1, y + 1, backgroundColor);
        graphics.m_280509_(x - 3, y + 1, x + width + 2, y + height - 1, backgroundColor);
        graphics.m_280509_(x - 3 + 1, y + height - 1, x + width + 2 - 1, y + height, backgroundColor);
    }

    public static Optional<GuiEventListener> findHoveredListener(Screen screen, double mouseX, double mouseY, Predicate<GuiEventListener> condition) {
        return ScreenHelper.findHoveredListener(screen.m_6702_(), mouseX, mouseY, condition);
    }

    private static Optional<GuiEventListener> findHoveredListener(List<? extends GuiEventListener> listeners, double mouseX, double mouseY, Predicate<GuiEventListener> condition) {
        for (GuiEventListener guiEventListener : listeners) {
            TabButton button;
            if (condition.test(guiEventListener) && guiEventListener.m_5953_(mouseX, mouseY)) {
                return Optional.of(guiEventListener);
            }
            if (guiEventListener instanceof TabButton && (button = (TabButton)guiEventListener).m_274319_()) {
                ArrayList children = new ArrayList();
                button.m_274356_().m_267609_(children::add);
                return ScreenHelper.findHoveredListener(children, mouseX, mouseY, condition);
            }
            if (!(guiEventListener instanceof ContainerEventHandler)) continue;
            ContainerEventHandler handler = (ContainerEventHandler)guiEventListener;
            return ScreenHelper.findHoveredListener(handler.m_6702_(), mouseX, mouseY, condition);
        }
        return Optional.empty();
    }
}

