/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.components.TabOptionBaseItem;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.widget.LazySlider;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.config.DoubleProperty;
import com.mrcrayfish.framework.api.config.validate.NumberRange;
import com.mrcrayfish.framework.api.config.validate.Validator;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class TabOptionSliderItem
extends TabOptionBaseItem
implements Navigatable {
    private final LazySlider slider;
    private long lastChange;
    private boolean save;

    public TabOptionSliderItem(DoubleProperty property, double stepSize) {
        super((Component)Component.m_237115_((String)property.getTranslationKey()));
        Validator validator = property.getValidator();
        if (!(validator instanceof NumberRange)) {
            throw new IllegalArgumentException("Double property must have a number range");
        }
        NumberRange range = (NumberRange)validator;
        this.slider = new LazySlider(0, 0, 100, 20, this.label, (Double)property.get(), (Double)range.minValue(), (Double)range.maxValue(), stepSize, arg_0 -> ((DoubleProperty)property).set(arg_0));
        this.slider.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)property.getComment())));
        this.slider.m_257427_(500);
        this.slider.valueOnly();
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return ImmutableList.of((Object)((Object)this.slider));
    }

    @Override
    public List<GuiEventListener> elements() {
        return Collections.emptyList();
    }

    @Override
    public void m_6311_(GuiGraphics graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
        super.m_6311_(graphics, slotIndex, top, left, listWidth, slotHeight, mouseX, mouseY, hovered, partialTick);
        this.slider.m_252865_(left + listWidth - this.slider.m_5711_() - 20);
        this.slider.m_253211_(top);
        this.slider.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (Controllable.getInput().isControllerInUse() && ScreenHelper.isMouseWithin(left, top, listWidth, slotHeight, mouseX, mouseY)) {
            ClientHelper.drawButton(graphics, left + listWidth - this.slider.m_5711_() - 20 - 17, top + (slotHeight - 11) / 2, 11);
            ClientHelper.drawButton(graphics, left + listWidth - 16, top + (slotHeight - 11) / 2, 12);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastChange > 100L) {
                boolean changing = false;
                if (ButtonBindings.NEXT_RECIPE_TAB.isButtonDown()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11670_, (float)0.7f, (float)0.25f));
                    this.slider.stepBackward();
                    this.lastChange = currentTime;
                    this.save = true;
                    changing = true;
                } else if (ButtonBindings.PREVIOUS_RECIPE_TAB.isButtonDown()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11670_, (float)0.75f, (float)0.25f));
                    this.slider.stepForward();
                    this.lastChange = currentTime;
                    this.save = true;
                    changing = true;
                }
                if (!changing && this.save) {
                    this.slider.triggerChangeCallback();
                    this.save = false;
                }
            }
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.slider.m_6348_(mouseX, mouseY, button);
    }
}

