/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.ControllerManager;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class ControllerList
extends TabSelectionList<ControllerEntry> {
    private static final ResourceLocation BEACON_TEXTURE = new ResourceLocation("textures/gui/container/beacon.png");
    private final ControllerManager manager = Controllable.getManager();
    private final MutableComponent footerSubText;
    private int controllerCount;

    public ControllerList(Minecraft mc, int itemHeight) {
        super(mc, itemHeight);
        this.setHeaderText((Component)Component.m_237115_((String)"controllable.gui.title.select_controller").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}));
        this.footerSubText = Component.m_237115_((String)"controllable.gui.controller_missing_2").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD});
        this.footerSubText.m_6270_(this.footerSubText.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://mrcrayfish.gitbook.io/controllable-documentation/")));
        this.setFooterText((Component)Component.m_237110_((String)"controllable.gui.controller_missing", (Object[])new Object[]{this.footerSubText}));
        this.reloadControllers();
    }

    private void reloadControllers() {
        this.m_93516_();
        Map<Number, Pair<Integer, String>> controllers = this.manager.getControllers();
        controllers.forEach((jid, pair) -> this.addEntry(new ControllerEntry((Number)jid, (Integer)pair.getLeft(), (String)pair.getRight())));
        this.updateSelected();
    }

    protected boolean m_7987_(int index) {
        return Objects.equals(this.m_93511_(), this.m_6702_().get(index));
    }

    private void updateSelected() {
        Controller controller = Controllable.getController();
        if (controller == null) {
            this.m_6987_(null);
            return;
        }
        List entries = this.m_6702_();
        for (ControllerEntry entry : entries) {
            if (!Objects.equals(entry.getJid(), controller.getJid())) continue;
            this.m_6987_((AbstractSelectionList.Entry)entry);
            break;
        }
    }

    public void tick() {
        if (this.controllerCount != this.manager.getControllerCount()) {
            this.controllerCount = this.manager.getControllerCount();
            this.reloadControllers();
        }
        this.updateSelected();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int footerSubWidth;
        Font font;
        int footerWidth;
        if (this.footerText != null && ScreenHelper.isMouseWithin(this.f_93393_ + (this.f_93388_ + (footerWidth = (font = this.f_93386_.f_91062_).m_92852_((FormattedText)this.footerText))) / 2 - (footerSubWidth = font.m_92852_((FormattedText)this.footerSubText)), this.f_93391_ + 4, footerSubWidth, 14, (int)mouseX, (int)mouseY)) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91080_).m_5561_(this.footerSubText.m_7383_());
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public class ControllerEntry
    extends TabSelectionList.Item<ControllerEntry> {
        private final Number jid;
        private final int deviceIndex;

        public ControllerEntry(Number jid, int deviceIndex, String name) {
            super((Component)Component.m_237113_((String)name));
            this.jid = jid;
            this.deviceIndex = deviceIndex;
        }

        public Number getJid() {
            return this.jid;
        }

        public int getDeviceIndex() {
            return this.deviceIndex;
        }

        public void m_6311_(GuiGraphics graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (ControllerList.this.m_93511_() == this) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.m_280163_(BEACON_TEXTURE, left + 3, top + 3, 91.0f, 224.0f, 14, 12, 256, 256);
            } else if (slotIndex % 2 != 0) {
                graphics.m_280509_(left - 2, top - 2, left + listWidth + 2, top + slotHeight + 2, 0x55000000);
            }
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(font);
            graphics.m_280430_(font, this.label, left + 22, top + (slotHeight - 9) / 2 + 1, 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (ControllerList.this.m_93511_() != this) {
                    ControllerList.this.m_6987_((AbstractSelectionList.Entry)this);
                    ControllerList.this.manager.setActiveController(ControllerList.this.manager.createController(this.deviceIndex, this.jid));
                } else {
                    ControllerList.this.m_6987_(null);
                    ControllerList.this.manager.setActiveController(null);
                }
            }
            return false;
        }
    }
}

