/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Icons;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ISearchable;
import com.mrcrayfish.controllable.client.gui.components.TabOptionBaseItem;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.SelectKeyBindingScreen;
import com.mrcrayfish.controllable.client.gui.screens.SettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ButtonBindingList
extends TabSelectionList<TabSelectionList.BaseItem> {
    private final SettingsScreen settingsScreen;
    protected Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    public ButtonBindingList(SettingsScreen settingsScreen, Minecraft mc, int itemHeight) {
        super(mc, itemHeight);
        this.settingsScreen = settingsScreen;
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        this.categories.put("key.categories.controllable_custom", new ArrayList());
        this.repopulateBindings(false);
    }

    private void repopulateBindings(boolean showUnbound) {
        this.m_93516_();
        MutableComponent addKeybind = Component.m_237119_().m_7220_((Component)ClientHelper.getIconComponent(Icons.ADD)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"controllable.gui.add_key_bind"));
        MutableComponent restoreDefaults = Component.m_237119_().m_7220_((Component)ClientHelper.getIconComponent(Icons.RESET)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"controllable.gui.restore_defaults"));
        this.addEntry(new TwoWidgetItem((AbstractWidget)Button.m_253074_((Component)addKeybind, btn -> this.f_93386_.m_91152_((Screen)new SelectKeyBindingScreen(this.settingsScreen, () -> this.repopulateBindings(false)))).m_253136_(), (AbstractWidget)Button.m_253074_((Component)restoreDefaults, btn -> this.f_93386_.m_91152_((Screen)new ConfirmationScreen(this.settingsScreen, (Component)Component.m_237115_((String)"controllable.gui.reset_selected_bindings"), result -> {
            if (result.booleanValue()) {
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.getBindings().forEach(ButtonBinding::reset);
                registry.resetBindingHash();
                registry.save();
            }
            return true;
        }))).m_253136_()));
        this.categories.forEach((category, list) -> list.clear());
        BindingRegistry.getInstance().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            if (showUnbound && binding.getButton() != -1) {
                return;
            }
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.addEntry(new TabSelectionList.TitleItem((TabSelectionList)this, (Component)Component.m_237115_((String)category).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
                list.forEach(binding -> this.addEntry(new ButtonBindingItem((ButtonBinding)binding)));
            }
        });
    }

    public static class TwoWidgetItem
    extends TabSelectionList.BaseItem {
        private final AbstractWidget leftWidget;
        private final AbstractWidget rightWidget;

        public TwoWidgetItem(AbstractWidget leftWidget, AbstractWidget rightWidget) {
            super(CommonComponents.f_237098_);
            this.leftWidget = leftWidget;
            this.rightWidget = rightWidget;
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.leftWidget.m_93674_(width / 2 - 10);
            this.leftWidget.m_252865_(left + 5);
            this.leftWidget.m_253211_(top);
            this.leftWidget.m_88315_(graphics, mouseX, mouseY, partialTick);
            this.rightWidget.m_93674_(width / 2 - 10);
            this.rightWidget.m_252865_(left + width / 2 + 5);
            this.rightWidget.m_253211_(top);
            this.rightWidget.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.leftWidget, (Object)this.rightWidget);
        }
    }

    public class ButtonBindingItem
    extends TabOptionBaseItem
    implements ISearchable {
        private final ButtonBinding binding;
        private final Button bindingButton;
        private final Button resetButton;

        protected ButtonBindingItem(ButtonBinding binding) {
            super((Component)Component.m_237115_((String)binding.getLabelKey()));
            this.binding = binding;
            this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> {
                if (button == 0) {
                    ButtonBindingList.this.settingsScreen.setSelectedBinding(this.binding);
                    return true;
                }
                if (button == 1) {
                    this.binding.setButton(-1);
                    BindingRegistry registry = BindingRegistry.getInstance();
                    registry.resetBindingHash();
                    registry.save();
                    return true;
                }
                return false;
            });
            this.resetButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 108, 0, 16, 16, button -> {
                binding.reset();
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.resetBindingHash();
                registry.save();
            });
        }

        private List<Component> getBindingTooltip(ButtonBinding binding) {
            if (Controllable.getInput().isControllerInUse()) {
                ArrayList<Component> components = new ArrayList<Component>();
                components.add((Component)Component.m_237110_((String)"controllable.gui.change_binding", (Object[])new Object[]{ClientHelper.getButtonComponent(0)}).m_130940_(ChatFormatting.YELLOW));
                if (binding.getButton() != -1) {
                    components.add((Component)Component.m_237110_((String)"controllable.gui.clear_binding", (Object[])new Object[]{ClientHelper.getButtonComponent(2)}).m_130940_(ChatFormatting.YELLOW));
                }
                return components;
            }
            ArrayList<Component> components = new ArrayList<Component>();
            components.add((Component)Component.m_237110_((String)"controllable.gui.change_binding", (Object[])new Object[]{InputConstants.Type.MOUSE.m_84895_(0).m_84875_().m_6881_().m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
            if (binding.getButton() != -1) {
                components.add((Component)Component.m_237110_((String)"controllable.gui.clear_binding", (Object[])new Object[]{InputConstants.Type.MOUSE.m_84895_(1).m_84875_().m_6881_().m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
            }
            return components;
        }

        @Override
        public Component getLabel() {
            return this.label;
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.bindingButton, (Object)this.resetButton);
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int itemHeight, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.setLabelColor(this.binding.isConflictingContext() ? ChatFormatting.RED.m_126665_() : ChatFormatting.WHITE.m_126665_());
            super.m_6311_(graphics, index, top, left, width, itemHeight, mouseX, mouseY, selected, partialTick);
            this.bindingButton.m_257544_(ClientHelper.createListTooltip(this.getBindingTooltip(this.binding)));
            this.bindingButton.m_257427_(400);
            this.bindingButton.m_252865_(left + width - 65);
            this.bindingButton.m_253211_(top - 1);
            this.bindingButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            this.resetButton.m_252865_(left + width - 24);
            this.resetButton.m_253211_(top - 1);
            this.resetButton.f_93623_ = !this.binding.isDefault();
            this.resetButton.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.resetButton.m_274382_() && Controllable.getInput().isControllerInUse()) {
                this.bindingButton.m_6375_((double)this.bindingButton.m_252754_(), (double)this.bindingButton.m_252907_(), button);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, ButtonBindingItem.this.label);
                }
            });
        }
    }
}

