/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.screens.RadialMenuConfigureScreen;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;

public class RadialMenuHandler {
    private static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private static final int ANIMATE_DURATION = 5;
    private static RadialMenuHandler instance;
    private boolean loaded;
    private boolean visible;
    private int animateTicks;
    private int prevAnimateTicks;
    private Set<ButtonBindingData> bindings = new LinkedHashSet<ButtonBindingData>();
    private AbstractRadialItem settingsItem;
    private AbstractRadialItem closeItem;
    private List<AbstractRadialItem> allItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> leftItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> rightItems = new ArrayList<AbstractRadialItem>();
    private AbstractRadialItem selected;

    public static RadialMenuHandler instance() {
        if (instance == null) {
            instance = new RadialMenuHandler();
        }
        return instance;
    }

    private RadialMenuHandler() {
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onClientTickStart));
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)this::onClientTickEnd));
        TickEvents.END_RENDER.register((IFrameworkEvent)((ITickEvent.EndRender)this::onRenderEnd));
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));){
                JsonArray bindings = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
                bindings.forEach(element -> {
                    JsonObject object = element.getAsJsonObject();
                    String key = GsonHelper.m_13906_((JsonObject)object, (String)"key");
                    String colorName = GsonHelper.m_13906_((JsonObject)object, (String)"color");
                    ButtonBinding binding = BindingRegistry.getInstance().getBindingByDescriptionKey(key);
                    if (binding != null) {
                        ChatFormatting color = ChatFormatting.m_126657_((String)colorName);
                        if (color == null || color.m_126665_() == null) {
                            color = ChatFormatting.YELLOW;
                        }
                        this.bindings.add(new ButtonBindingData(binding, color));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.bindings.addAll(this.getBindings());
            this.save();
        }
        this.loaded = true;
    }

    private void save() {
        JsonArray array = new JsonArray();
        this.bindings.forEach(data -> {
            JsonObject object = new JsonObject();
            object.addProperty("key", data.getBinding().getDescription());
            object.addProperty("color", data.getColor().name());
            array.add((JsonElement)object);
        });
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)array);
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
            writer.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ButtonBindingData> getDefaults() {
        ArrayList<ButtonBindingData> defaults = new ArrayList<ButtonBindingData>();
        defaults.add(new ButtonBindingData(ButtonBindings.OPEN_CONTROLLABLE_SETTINGS, ChatFormatting.BLUE));
        defaults.add(new ButtonBindingData(ButtonBindings.ADVANCEMENTS, ChatFormatting.YELLOW));
        defaults.add(new ButtonBindingData(ButtonBindings.SCREENSHOT, ChatFormatting.YELLOW));
        defaults.add(new ButtonBindingData(ButtonBindings.FULLSCREEN, ChatFormatting.YELLOW));
        return defaults;
    }

    public void interact() {
        if (this.visible) {
            if (this.selected != null) {
                this.selected.onUseItem(this);
            }
        } else {
            this.load();
            this.setVisibility(true);
            this.populateAndConstruct();
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12492_, (float)1.5f));
        }
    }

    public AbstractRadialItem getSelected() {
        return this.selected;
    }

    public LinkedHashSet<ButtonBindingData> getBindings() {
        return new LinkedHashSet<ButtonBindingData>(this.bindings);
    }

    public void setBindings(Set<ButtonBindingData> bindings) {
        this.bindings = bindings;
        this.save();
        this.populateAndConstruct();
    }

    public void removeBinding(ButtonBinding binding) {
        if (this.bindings.removeIf(data -> data.getBinding() == binding)) {
            this.save();
            this.populateAndConstruct();
        }
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    public void clearAnimation() {
        this.animateTicks = 0;
        this.prevAnimateTicks = 0;
    }

    private void populateAndConstruct() {
        this.rightItems.clear();
        this.leftItems.clear();
        ArrayList<AbstractRadialItem> items = new ArrayList<AbstractRadialItem>();
        this.bindings.forEach(binding -> items.add(new ButtonBindingItem((ButtonBindingData)binding)));
        int rightSize = items.size() / 2;
        for (int i = 0; i < rightSize; ++i) {
            float gap = 180.0f / (float)(rightSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(gap * (float)i + gap);
            this.rightItems.add(item);
        }
        int leftSize = items.size() - rightSize;
        for (int i = rightSize; i < items.size(); ++i) {
            float gap = 180.0f / (float)(leftSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(360.0f - gap * (float)(i - rightSize) - gap);
            this.leftItems.add((AbstractRadialItem)items.get(i));
        }
        this.settingsItem = new RadialSettingsItem();
        this.settingsItem.setAngle(0.0f);
        items.add(this.settingsItem);
        this.closeItem = new CloseRadialMenuItem();
        this.closeItem.setAngle(180.0f);
        items.add(this.closeItem);
        this.selected = this.closeItem;
        this.allItems = items;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void onClientTickStart() {
        if (!this.visible || !Controllable.getInput().isControllerInUse()) {
            // empty if block
        }
    }

    public void onRenderEnd(float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91080_ != null) {
            return;
        }
        if (Controllable.getController() != null && (this.visible || this.animateTicks > 0 || this.prevAnimateTicks > 0)) {
            this.renderRadialMenu(partialTick);
        }
    }

    private void onClientTickEnd() {
        this.prevAnimateTicks = this.animateTicks;
        if (this.visible) {
            if (this.animateTicks < 5) {
                ++this.animateTicks;
            }
        } else if (this.animateTicks > 0) {
            --this.animateTicks;
        }
    }

    private void renderRadialMenu(float partialTick) {
        this.updateSelected();
        PoseStack modelStack = RenderSystem.getModelViewStack();
        modelStack.m_85836_();
        modelStack.m_166856_();
        modelStack.m_252880_(0.0f, 0.0f, 1000.0f - ClientServices.CLIENT.getGuiFarPlane());
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics graphics = new GuiGraphics(mc, mc.m_91269_().m_110104_());
        PoseStack poseStack = graphics.m_280168_();
        float animation = Mth.m_14179_((float)partialTick, (float)this.prevAnimateTicks, (float)this.animateTicks) / 5.0f;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        animation = (float)(1.0 + (double)c3 * Math.pow(animation - 1.0f, 3.0) + (double)c1 * Math.pow(animation - 1.0f, 2.0));
        graphics.m_280509_(0, 0, mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_(), 2014318608);
        poseStack.m_252880_(0.0f, -10.0f, 0.0f);
        poseStack.m_252880_((float)((int)((float)mc.m_91268_().m_85445_() / 2.0f)), (float)((int)((float)mc.m_91268_().m_85446_() / 2.0f)), 0.0f);
        poseStack.m_85836_();
        this.settingsItem.draw(graphics, mc, false, this.selected == this.settingsItem, animation);
        poseStack.m_85849_();
        poseStack.m_85836_();
        this.closeItem.draw(graphics, mc, false, this.selected == this.closeItem, animation);
        poseStack.m_85849_();
        this.drawRadialItems(this.rightItems, graphics, mc, animation);
        this.drawRadialItems(this.leftItems, graphics, mc, animation);
        modelStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private void drawRadialItems(List<AbstractRadialItem> items, GuiGraphics graphics, Minecraft mc, float animation) {
        for (int i = 0; i < items.size(); ++i) {
            AbstractRadialItem item = items.get(i);
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            if (i == 0) {
                poseStack.m_252880_(0.0f, -10.0f, 0.0f);
            }
            if (i == items.size() - 1) {
                poseStack.m_252880_(0.0f, 10.0f, 0.0f);
            }
            boolean left = item.angle >= 180.0f;
            float x = (float)Math.cos(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            float y = (float)Math.sin(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            poseStack.m_252880_((float)((int)x), (float)((int)y), 0.0f);
            item.draw(graphics, mc, left, this.selected == item, animation);
            poseStack.m_85849_();
        }
    }

    private void updateSelected() {
        float inputY;
        if (!this.visible) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        float threshold = 0.5f;
        float inputX = Config.CLIENT.client.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickXValue() : controller.getLThumbStickXValue();
        float f = inputY = Config.CLIENT.client.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(inputX) <= threshold && Math.abs(inputY) <= threshold) {
            return;
        }
        float selectedAngle = (float)(Mth.m_14175_((double)(Math.toDegrees(Math.atan2(inputY, inputX)) - 90.0)) + 180.0);
        Optional closest = this.allItems.stream().min((o1, o2) -> Mth.m_14145_((float)o1.angle, (float)selectedAngle) > Mth.m_14145_((float)o2.angle, (float)selectedAngle) ? 1 : 0);
        if (closest.isEmpty()) {
            return;
        }
        if (closest.get() == this.selected) {
            return;
        }
        this.selected = (AbstractRadialItem)closest.get();
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)Config.CLIENT.client.options.uiSounds.get()).booleanValue()) {
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12019_, (float)1.5f));
        }
    }

    private Optional<AbstractRadialItem> getSelectedItem() {
        return Optional.empty();
    }

    public static abstract class AbstractRadialItem {
        protected Component label;
        protected Component description;
        private float angle;

        protected AbstractRadialItem(Component label) {
            this(label, null);
        }

        protected AbstractRadialItem(Component label, Component description) {
            this.label = label;
            this.description = description;
        }

        public Component getLabel() {
            return this.label;
        }

        @Nullable
        public Component getDescription() {
            return this.description;
        }

        public boolean isEmpty() {
            return false;
        }

        public abstract void onUseItem(RadialMenuHandler var1);

        protected abstract void draw(GuiGraphics var1, Minecraft var2, boolean var3, boolean var4, float var5);

        protected void playSound(SoundEvent event, float pitch) {
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)pitch));
        }

        void setAngle(float angle) {
            this.angle = angle;
        }
    }

    public static final class RadialSettingsItem
    extends AbstractRadialItem {
        private static final Component LABEL = Component.m_237115_((String)"controllable.gui.configure");

        public RadialSettingsItem() {
            super((Component)Component.m_237115_((String)"controllable.gui.radial.settings"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            handler.clearAnimation();
            Minecraft.m_91087_().m_91152_((Screen)new RadialMenuConfigureScreen(handler.getBindings()));
        }

        @Override
        protected void draw(GuiGraphics graphics, Minecraft mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.f_91066_.m_92170_(0.7f);
            float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
            float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_252880_(0.0f, -90.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280411_(TEXTURE, -10, -10, 20, 20, 88.0f, 15.0f, 10, 10, 256, 256);
            if (selected) {
                graphics.m_280653_(mc.f_91062_, LABEL, 0, 21, 0xFFFFFF);
            }
        }
    }

    public static final class CloseRadialMenuItem
    extends AbstractRadialItem {
        private static final Component LABEL = Component.m_237115_((String)"controllable.gui.close");

        public CloseRadialMenuItem() {
            super((Component)Component.m_237115_((String)"controllable.gui.radial.close"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12492_, (float)1.3f));
        }

        @Override
        protected void draw(GuiGraphics graphics, Minecraft mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.f_91066_.m_92170_(0.7f);
            float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
            float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_252880_(0.0f, 90.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), -14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280411_(TEXTURE, -10, -10, 20, 20, 98.0f, 15.0f, 10, 10, 256, 256);
            if (selected) {
                graphics.m_280653_(mc.f_91062_, LABEL, 0, -30, 0xFFFFFF);
            }
        }
    }

    private static class ButtonBindingItem
    extends AbstractRadialItem {
        public ButtonBindingData entry;

        public ButtonBindingItem(ButtonBindingData entry) {
            super((Component)Component.m_237115_((String)entry.getBinding().getLabelKey()).m_130940_(entry.getColor()), (Component)Component.m_237115_((String)entry.getBinding().getCategory()));
            this.entry = entry;
        }

        @Override
        public void onUseItem(RadialMenuHandler radialMenu) {
            radialMenu.setVisibility(false);
            radialMenu.clearAnimation();
            this.entry.getBinding().setActiveAndPressed();
            Controllable.getInput().handleButtonInput(Controllable.getController(), -1, true, true);
        }

        @Override
        protected void draw(GuiGraphics graphics, Minecraft mc, boolean left, boolean selected, float animation) {
            int offset;
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            int color = selected ? -3355444 : mc.f_91066_.m_92170_(0.7f);
            float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
            float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            float start = left ? -1.0f : 1.0f;
            float end = (left ? -150.0f : 150.0f) * animation;
            poseStack.m_252880_((1.0f - animation) * (float)(left ? -20 : 20), 0.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), start, -15.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), start, -14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), end, -14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), end, -15.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), end, 14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), end, -14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), start, 14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), start, 15.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), end, 15.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), end, 14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            if (this.label != null) {
                offset = !left ? 5 : -mc.f_91062_.m_92852_((FormattedText)this.label) - 5;
                graphics.m_280430_(mc.f_91062_, this.label, offset, -10, -1);
            }
            if (this.description != null) {
                offset = !left ? 5 : -mc.f_91062_.m_92852_((FormattedText)this.description) - 5;
                graphics.m_280430_(mc.f_91062_, this.description, offset, 2, -1);
            }
            poseStack.m_85849_();
        }
    }
}

