/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListEntryNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListWidgetNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SkipItem;
import com.mrcrayfish.controllable.client.gui.navigation.SlotNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.SettingsScreen;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.EventHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.controllable.event.ControllerEvents;
import com.mrcrayfish.controllable.event.Value;
import com.mrcrayfish.controllable.integration.EmiSupport;
import com.mrcrayfish.controllable.integration.JeiSupport;
import com.mrcrayfish.controllable.integration.ReiSupport;
import com.mrcrayfish.controllable.mixin.client.OverlayRecipeComponentAccessor;
import com.mrcrayfish.controllable.mixin.client.RecipeBookComponentAccessor;
import com.mrcrayfish.controllable.mixin.client.RecipeBookPageAccessor;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.framework.api.event.ClientEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IClientEvent;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.joml.Vector3d;
import org.lwjgl.glfw.GLFW;

public class ControllerInput {
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private int lastUse = 0;
    private boolean keyboardSneaking = false;
    private boolean sneaking = false;
    private boolean isFlying = false;
    private Slot nearSlot = null;
    private boolean moving = false;
    private boolean preventReset;
    private boolean ignoreInput;
    private boolean hideVirtualCursor;
    private double virtualCursorX;
    private double virtualCursorY;
    private int prevCursorX;
    private int prevCursorY;
    private int cursorX;
    private int cursorY;
    private double cursorSpeedX;
    private double cursorSpeedY;
    private boolean moved;
    private boolean snapToSlot;
    private float targetPitch;
    private float targetYaw;
    private long lastMerchantScroll;
    private int dropCounter = -1;

    public ControllerInput() {
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onClientTick));
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onClientTickStart));
        TickEvents.END_RENDER.register((IFrameworkEvent)((ITickEvent.EndRender)this::onRenderTickEnd));
        ScreenEvents.OPENED.register((IFrameworkEvent)((IScreenEvent.Opened)this::onScreenOpened));
        ScreenEvents.BEFORE_DRAW.register((IFrameworkEvent)((IScreenEvent.BeforeDraw)this::onScreenRenderPre));
        ClientEvents.PLAYER_INPUT_UPDATE.register((IFrameworkEvent)((IClientEvent.PlayerInputUpdate)this::onInputUpdate));
    }

    public double getVirtualCursorX() {
        return this.virtualCursorX;
    }

    public double getVirtualCursorY() {
        return this.virtualCursorY;
    }

    public double getScaledCursorX() {
        Window window = Minecraft.m_91087_().m_91268_();
        return this.virtualCursorX * (double)window.m_85445_() / (double)window.m_85441_();
    }

    public double getScaledCursorY() {
        Window window = Minecraft.m_91087_().m_91268_();
        return this.virtualCursorY * (double)window.m_85446_() / (double)window.m_85442_();
    }

    public boolean isVirtualCursorActive() {
        return Controllable.getController() != null && this.lastUse > 0 && (Boolean)Config.CLIENT.client.options.virtualCursor.get() != false;
    }

    private void setControllerInUse() {
        this.lastUse = 100;
    }

    public boolean isControllerInUse() {
        return this.lastUse > 0;
    }

    public int getLastUse() {
        return this.lastUse;
    }

    public void resetLastUse() {
        if (!this.preventReset) {
            this.lastUse = 0;
        }
        this.preventReset = false;
    }

    public boolean isMovingCursor() {
        return this.moving;
    }

    public boolean isVirtualCursorHidden() {
        return this.hideVirtualCursor;
    }

    public double getVirtualCursorX(float partialTick) {
        return (float)this.prevCursorX + (float)(this.cursorX - this.prevCursorX) * partialTick;
    }

    public double getVirtualCursorY(float partialTick) {
        return (float)this.prevCursorY + (float)(this.cursorY - this.prevCursorY) * partialTick;
    }

    public Slot getNearSlot() {
        return this.nearSlot;
    }

    private void onClientTick() {
        Controller controller;
        this.prevCursorX = this.cursorX;
        this.prevCursorY = this.cursorY;
        this.cursorSpeedX = 0.0;
        this.cursorSpeedY = 0.0;
        if (this.lastUse > 0) {
            --this.lastUse;
        }
        if ((controller = Controllable.getController()) == null) {
            return;
        }
        if ((Math.abs(controller.getLTriggerValue()) > 0.0f || Math.abs(controller.getRTriggerValue()) > 0.0f) && !(Minecraft.m_91087_().f_91080_ instanceof ControllerLayoutScreen)) {
            this.setControllerInUse();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null || mc.f_91080_ instanceof ControllerLayoutScreen) {
            return;
        }
        float threshold = 0.35f;
        boolean lastMoving = this.moving;
        float inputX = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getLThumbStickXValue() : controller.getRThumbStickXValue();
        float inputY = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getLThumbStickYValue() : controller.getRThumbStickYValue();
        boolean bl = this.moving = Math.abs(inputX) >= threshold || Math.abs(inputY) >= threshold;
        if (this.moving) {
            if (!lastMoving) {
                double cursorX = mc.f_91067_.m_91589_();
                double cursorY = mc.f_91067_.m_91594_();
                if (Controllable.getController() != null && ((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue()) {
                    cursorX = this.virtualCursorX;
                    cursorY = this.virtualCursorY;
                }
                this.prevCursorX = this.cursorX = (int)cursorX;
                this.prevCursorY = this.cursorY = (int)cursorY;
            }
            this.cursorSpeedX = Math.abs(inputX) >= threshold ? (double)ClientHelper.applyDeadzone(inputX, threshold) : 0.0;
            this.cursorSpeedY = Math.abs(inputY) >= threshold ? (double)ClientHelper.applyDeadzone(inputY, threshold) : 0.0;
            this.setControllerInUse();
        }
        if (this.lastUse <= 0) {
            return;
        }
        if (Math.abs(this.cursorSpeedX) > 0.0 || Math.abs(this.cursorSpeedY) > 0.0) {
            GuiEventListener hoveredListener;
            RecipeBookComponent recipeBook;
            AbstractContainerScreen screen;
            double cursorSpeed = (Double)Config.CLIENT.client.options.cursorSpeed.get() * mc.m_91268_().m_85449_();
            Screen screen2 = mc.f_91080_;
            if (screen2 instanceof AbstractContainerScreen && ClientServices.CLIENT.getSlotUnderMouse(screen = (AbstractContainerScreen)screen2) != null) {
                cursorSpeed *= ((Double)Config.CLIENT.client.options.hoverModifier.get()).doubleValue();
            }
            double cursorX = this.virtualCursorX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
            double cursorY = this.virtualCursorY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
            ArrayList<Object> eventListeners = new ArrayList<Object>(mc.f_91080_.m_6702_());
            if (mc.f_91080_ instanceof RecipeUpdateListener && (recipeBook = ((RecipeUpdateListener)mc.f_91080_).m_5564_()).m_100385_()) {
                eventListeners.add(((RecipeBookComponentAccessor)recipeBook).controllableGetFilterButton());
                eventListeners.addAll(((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeTabs());
                RecipeBookPage recipeBookPage = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
                eventListeners.addAll(((RecipeBookPageAccessor)recipeBookPage).controllableGetButtons());
                eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).controllableGetForwardButton());
                eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).controllableGetBackButton());
            }
            if ((hoveredListener = (GuiEventListener)eventListeners.stream().filter(o -> o != null && o.m_5953_(cursorX, cursorY)).findFirst().orElse(null)) instanceof AbstractSelectionList) {
                AbstractSelectionList list = (AbstractSelectionList)hoveredListener;
                hoveredListener = null;
                int count = list.m_6702_().size();
                for (int i = 0; i < count; ++i) {
                    ContainerEventHandler handler;
                    GuiEventListener hovered;
                    Object entry;
                    int rowTop = ClientServices.CLIENT.getAbstractListRowTop(list, i);
                    int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(list, i);
                    int listTop = ClientServices.CLIENT.getAbstractListTop(list);
                    int listBottom = ClientServices.CLIENT.getAbstractListBottom(list);
                    if (rowTop < listTop && rowBottom > listBottom || !((entry = list.m_6702_().get(i)) instanceof ContainerEventHandler) || (hovered = (GuiEventListener)(handler = (ContainerEventHandler)entry).m_6702_().stream().filter(o -> o != null && o.m_5953_(cursorX, cursorY)).findFirst().orElse(null)) == null) continue;
                    hoveredListener = hovered;
                    break;
                }
            }
            if (hoveredListener != null) {
                cursorSpeed *= ((Double)Config.CLIENT.client.options.hoverModifier.get()).doubleValue();
            }
            this.cursorX = (int)((double)this.cursorX + cursorSpeed * this.cursorSpeedX);
            this.cursorY = (int)((double)this.cursorY + cursorSpeed * this.cursorSpeedY);
            this.clampCursorToWindowBounds();
            this.setControllerInUse();
            this.moved = true;
            this.snapToSlot = true;
            this.hideVirtualCursor = false;
        } else if (this.snapToSlot) {
            this.snapToContainerSlot();
            this.snapToSlot = false;
        }
        if (mc.f_91080_ instanceof CreativeModeInventoryScreen) {
            this.handleCreativeScrolling((CreativeModeInventoryScreen)mc.f_91080_, controller);
        }
        if (((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue() && (this.cursorX != this.prevCursorX || this.cursorY != this.prevCursorY)) {
            this.performMouseDrag(this.virtualCursorX, this.virtualCursorY, this.cursorX - this.prevCursorX, this.cursorY - this.prevCursorY);
        }
    }

    private void onScreenOpened(Screen screen) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            this.nearSlot = null;
            this.moved = false;
            this.cursorSpeedX = 0.0;
            this.cursorSpeedY = 0.0;
            this.cursorX = this.prevCursorX = (int)((float)mc.m_91268_().m_85441_() / 2.0f);
            this.virtualCursorX = this.prevCursorX;
            this.cursorY = this.prevCursorY = (int)((float)mc.m_91268_().m_85442_() / 2.0f);
            this.virtualCursorY = this.prevCursorY;
        }
        this.hideVirtualCursor = false;
    }

    private void onScreenRenderPre(Screen screen, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        if (!(mc.f_91080_ == null || this.cursorX == this.prevCursorX && this.cursorY == this.prevCursorY || mc.f_91080_ instanceof ControllerLayoutScreen)) {
            float partialTicks = Minecraft.m_91087_().m_91296_();
            double renderCursorX = (double)((float)this.prevCursorX + (float)(this.cursorX - this.prevCursorX) * partialTicks) + 0.5;
            double renderCursorY = (double)((float)this.prevCursorY + (float)(this.cursorY - this.prevCursorY) * partialTicks) + 0.5;
            this.setCursorPosition(renderCursorX, renderCursorY);
        }
        this.nearSlot = null;
        Screen renderCursorX = mc.f_91080_;
        if (renderCursorX instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)renderCursorX;
            if (this.moved) {
                int guiLeft = ClientServices.CLIENT.getScreenLeft(containerScreen);
                int guiTop = ClientServices.CLIENT.getScreenTop(containerScreen);
                double guiScale = mc.m_91268_().m_85449_();
                int cursorX = (int)((double)this.cursorX / guiScale);
                int cursorY = (int)((double)this.cursorY / guiScale);
                Slot closestSlot = null;
                double closestDistance = -1.0;
                for (Slot slot : containerScreen.m_6262_().f_38839_) {
                    int posX = guiLeft + slot.f_40220_ + 8;
                    int posY = guiTop + slot.f_40221_ + 8;
                    double distance = Math.sqrt(Math.pow(posX - cursorX, 2.0) + Math.pow(posY - cursorY, 2.0));
                    if (closestDistance != -1.0 && !(distance < closestDistance) || !(distance <= 14.0)) continue;
                    closestSlot = slot;
                    closestDistance = distance;
                }
                if (closestSlot != null && (closestSlot.m_6657_() || !containerScreen.m_6262_().m_142621_().m_41619_())) {
                    this.nearSlot = closestSlot;
                }
            }
        }
    }

    private void performMouseDrag(double cursorX, double cursorY, double dragX, double dragY) {
        if (Controllable.getController() != null) {
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (screen != null && mc.m_91265_() == null) {
                double finalCursorX = cursorX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
                double finalCursorY = cursorY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
                Screen.m_96579_(() -> screen.m_94757_(finalCursorX, finalCursorY), (String)"mouseMoved event handler", (String)screen.getClass().getCanonicalName());
                int activeMouseButton = ClientServices.CLIENT.getActiveMouseButton();
                double lastMouseEventTime = ClientServices.CLIENT.getLastMouseEventTime();
                if (activeMouseButton != -1 && lastMouseEventTime > 0.0) {
                    if (screen instanceof AbstractContainerScreen && Controllable.isEmiLoaded() && EmiSupport.invokeMouseDragged(activeMouseButton, finalCursorX, finalCursorY, dragX, dragY)) {
                        return;
                    }
                    ClientServices.CLIENT.sendMouseDrag(screen, dragX, dragY, finalCursorX, finalCursorY, activeMouseButton);
                }
            }
        }
    }

    private void onRenderTickEnd(float partialTick) {
        LocalPlayer player;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        double cursorX = this.virtualCursorX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
        double cursorY = this.virtualCursorY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
        if (mc.f_91080_ != null && this.lastUse > 0) {
            GuiEventListener hoveredListener;
            float yValue;
            Screen screen = mc.f_91080_;
            if (screen instanceof MerchantScreen) {
                MerchantScreen screen2 = (MerchantScreen)screen;
                this.handleMerchantScrolling(screen2, controller);
                return;
            }
            float f = yValue = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
            if (Math.abs(yValue) >= 0.2f && (hoveredListener = (GuiEventListener)ScreenHelper.findHoveredListener(mc.f_91080_, cursorX, cursorY, listener -> listener instanceof AbstractSelectionList).orElse(null)) instanceof AbstractSelectionList) {
                AbstractSelectionList selectionList = (AbstractSelectionList)hoveredListener;
                this.handleListScrolling(selectionList, controller);
            }
        }
        if ((player = mc.f_91074_) == null) {
            return;
        }
        if (mc.f_91080_ == null && (this.targetYaw != 0.0f || this.targetPitch != 0.0f)) {
            float elapsedTicks = Minecraft.m_91087_().m_91297_();
            if (!RadialMenuHandler.instance().isVisible()) {
                player.m_19884_((double)this.targetYaw / 0.15 * (double)((Boolean)Config.CLIENT.client.options.invertRotation.get() != false ? -1 : 1) * (double)elapsedTicks, (double)this.targetPitch / 0.15 * (double)((Boolean)Config.CLIENT.client.options.invertLook.get() != false ? -1 : 1) * (double)elapsedTicks);
            }
            if (player.m_20202_() != null) {
                player.m_20202_().m_7340_((Entity)player);
            }
        }
    }

    private void onClientTickStart() {
        this.targetYaw = 0.0f;
        this.targetPitch = 0.0f;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (mc.f_91080_ == null) {
            boolean canMoveVertically;
            float inputX = controller.getRThumbStickXValue();
            float inputY = controller.getRThumbStickYValue();
            boolean canMoveHorizontally = Math.abs(inputX) > 0.0f;
            boolean bl = canMoveVertically = Math.abs(inputY) > 0.0f;
            if (canMoveHorizontally || canMoveVertically) {
                Value<Float> pitchSpeed;
                float spyglassSensitivity;
                float pitchSensitivity = ((Double)Config.CLIENT.client.options.pitchSensitivity.get()).floatValue();
                float yawSensitivity = ((Double)Config.CLIENT.client.options.yawSensitivity.get()).floatValue();
                float rotationSpeed = ((Double)Config.CLIENT.client.options.rotationSpeed.get()).floatValue();
                Value<Float> yawSpeed = new Value<Float>(Float.valueOf(rotationSpeed * yawSensitivity * (spyglassSensitivity = player.m_150108_() ? ((Double)Config.CLIENT.client.options.spyglassSensitivity.get()).floatValue() : 1.0f)));
                if (!EventHelper.postUpdateCameraEvent(yawSpeed, pitchSpeed = new Value<Float>(Float.valueOf(rotationSpeed * pitchSensitivity * spyglassSensitivity)))) {
                    if (canMoveHorizontally) {
                        this.targetYaw = yawSpeed.get().floatValue() * inputX * 0.33f;
                    }
                    if (canMoveVertically) {
                        this.targetPitch = pitchSpeed.get().floatValue() * inputY * 0.33f;
                    }
                }
                this.setControllerInUse();
            }
        }
        if (mc.f_91080_ == null && ButtonBindings.DROP_ITEM.isButtonDown()) {
            this.setControllerInUse();
            ++this.dropCounter;
        }
        if (this.dropCounter > 20) {
            if (!mc.f_91074_.m_5833_()) {
                mc.f_91074_.m_108700_(true);
            }
            this.dropCounter = 0;
        } else if (this.dropCounter > 0 && !ButtonBindings.DROP_ITEM.isButtonDown()) {
            if (!mc.f_91074_.m_5833_()) {
                mc.f_91074_.m_108700_(false);
            }
            this.dropCounter = 0;
        }
    }

    private void onInputUpdate(Player p, Input input) {
        LocalPlayer player = (LocalPlayer)p;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (this.keyboardSneaking && !mc.f_91066_.f_92090_.m_90857_()) {
            this.sneaking = false;
            this.keyboardSneaking = false;
        }
        if (!((Boolean)mc.f_91066_.m_231831_().m_231551_()).booleanValue()) {
            this.sneaking = ButtonBindings.SNEAK.isButtonDown();
        }
        if (mc.f_91066_.f_92090_.m_90857_()) {
            this.sneaking = true;
            this.keyboardSneaking = true;
        }
        if (player.m_150110_().f_35935_ || player.m_20159_()) {
            this.sneaking = mc.f_91066_.f_92090_.m_90857_();
            this.sneaking |= ButtonBindings.SNEAK.isButtonDown();
            if (ButtonBindings.SNEAK.isButtonDown()) {
                this.setControllerInUse();
            }
            this.isFlying = true;
        } else if (this.isFlying) {
            this.isFlying = false;
        }
        input.f_108573_ = this.sneaking;
        if (mc.f_91080_ == null) {
            if (!(RadialMenuHandler.instance().isVisible() && Config.CLIENT.client.options.radialThumbstick.get() == Thumbstick.LEFT || EventHelper.postMoveEvent())) {
                float threshold;
                float sneakBonus = player.m_108635_() ? Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)player)), (float)0.0f, (float)1.0f) : 1.0f;
                float inputX = controller.getLThumbStickXValue();
                float inputY = controller.getLThumbStickYValue();
                if (Math.abs(inputY) > 0.0f) {
                    input.f_108568_ = inputY < 0.0f;
                    input.f_108569_ = inputY > 0.0f;
                    input.f_108567_ = -inputY;
                    input.f_108567_ *= sneakBonus;
                    this.setControllerInUse();
                }
                float f = threshold = player.m_20202_() instanceof Boat ? 0.5f : 0.0f;
                if (Math.abs(inputX) > threshold) {
                    input.f_108571_ = inputX > 0.0f;
                    input.f_108570_ = inputX < 0.0f;
                    input.f_108566_ = -inputX;
                    input.f_108566_ *= sneakBonus;
                    this.setControllerInUse();
                }
            }
            if (this.ignoreInput && !ButtonBindings.JUMP.isButtonDown()) {
                this.ignoreInput = false;
            }
            if (ButtonBindings.JUMP.isButtonDown() && !this.ignoreInput) {
                input.f_108572_ = true;
            }
        }
        int rightClickDelay = ClientServices.CLIENT.getRightClickDelay(mc);
        if (ButtonBindings.USE_ITEM.isButtonDown() && rightClickDelay == 0 && !player.m_6117_()) {
            ClientServices.CLIENT.startUseItem(mc);
        }
    }

    public void handleButtonInput(Controller controller, int button, boolean state, boolean virtual) {
        if (controller == null) {
            return;
        }
        this.setControllerInUse();
        if (button != -1) {
            Value<Integer> newButton = new Value<Integer>(button);
            if (EventHelper.postInputEvent(controller, newButton, button, state)) {
                return;
            }
            button = newButton.get();
            ButtonBinding.setButtonState(button, state);
        }
        if (EventHelper.postButtonEvent(controller)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (state) {
            if (ButtonBindings.FULLSCREEN.isButtonPressed()) {
                mc.m_91268_().m_85438_();
                mc.f_91066_.m_231829_().m_231514_((Object)mc.m_91268_().m_85440_());
                mc.f_91066_.m_92169_();
            } else if (ButtonBindings.SCREENSHOT.isButtonPressed()) {
                if (mc.f_91073_ != null) {
                    Screenshot.m_92289_((File)mc.f_91069_, (RenderTarget)mc.m_91385_(), component -> mc.execute(() -> mc.f_91065_.m_93076_().m_93785_(component)));
                }
            } else if (mc.f_91080_ == null) {
                if (ButtonBindings.OPEN_INVENTORY.isButtonPressed() && mc.f_91072_ != null && mc.f_91074_ != null) {
                    if (mc.f_91072_.m_105292_()) {
                        mc.f_91074_.m_108628_();
                    } else {
                        mc.m_91301_().m_120564_();
                        mc.m_91152_((Screen)new InventoryScreen((Player)mc.f_91074_));
                    }
                } else if (ButtonBindings.SPRINT.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        boolean hasRequiredFood;
                        LocalPlayer player = mc.f_91074_;
                        boolean canSprint = !player.m_20142_() && !player.m_21023_(MobEffects.f_19610_);
                        boolean bl = hasRequiredFood = (float)player.m_36324_().m_38702_() > 6.0f || player.m_150110_().f_35936_;
                        boolean hasImpulse = player.m_5842_() ? player.f_108618_.m_108577_() : (double)player.f_108618_.f_108567_ >= 0.8;
                        boolean canSwimInFluid = ClientServices.CLIENT.canLocalPlayerSwimInFluid(player);
                        boolean usingItem = player.m_6117_();
                        if (canSprint && canSwimInFluid && hasImpulse && hasRequiredFood && !usingItem) {
                            player.m_6858_(true);
                        }
                    }
                } else if (ButtonBindings.SNEAK.isButtonPressed()) {
                    if (mc.f_91074_ != null && !mc.f_91074_.m_150110_().f_35935_ && !this.isFlying && !mc.f_91074_.m_20159_() && ((Boolean)mc.f_91066_.m_231831_().m_231551_()).booleanValue()) {
                        boolean bl = this.sneaking = !this.sneaking;
                        if (!this.sneaking && mc.f_91066_.f_92090_.m_90857_()) {
                            this.keyboardSneaking = false;
                            mc.f_91066_.f_92090_.m_7249_(true);
                        } else if (this.sneaking && !mc.f_91066_.f_92090_.m_90857_()) {
                            this.keyboardSneaking = true;
                            mc.f_91066_.f_92090_.m_7249_(true);
                        }
                    }
                } else if (ButtonBindings.SCROLL_RIGHT.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.f_91074_.m_150109_().m_35988_(-1.0);
                    }
                } else if (ButtonBindings.SCROLL_LEFT.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.f_91074_.m_150109_().m_35988_(1.0);
                    }
                } else if (ButtonBindings.SWAP_HANDS.isButtonPressed()) {
                    if (mc.f_91074_ != null && !mc.f_91074_.m_5833_() && mc.m_91403_() != null) {
                        mc.m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
                    }
                } else if (ButtonBindings.TOGGLE_PERSPECTIVE.isButtonPressed()) {
                    this.cycleThirdPersonView();
                } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.m_91358_(false);
                    }
                } else if (ButtonBindings.ADVANCEMENTS.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.m_91152_((Screen)new AdvancementsScreen(mc.f_91074_.f_108617_.m_105145_()));
                    }
                } else if (ButtonBindings.CINEMATIC_CAMERA.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.f_91066_.f_92067_ = !mc.f_91066_.f_92067_;
                    }
                } else if (ButtonBindings.DEBUG_INFO.isButtonPressed()) {
                    mc.f_91066_.f_92063_ = !mc.f_91066_.f_92063_;
                } else if (ButtonBindings.RADIAL_MENU.isButtonPressed() && !virtual) {
                    RadialMenuHandler.instance().interact();
                } else if (mc.f_91074_ != null) {
                    if (ButtonBindings.OPEN_CONTROLLABLE_SETTINGS.isButtonPressed()) {
                        mc.m_91152_((Screen)new SettingsScreen(null, 1));
                        return;
                    }
                    if (ButtonBindings.OPEN_CHAT.isButtonPressed()) {
                        ClientServices.CLIENT.openChatScreen("");
                        return;
                    }
                    for (int i = 0; i < 9; ++i) {
                        if (!ButtonBindings.HOTBAR_SLOTS[i].isButtonPressed()) continue;
                        mc.f_91074_.m_150109_().f_35977_ = i;
                        return;
                    }
                    if (!mc.f_91074_.m_6117_()) {
                        if (ButtonBindings.ATTACK.isButtonPressed()) {
                            ClientServices.CLIENT.startAttack(mc);
                        } else if (ButtonBindings.PICK_BLOCK.isButtonPressed()) {
                            ClientServices.CLIENT.pickBlock(mc);
                        }
                    }
                }
            } else if (ButtonBindings.CLOSE_INVENTORY.isButtonPressed()) {
                if (mc.f_91080_ != null) {
                    mc.f_91080_.m_7933_(256, GLFW.glfwGetKeyScancode((int)256), 0);
                }
            } else if (ButtonBindings.PREVIOUS_CREATIVE_TAB.isButtonPressed()) {
                if (mc.f_91080_.m_6702_().stream().anyMatch(listener -> listener instanceof TabNavigationBar)) {
                    this.navigateTabBar(mc.f_91080_, 1);
                } else if (mc.f_91080_ instanceof CreativeModeInventoryScreen) {
                    this.scrollCreativeTabs((CreativeModeInventoryScreen)mc.f_91080_, 1);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                } else {
                    Screen canSprint = mc.f_91080_;
                    if (canSprint instanceof RecipeUpdateListener) {
                        RecipeUpdateListener listener2 = (RecipeUpdateListener)canSprint;
                        this.scrollRecipePage(listener2.m_5564_(), 1);
                    }
                }
            } else if (ButtonBindings.NEXT_CREATIVE_TAB.isButtonPressed()) {
                if (mc.f_91080_.m_6702_().stream().anyMatch(listener -> listener instanceof TabNavigationBar)) {
                    this.navigateTabBar(mc.f_91080_, -1);
                } else if (mc.f_91080_ instanceof CreativeModeInventoryScreen) {
                    this.scrollCreativeTabs((CreativeModeInventoryScreen)mc.f_91080_, -1);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                } else {
                    Screen canSprint = mc.f_91080_;
                    if (canSprint instanceof RecipeUpdateListener) {
                        RecipeUpdateListener listener3 = (RecipeUpdateListener)canSprint;
                        this.scrollRecipePage(listener3.m_5564_(), -1);
                    }
                }
            } else if (ButtonBindings.NEXT_RECIPE_TAB.isButtonPressed()) {
                Screen canSprint = mc.f_91080_;
                if (canSprint instanceof RecipeUpdateListener) {
                    RecipeUpdateListener listener4 = (RecipeUpdateListener)canSprint;
                    this.scrollRecipeTab(listener4.m_5564_(), -1);
                }
            } else if (ButtonBindings.PREVIOUS_RECIPE_TAB.isButtonPressed()) {
                Screen canSprint = mc.f_91080_;
                if (canSprint instanceof RecipeUpdateListener) {
                    RecipeUpdateListener listener5 = (RecipeUpdateListener)canSprint;
                    this.scrollRecipeTab(listener5.m_5564_(), 1);
                }
            } else if (ButtonBindings.TOGGLE_CRAFT_BOOK.isButtonPressed()) {
                Screen canSprint = mc.f_91080_;
                if (canSprint instanceof RecipeUpdateListener) {
                    RecipeUpdateListener listener6 = (RecipeUpdateListener)canSprint;
                    ClientServices.CLIENT.getScreenRenderables(mc.f_91080_).stream().filter(widget -> {
                        ImageButton btn;
                        return widget instanceof ImageButton && RECIPE_BUTTON_LOCATION.equals((Object)ClientServices.CLIENT.getImageButtonResource(btn = (ImageButton)widget));
                    }).findFirst().ifPresent(btn -> ((Button)btn).m_5691_());
                    boolean visible = listener6.m_5564_().m_100385_();
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)(visible ? 1.0f : 0.95f)));
                }
            } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                if (mc.f_91080_ instanceof PauseScreen) {
                    mc.m_91152_(null);
                }
            } else if (ButtonBindings.NAVIGATE_UP.isButtonPressed()) {
                this.navigateCursor(mc.f_91080_, Navigate.UP);
            } else if (ButtonBindings.NAVIGATE_DOWN.isButtonPressed()) {
                this.navigateCursor(mc.f_91080_, Navigate.DOWN);
            } else if (ButtonBindings.NAVIGATE_LEFT.isButtonPressed()) {
                this.navigateCursor(mc.f_91080_, Navigate.LEFT);
            } else if (ButtonBindings.NAVIGATE_RIGHT.isButtonPressed()) {
                this.navigateCursor(mc.f_91080_, Navigate.RIGHT);
            } else if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseClick(mc.f_91080_, 0);
                if (mc.f_91080_ == null) {
                    this.ignoreInput = true;
                }
                if (((Boolean)Config.CLIENT.client.options.quickCraft.get()).booleanValue()) {
                    this.craftRecipeBookItem();
                }
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseClick(mc.f_91080_, 1);
            } else if (button == ButtonBindings.QUICK_MOVE.getButton() && mc.f_91074_ != null) {
                if (mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                    this.invokeMouseClick(mc.f_91080_, 0);
                } else {
                    this.invokeMouseReleased(mc.f_91080_, 1);
                }
            }
        } else if (mc.f_91080_ != null) {
            if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseReleased(mc.f_91080_, 0);
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseReleased(mc.f_91080_, 1);
            }
        }
    }

    private void cycleThirdPersonView() {
        Minecraft mc = Minecraft.m_91087_();
        CameraType cameraType = mc.f_91066_.m_92176_();
        mc.f_91066_.m_92157_(cameraType.m_90614_());
        if (cameraType.m_90612_() != mc.f_91066_.m_92176_().m_90612_()) {
            mc.f_91063_.m_109106_(mc.f_91066_.m_92176_().m_90612_() ? mc.m_91288_() : null);
        }
    }

    private void scrollCreativeTabs(CreativeModeInventoryScreen screen, int dir) {
        this.setControllerInUse();
        ClientServices.CLIENT.scrollCreativeTabs(screen, dir);
    }

    private void scrollRecipeTab(RecipeBookComponent recipeBook, int dir) {
        if (!recipeBook.m_100385_()) {
            return;
        }
        RecipeBookComponentAccessor recipeBookMixin = (RecipeBookComponentAccessor)recipeBook;
        RecipeBookTabButton currentTab = recipeBookMixin.controllableGetCurrentTab();
        List<RecipeBookTabButton> tabs = recipeBookMixin.controllableGetRecipeTabs();
        int currentTabIndex = tabs.indexOf(currentTab);
        RecipeBookTabButton newTab = null;
        if (dir > 0) {
            for (int i = currentTabIndex + 1; i < tabs.size(); ++i) {
                if (!tabs.get((int)i).f_93624_) continue;
                newTab = tabs.get(i);
                break;
            }
        } else {
            for (int i = currentTabIndex - 1; i >= 0; --i) {
                if (!tabs.get((int)i).f_93624_) continue;
                newTab = tabs.get(i);
                break;
            }
        }
        if (newTab != null) {
            currentTab.m_94635_(false);
            recipeBookMixin.controllableSetCurrentTab(newTab);
            newTab.m_94635_(true);
            recipeBookMixin.controllableUpdateCollections(true);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    private void scrollRecipePage(RecipeBookComponent recipeBook, int dir) {
        if (!recipeBook.m_100385_()) {
            return;
        }
        RecipeBookPageAccessor page = (RecipeBookPageAccessor)((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
        if (dir > 0 && page.controllableGetForwardButton().f_93624_ || dir < 0 && page.controllableGetBackButton().f_93624_) {
            int currentPage = page.controllableGetCurrentPage();
            page.controllableSetCurrentPage(currentPage + dir);
            page.controllableUpdateButtonsForPage();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    private void navigateTabBar(Screen screen, int dir) {
        TabNavigationBar bar = screen.m_6702_().stream().filter(listener -> listener instanceof TabNavigationBar).map(listener -> (TabNavigationBar)listener).findFirst().orElse(null);
        if (bar != null) {
            int newIndex;
            ArrayList buttons = new ArrayList();
            bar.m_6702_().forEach(listener -> {
                if (listener instanceof TabButton) {
                    TabButton button = (TabButton)listener;
                    buttons.add(button);
                }
            });
            int selectedIndex = buttons.stream().filter(TabButton::m_274319_).map(buttons::indexOf).findFirst().orElse(-1);
            if (selectedIndex != -1 && (newIndex = selectedIndex + dir) >= 0 && newIndex < buttons.size()) {
                bar.m_276089_(newIndex, true);
            }
        }
    }

    private void navigateCursor(Screen screen, Navigate navigate) {
        Minecraft mc = Minecraft.m_91087_();
        int cursorX = (int)((double)this.cursorX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_());
        int cursorY = (int)((double)this.cursorY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_());
        List<NavigationPoint> points = this.gatherNavigationPoints(screen, navigate, cursorX, cursorY);
        ((ControllerEvents.GatherNavigationPoints)ControllerEvents.GATHER_NAVIGATION_POINTS.post()).handle(points);
        points.removeIf(p -> !navigate.getPredicate().test((NavigationPoint)p, cursorX, cursorY));
        if (points.isEmpty()) {
            return;
        }
        Vector3d cursorVec = new Vector3d((double)cursorX, (double)cursorY, 0.0);
        Optional<NavigationPoint> minimumPointOptional = points.stream().min(navigate.getMinComparator(cursorX, cursorY));
        if (minimumPointOptional.isEmpty()) {
            return;
        }
        double maxOffset = 18.0;
        double minimumDelta = navigate.getKeyExtractor().apply(minimumPointOptional.get(), cursorVec) + maxOffset;
        Optional<NavigationPoint> targetPointOptional = points.stream().filter(point -> navigate.getKeyExtractor().apply((NavigationPoint)point, cursorVec) <= minimumDelta).min(Comparator.comparing(p -> p.distanceTo(cursorX, cursorY)));
        if (targetPointOptional.isPresent()) {
            NavigationPoint targetPoint = targetPointOptional.get();
            targetPoint.onNavigate();
            mc.m_6937_(() -> {
                this.performMouseDrag(this.cursorX, this.cursorY, 0.0, 0.0);
                double guiScale = mc.m_91268_().m_85449_();
                int screenX = (int)(targetPoint.getX() * guiScale);
                int screenY = (int)(targetPoint.getY() * guiScale);
                double lastTargetX = this.cursorX;
                double lastTargetY = this.cursorY;
                this.cursorX = this.prevCursorX = screenX;
                this.cursorY = this.prevCursorY = screenY;
                this.setCursorPosition(screenX, screenY);
                if (((Boolean)Config.CLIENT.client.options.uiSounds.get()).booleanValue()) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12019_, (float)2.0f));
                }
                this.performMouseDrag(this.cursorX, this.cursorY, (double)screenX - lastTargetX, (double)screenY - lastTargetY);
                this.hideVirtualCursor = targetPoint.shouldHide();
                this.moved = true;
            });
        }
    }

    private List<NavigationPoint> gatherNavigationPoints(Screen screen, Navigate navigate, int cursorX, int cursorY) {
        int buttonHeight;
        int startX;
        RecipeBookComponent recipeBook;
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        ArrayList<Object> widgets = new ArrayList<Object>();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            int n = ClientServices.CLIENT.getScreenLeft(containerScreen);
            int guiTop = ClientServices.CLIENT.getScreenTop(containerScreen);
            for (Slot slot : containerScreen.m_6262_().f_38839_) {
                if (ClientServices.CLIENT.getSlotUnderMouse(containerScreen) == slot) continue;
                int posX = n + slot.f_40220_ + 8;
                int posY = guiTop + slot.f_40221_ + 8;
                points.add(new SlotNavigationPoint((double)posX, (double)posY, slot));
            }
        }
        for (GuiEventListener guiEventListener : screen.m_6702_()) {
            this.gatherNavigationPointsFromListener(guiEventListener, navigate, cursorX, cursorY, points, null, null);
        }
        if (screen instanceof RecipeUpdateListener && (recipeBook = ((RecipeUpdateListener)screen).m_5564_()).m_100385_()) {
            widgets.add(((RecipeBookComponentAccessor)recipeBook).controllableGetFilterButton());
            widgets.addAll(((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeTabs());
            RecipeBookPage recipeBookPage = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
            OverlayRecipeComponent overlay = ((RecipeBookPageAccessor)recipeBookPage).controllableGetOverlay();
            if (overlay.m_100212_()) {
                widgets.addAll(((OverlayRecipeComponentAccessor)overlay).controllableGetRecipeButtons());
            } else {
                RecipeBookPage recipeBookPage2 = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
                widgets.addAll(((RecipeBookPageAccessor)recipeBookPage2).controllableGetButtons());
                widgets.add(((RecipeBookPageAccessor)recipeBookPage2).controllableGetForwardButton());
                widgets.add(((RecipeBookPageAccessor)recipeBookPage2).controllableGetBackButton());
            }
        }
        if (screen instanceof EnchantmentScreen) {
            EnchantmentScreen enchantmentScreen = (EnchantmentScreen)screen;
            int n = ClientServices.CLIENT.getScreenLeft((AbstractContainerScreen<?>)enchantmentScreen) + 60;
            int startY = ClientServices.CLIENT.getScreenTop((AbstractContainerScreen<?>)enchantmentScreen) + 14;
            int itemWidth = 108;
            int itemHeight = 19;
            for (int i = 0; i < 3; ++i) {
                double itemX = (double)n + (double)itemWidth / 2.0;
                double itemY = (double)(startY + itemHeight * i) + (double)itemHeight / 2.0;
                points.add(new BasicNavigationPoint(itemX, itemY));
            }
        }
        if (screen instanceof StonecutterScreen) {
            int offsetIndex;
            StonecutterScreen stonecutter = (StonecutterScreen)screen;
            StonecutterMenu stonecutterMenu = (StonecutterMenu)stonecutter.m_6262_();
            startX = ClientServices.CLIENT.getScreenLeft((AbstractContainerScreen<?>)stonecutter) + 52;
            int startY = ClientServices.CLIENT.getScreenTop((AbstractContainerScreen<?>)stonecutter) + 14;
            int buttonWidth = 16;
            buttonHeight = 18;
            for (int index = offsetIndex = ClientServices.CLIENT.getStonecutterStartIndex(stonecutter); index < offsetIndex + 12 && index < stonecutterMenu.m_40340_(); ++index) {
                int buttonIndex = index - offsetIndex;
                int buttonX = startX + buttonIndex % 4 * buttonWidth;
                int buttonY = startY + buttonIndex / 4 * buttonHeight + 2;
                points.add(new BasicNavigationPoint((double)buttonX + (double)buttonWidth / 2.0, (double)buttonY + (double)buttonHeight / 2.0));
            }
        }
        if (screen instanceof LoomScreen) {
            LoomScreen loom = (LoomScreen)screen;
            List list = ((LoomMenu)loom.m_6262_()).m_219995_();
            startX = ClientServices.CLIENT.getScreenLeft((AbstractContainerScreen<?>)loom) + 60;
            int startY = ClientServices.CLIENT.getScreenTop((AbstractContainerScreen<?>)loom) + 13;
            int buttonWidth = 14;
            buttonHeight = 14;
            int offsetRow = ClientServices.CLIENT.getLoomStartRow(loom);
            for (int i = 0; i < 4; ++i) {
                int buttonIndex;
                for (int j = 0; j < 4 && (buttonIndex = (i + offsetRow) * 4 + j) < list.size(); ++j) {
                    int buttonX = startX + j * buttonWidth;
                    int buttonY = startY + i * buttonHeight;
                    points.add(new BasicNavigationPoint((double)buttonX + (double)buttonWidth / 2.0, (double)buttonY + (double)buttonHeight / 2.0));
                }
            }
        }
        for (AbstractWidget abstractWidget : widgets) {
            if (abstractWidget == null || abstractWidget.m_274382_() || !abstractWidget.f_93624_ || !abstractWidget.f_93623_) continue;
            points.add(new WidgetNavigationPoint(abstractWidget));
        }
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            ClientServices.CLIENT.gatherCreativeTabNavigationPoints(creativeScreen, points);
        }
        if (Controllable.isJeiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(JeiSupport.getNavigationPoints());
        }
        if (Controllable.isEmiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(EmiSupport.getNavigationPoints(screen));
        }
        if (Controllable.isReiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(ReiSupport.getNavigationPoints(screen));
        }
        return points;
    }

    private void gatherNavigationPointsFromListener(GuiEventListener listener, Navigate navigate, int cursorX, int cursorY, List<NavigationPoint> points, @Nullable AbstractSelectionList<?> list, @Nullable GuiEventListener entry) {
        if (listener instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)listener;
            navigatable.elements().forEach(child -> this.gatherNavigationPointsFromListener((GuiEventListener)child, navigate, cursorX, cursorY, points, list, entry));
        } else if (listener instanceof AbstractSelectionList) {
            AbstractSelectionList selectionList = (AbstractSelectionList)listener;
            this.gatherNavigationPointsFromAbstractList(selectionList, navigate, cursorX, cursorY, points);
        } else if (listener instanceof TabNavigationBar) {
            TabNavigationBar navigationBar = (TabNavigationBar)listener;
            navigationBar.m_6702_().forEach(child -> {
                if (child instanceof TabButton) {
                    TabButton button = (TabButton)child;
                    this.createWidgetNavigationPoint((AbstractWidget)button, points, list, entry);
                }
            });
        } else if (listener instanceof ContainerEventHandler) {
            ContainerEventHandler handler = (ContainerEventHandler)listener;
            handler.m_6702_().forEach(child -> this.gatherNavigationPointsFromListener((GuiEventListener)child, navigate, cursorX, cursorY, points, list, entry));
        } else if (listener instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)listener;
            if (widget.f_93623_ && widget.f_93624_) {
                this.createWidgetNavigationPoint(widget, points, list, entry);
            }
        }
    }

    private void createWidgetNavigationPoint(AbstractWidget widget, List<NavigationPoint> points, @Nullable AbstractSelectionList<?> list, @Nullable GuiEventListener entry) {
        if (widget == null || widget.m_274382_() || !widget.f_93624_ || !widget.f_93623_) {
            return;
        }
        if (list != null && entry != null) {
            points.add(new ListWidgetNavigationPoint(widget, list, entry));
        } else {
            points.add(new WidgetNavigationPoint(widget));
        }
    }

    private void gatherNavigationPointsFromAbstractList(AbstractSelectionList<?> list, Navigate navigate, int cursorX, int cursorY, List<NavigationPoint> points) {
        List children = list.m_6702_();
        int dir = navigate == Navigate.UP ? -1 : 1;
        int itemHeight = ClientServices.CLIENT.getListItemHeight(list);
        for (int i = 0; i < children.size(); ++i) {
            GuiEventListener entry = (GuiEventListener)children.get(i);
            int rowTop = ClientServices.CLIENT.getAbstractListRowTop(list, i);
            int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(list, i);
            int listTop = ClientServices.CLIENT.getAbstractListTop(list);
            int listBottom = ClientServices.CLIENT.getAbstractListBottom(list);
            if (rowTop > listTop - itemHeight && rowBottom < listBottom + itemHeight) {
                if (!(navigate != Navigate.UP && navigate != Navigate.DOWN || entry instanceof SkipItem && (i == 0 || i == children.size() - 1))) {
                    points.add(new ListEntryNavigationPoint(list, entry, i, dir));
                }
                this.gatherNavigationPointsFromListener(entry, navigate, cursorX, cursorY, points, list, entry);
                continue;
            }
            if (!list.m_5953_((double)cursorX, (double)cursorY)) continue;
            points.add(new ListEntryNavigationPoint(list, entry, i, dir));
        }
    }

    private void craftRecipeBookItem() {
        AbstractContainerScreen screen;
        Screen screen2;
        block10: {
            block9: {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ == null) {
                    return;
                }
                screen2 = mc.f_91080_;
                if (!(screen2 instanceof AbstractContainerScreen)) break block9;
                screen = (AbstractContainerScreen)screen2;
                screen2 = mc.f_91080_;
                if (screen2 instanceof RecipeUpdateListener) break block10;
            }
            return;
        }
        RecipeUpdateListener listener = (RecipeUpdateListener)screen2;
        if (!listener.m_5564_().m_100385_()) {
            return;
        }
        if (!(screen.m_6262_() instanceof RecipeBookMenu)) {
            return;
        }
        RecipeBookPage recipeBookPage = ((RecipeBookComponentAccessor)listener.m_5564_()).controllableGetRecipeBookPage();
        RecipeButton recipeButton = ((RecipeBookPageAccessor)recipeBookPage).controllableGetButtons().stream().filter(AbstractWidget::m_198029_).findFirst().orElse(null);
        if (recipeButton != null) {
            RecipeBookMenu menu = (RecipeBookMenu)screen.m_6262_();
            Slot slot = menu.m_38853_(menu.m_6636_());
            int screenLeft = ClientServices.CLIENT.getScreenLeft(screen);
            int screenTop = ClientServices.CLIENT.getScreenTop(screen);
            if (menu.m_142621_().m_41619_()) {
                this.invokeMouseClick((Screen)screen, 0, screenLeft + slot.f_40220_ + 8, screenTop + slot.f_40221_ + 8);
            } else {
                this.invokeMouseReleased((Screen)screen, 0, screenLeft + slot.f_40220_ + 8, screenTop + slot.f_40221_ + 8);
            }
        }
    }

    private void setCursorPosition(double cursorX, double cursorY) {
        if (((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue()) {
            this.virtualCursorX = cursorX;
            this.virtualCursorY = cursorY;
        } else {
            Minecraft mc = Minecraft.m_91087_();
            GLFW.glfwSetCursorPos((long)mc.m_91268_().m_85439_(), (double)cursorX, (double)cursorY);
            this.preventReset = true;
        }
    }

    private void handleCreativeScrolling(CreativeModeInventoryScreen screen, Controller controller) {
        int i = (((CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_()).f_98639_.size() + 9 - 1) / 9 - 5;
        int dir = 0;
        if (controller.getRThumbStickYValue() <= -0.8f) {
            dir = 1;
        } else if (controller.getRThumbStickYValue() >= 0.8f) {
            dir = -1;
        }
        float currentScroll = ClientServices.CLIENT.getCreativeScrollOffset(screen);
        currentScroll = (float)((double)currentScroll - (double)dir / (double)i);
        currentScroll = Mth.m_14036_((float)currentScroll, (float)0.0f, (float)1.0f);
        ClientServices.CLIENT.setCreativeScrollOffset(screen, currentScroll);
        ((CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_()).m_98642_(currentScroll);
    }

    private void handleListScrolling(AbstractSelectionList<?> list, Controller controller) {
        float yValue;
        double dir = 0.0;
        float f = yValue = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(yValue) >= 0.2f) {
            this.setControllerInUse();
            dir = yValue;
        }
        list.m_93410_(list.m_93517_() + (dir *= (double)Minecraft.m_91087_().m_91297_()) * (Double)Config.CLIENT.client.options.listScrollSpeed.get());
    }

    private void handleMerchantScrolling(MerchantScreen screen, Controller controller) {
        float yValue;
        double dir = 0.0;
        float f = yValue = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(yValue) >= 0.5f) {
            this.setControllerInUse();
            dir = -yValue;
        } else {
            this.lastMerchantScroll = 0L;
        }
        long scrollTime = Util.m_137550_();
        if (dir != 0.0 && scrollTime - this.lastMerchantScroll >= 150L) {
            screen.m_6050_(this.getCursorX(), this.getCursorY(), Math.signum(dir));
            this.lastMerchantScroll = scrollTime;
        }
    }

    private double getCursorX() {
        Minecraft mc = Minecraft.m_91087_();
        double cursorX = mc.f_91067_.m_91589_();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue() && this.lastUse > 0) {
            cursorX = this.virtualCursorX;
        }
        return cursorX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
    }

    private double getCursorY() {
        Minecraft mc = Minecraft.m_91087_();
        double cursorY = mc.f_91067_.m_91594_();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue() && this.lastUse > 0) {
            cursorY = this.virtualCursorY;
        }
        return cursorY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
    }

    private void clampCursorToWindowBounds() {
        Minecraft mc = Minecraft.m_91087_();
        this.cursorX = Math.max(0, Math.min(this.cursorX, mc.m_91268_().m_85441_()));
        this.cursorY = Math.max(0, Math.min(this.cursorY, mc.m_91268_().m_85442_()));
    }

    private void snapToContainerSlot() {
        AbstractContainerScreen screen;
        Slot slot;
        Screen screen2;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (screen2 = mc.f_91080_) instanceof AbstractContainerScreen && (slot = ClientServices.CLIENT.getSlotUnderMouse(screen = (AbstractContainerScreen)screen2)) != null && slot.m_6659_() && (slot.m_6657_() || !screen.m_6262_().m_142621_().m_41619_())) {
            int slotX = ClientServices.CLIENT.getScreenLeft(screen) + slot.f_40220_ + 8;
            int slotY = ClientServices.CLIENT.getScreenTop(screen) + slot.f_40221_ + 8;
            this.cursorX = slotX *= (int)mc.m_91268_().m_85449_();
            this.cursorY = slotY *= (int)mc.m_91268_().m_85449_();
            this.clampCursorToWindowBounds();
            this.prevCursorX = slotX;
            this.prevCursorY = slotY;
            this.setCursorPosition(slotX, slotY);
        }
    }

    private void invokeMouseClick(Screen screen, int button) {
        if (screen != null) {
            double cursorX = this.getCursorX();
            double cursorY = this.getCursorY();
            if (screen instanceof AbstractContainerScreen && Controllable.isEmiLoaded() && EmiSupport.invokeMouseClick(button, cursorX, cursorY)) {
                return;
            }
            this.invokeMouseClick(screen, button, cursorX, cursorY);
        }
    }

    private void invokeMouseClick(Screen screen, int button, double cursorX, double cursorY) {
        if (screen != null) {
            ClientServices.CLIENT.setActiveMouseButton(button);
            ClientServices.CLIENT.setLastMouseEventTime(Blaze3D.m_83640_());
            ClientServices.CLIENT.sendScreenMouseClick(screen, cursorX, cursorY, button);
        }
    }

    private void invokeMouseReleased(Screen screen, int button) {
        if (screen != null) {
            double cursorX = this.getCursorX();
            double cursorY = this.getCursorY();
            if (screen instanceof AbstractContainerScreen && Controllable.isEmiLoaded() && EmiSupport.invokeMouseReleased(button, cursorX, cursorY)) {
                return;
            }
            this.invokeMouseReleased(screen, button, cursorX, cursorY);
        }
    }

    private void invokeMouseReleased(Screen screen, int button, double cursorX, double cursorY) {
        if (screen != null) {
            ClientServices.CLIENT.setActiveMouseButton(-1);
            ClientServices.CLIENT.sendScreenMouseReleased(screen, cursorX, cursorY, button);
        }
    }

    private static enum Navigate {
        UP((p, x, y) -> p.getY() < (double)y, (p, v) -> Math.abs(p.getX() - v.x)),
        DOWN((p, x, y) -> p.getY() > (double)(y + 1), (p, v) -> Math.abs(p.getX() - v.x)),
        LEFT((p, x, y) -> p.getX() < (double)x, (p, v) -> Math.abs(p.getY() - v.y)),
        RIGHT((p, x, y) -> p.getX() > (double)(x + 1), (p, v) -> Math.abs(p.getY() - v.y));

        private final NavigatePredicate predicate;
        private final BiFunction<? super NavigationPoint, Vector3d, Double> keyExtractor;

        private Navigate(NavigatePredicate predicate, BiFunction<? super NavigationPoint, Vector3d, Double> keyExtractor) {
            this.predicate = predicate;
            this.keyExtractor = keyExtractor;
        }

        public NavigatePredicate getPredicate() {
            return this.predicate;
        }

        public BiFunction<? super NavigationPoint, Vector3d, Double> getKeyExtractor() {
            return this.keyExtractor;
        }

        public Comparator<NavigationPoint> getMinComparator(int cursorX, int cursorY) {
            return Comparator.comparing(p -> this.keyExtractor.apply((NavigationPoint)p, new Vector3d((double)cursorX, (double)cursorY, 0.0)));
        }
    }

    private static interface NavigatePredicate {
        public boolean test(NavigationPoint var1, int var2, int var3);
    }
}

