/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.scarecrowsterritory;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.scarecrowsterritory.ScarecrowBlockEntity;
import com.supermartijn642.scarecrowsterritory.ScarecrowType;
import com.supermartijn642.scarecrowsterritory.ScarecrowsTerritoryConfig;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScarecrowBlock
extends BaseBlock
implements EntityHoldingBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final ScarecrowType type;

    public ScarecrowBlock(ScarecrowType type, DyeColor color) {
        super(false, type.getBlockProperties(color));
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof ScarecrowBlockEntity) {
            return ((ScarecrowBlockEntity)entity).rightClick(player, hand) ? BaseBlock.InteractionFeedback.SUCCESS : BaseBlock.InteractionFeedback.PASS;
        }
        return super.interact(state, level, pos, player, hand, hitSide, hitLocation);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.type.getBlockShape((Direction)state.m_61143_(FACING), (Boolean)state.m_61143_((Property)BOTTOM)).getUnderlying();
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (this.type.is2BlocksHigh() && !context.m_43725_().m_46859_(context.m_8083_().m_7494_()) && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60734_() != Blocks.f_49990_) {
            return null;
        }
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.type.is2BlocksHigh() && !level.m_46859_(pos) && level.m_8055_(pos).m_60734_() != Blocks.f_49990_) {
            FluidState fluidState = level.m_6425_(pos.m_7494_());
            level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_)));
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean bottom;
        BlockState state1;
        if (this.type.is2BlocksHigh() && state.m_60734_() != newState.m_60734_() && (state1 = level.m_8055_((bottom = ((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) ? pos.m_7494_() : pos.m_7495_())).m_60734_() == state.m_60734_() && (Boolean)state1.m_61143_((Property)BOTTOM) != bottom) {
            level.m_46597_(bottom ? pos.m_7494_() : pos.m_7495_(), (Boolean)state1.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BOTTOM, WATERLOGGED});
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.type.createBlockEntity(pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        boolean spawners = ScarecrowsTerritoryConfig.loadSpawners.get();
        boolean passive = ScarecrowsTerritoryConfig.passiveMobSpawning.get();
        if (spawners && passive) {
            MutableComponent spawnerRange = TextComponents.number((double)Math.round(ScarecrowsTerritoryConfig.loadSpawnerRange.get())).color(ChatFormatting.GOLD).get();
            MutableComponent passiveRange = TextComponents.number((double)Math.round(ScarecrowsTerritoryConfig.passiveMobRange.get())).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"scarecrowsterritory.primitive_scarecrow.info.both", (Object[])new Object[]{spawnerRange, passiveRange}).color(ChatFormatting.GRAY).get());
        } else if (spawners) {
            MutableComponent spawnerRange = TextComponents.number((double)Math.round(ScarecrowsTerritoryConfig.loadSpawnerRange.get())).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"scarecrowsterritory.primitive_scarecrow.info.spawners", (Object[])new Object[]{spawnerRange}).color(ChatFormatting.GRAY).get());
        } else if (passive) {
            MutableComponent passiveRange = TextComponents.number((double)Math.round(ScarecrowsTerritoryConfig.passiveMobRange.get())).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"scarecrowsterritory.primitive_scarecrow.info.passive", (Object[])new Object[]{passiveRange}).color(ChatFormatting.GRAY).get());
        }
    }
}

