/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import com.railwayteam.railways.content.buffer.TrackBuffer;
import com.railwayteam.railways.content.schedule.WaypointDestinationInstruction;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin.AccessorCarriageBogey;
import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.mixin_interfaces.IBufferBlockCheckableNavigation;
import com.railwayteam.railways.mixin_interfaces.IBufferBlockedTrain;
import com.railwayteam.railways.mixin_interfaces.IGenerallySearchableNavigation;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation;
import com.railwayteam.railways.mixin_interfaces.IWaypointableNavigation;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.MixinVariables;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Navigation.class}, remap=false)
public abstract class MixinNavigation
implements IWaypointableNavigation,
IGenerallySearchableNavigation,
IBufferBlockCheckableNavigation {
    @Shadow
    public Train train;
    @Shadow
    public int ticksWaitingForSignal;
    @Shadow
    public GlobalStation destination;
    @Shadow
    private TravellingPoint signalScout;
    @Unique
    private final ThreadLocal<Double> railways$bufferDistance = ThreadLocal.withInitial(() -> Double.MAX_VALUE);

    @Shadow
    public abstract TravellingPoint.ITrackSelector controlSignalScout();

    @Override
    public boolean railways$isWaypointMode() {
        try {
            return !this.train.manualTick && !this.train.runtime.paused && !this.train.runtime.completed && this.train.runtime.getSchedule() != null && this.train.runtime.currentEntry < this.train.runtime.getSchedule().entries.size() && ((ScheduleEntry)this.train.runtime.getSchedule().entries.get((int)this.train.runtime.currentEntry)).instruction instanceof WaypointDestinationInstruction;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/trains/entity/Navigation;distanceToDestination:D")})
    private double fixWaypointDistanceInTick(Navigation instance, Operation<Double> original) {
        if (((IWaypointableNavigation)instance).railways$isWaypointMode()) {
            return 1000.0;
        }
        return (Double)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"lambda$tick$0"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;canApproachFrom(Lcom/simibubi/create/content/trains/graph/TrackNode;)Z")})
    private boolean keepScoutingAtWaypoints(GlobalStation instance, TrackNode side, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{instance, side}) != false && !this.railways$isWaypointMode();
    }

    @WrapOperation(method={"tick"}, at={@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/trains/entity/Navigation;waitingForSignal:Lnet/createmod/catnip/data/Pair;")}, slice={@Slice(from=@At(value="CONSTANT", args={"doubleValue=0.25d"}), to=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;leaveStation()V"))})
    private Pair<UUID, Boolean> brakeProperlyAtWaypoints(Navigation instance, Operation<Pair<UUID, Boolean>> original) {
        return this.railways$isWaypointMode() ? null : (Pair)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"currentSignalResolved"}, at={@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/trains/entity/Navigation;distanceToDestination:D")}, slice={@Slice(to=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/graph/TrackGraph;getPoint(Lcom/simibubi/create/content/trains/graph/EdgePointType;Ljava/util/UUID;)Lcom/simibubi/create/content/trains/signal/TrackEdgePoint;"))})
    private double preventSignalClearWithWaypoint(Navigation instance, Operation<Double> original) {
        if (((IWaypointableNavigation)instance).railways$isWaypointMode()) {
            return 10.0;
        }
        return (Double)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/trains/entity/Train;")})
    private Train replacePresentTrain(GlobalStation instance, Operation<Train> original) {
        return ((ILimitedGlobalStation)instance).orDisablingTrain((Train)original.call(new Object[]{instance}), this.train);
    }

    @ModifyExpressionValue(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z")})
    private boolean isNavigationIncompatible(boolean original, @Local Map.Entry<TrackNode, TrackEdge> target) {
        if (target.getValue().getTrackMaterial().trackType == CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return true;
        }
        return original;
    }

    @Override
    public void railways$searchGeneral(double maxDistance, boolean forward, IGenerallySearchableNavigation.PointTest pointTest) {
        this.railways$searchGeneral(maxDistance, -1.0, forward, pointTest);
    }

    @Override
    public void railways$searchGeneral(double maxDistance, double maxCost, boolean forward, IGenerallySearchableNavigation.PointTest pointTest) {
        boolean costRelevant;
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return;
        }
        boolean skipValidCheck = false;
        HashSet validTypes = new HashSet();
        for (int i = 0; i < this.train.carriages.size(); ++i) {
            Carriage carriage = (Carriage)this.train.carriages.get(i);
            AbstractBogeyBlock<?> leadingType = ((AccessorCarriageBogey)carriage.leadingBogey()).getType();
            AbstractBogeyBlock<?> trailingType = ((AccessorCarriageBogey)carriage.trailingBogey()).getType();
            if (leadingType.getTrackType(carriage.leadingBogey().getStyle()) == CRTrackMaterials.CRTrackType.UNIVERSAL) {
                if (i == 0) {
                    skipValidCheck = true;
                }
            } else {
                if (i == 0 || skipValidCheck) {
                    validTypes.addAll(leadingType.getValidPathfindingTypes(carriage.leadingBogey().getStyle()));
                } else {
                    validTypes.retainAll(leadingType.getValidPathfindingTypes(carriage.leadingBogey().getStyle()));
                }
                skipValidCheck = false;
            }
            if (!carriage.isOnTwoBogeys() || trailingType.getTrackType(carriage.trailingBogey().getStyle()) == CRTrackMaterials.CRTrackType.UNIVERSAL) continue;
            if (skipValidCheck) {
                validTypes.addAll(trailingType.getValidPathfindingTypes(carriage.trailingBogey().getStyle()));
            } else {
                validTypes.retainAll(trailingType.getValidPathfindingTypes(carriage.trailingBogey().getStyle()));
            }
            skipValidCheck = false;
        }
        if (validTypes.isEmpty() && !skipValidCheck) {
            return;
        }
        IdentityHashMap penalties = new IdentityHashMap();
        boolean bl = costRelevant = maxCost >= 0.0;
        if (costRelevant) {
            for (Train otherTrain : Create.RAILWAYS.trains.values()) {
                if (otherTrain.graph != graph || otherTrain == this.train) continue;
                int navigationPenalty = otherTrain.getNavigationPenalty();
                otherTrain.getEndpointEdges().forEach(nodes -> {
                    if (nodes.either(Objects::isNull)) {
                        return;
                    }
                    for (boolean flip : Iterate.trueAndFalse) {
                        TrackEdge e = graph.getConnection(flip ? nodes.swap() : nodes);
                        if (e == null) continue;
                        int existing = penalties.getOrDefault(e, 0);
                        penalties.put(e, existing + navigationPenalty / 2);
                    }
                });
            }
        }
        TravellingPoint startingPoint = forward ? ((Carriage)this.train.carriages.get(0)).getLeadingPoint() : ((Carriage)this.train.carriages.get(this.train.carriages.size() - 1)).getTrailingPoint();
        HashSet<TrackEdge> visited = new HashSet<TrackEdge>();
        IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>> reachedVia = new IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>>();
        PriorityQueue<IGenerallySearchableNavigation.FrontierEntry> frontier = new PriorityQueue<IGenerallySearchableNavigation.FrontierEntry>();
        TrackNode initialNode1 = forward ? startingPoint.node1 : startingPoint.node2;
        TrackNode initialNode2 = forward ? startingPoint.node2 : startingPoint.node1;
        TrackEdge initialEdge = (TrackEdge)graph.getConnectionsFrom(initialNode1).get(initialNode2);
        if (initialEdge == null) {
            return;
        }
        double distanceToNode2 = forward ? initialEdge.getLength() - startingPoint.position : startingPoint.position;
        frontier.add(new IGenerallySearchableNavigation.FrontierEntry(distanceToNode2, 0, initialNode1, initialNode2, initialEdge));
        int signalWeight = Mth.m_14045_((int)(this.ticksWaitingForSignal * 2), (int)AccessorTrain.AccessorPenalties.railways$getRedSignal(), (int)200);
        block2: while (!frontier.isEmpty()) {
            TrackNode newNode;
            EdgeData signalData;
            IGenerallySearchableNavigation.FrontierEntry entry = (IGenerallySearchableNavigation.FrontierEntry)frontier.poll();
            if (!visited.add(entry.edge)) continue;
            double distance = entry.distance;
            int penalty = entry.penalty;
            if (distance > maxDistance) continue;
            TrackEdge edge = entry.edge;
            TrackNode node1 = entry.node1;
            TrackNode node2 = entry.node2;
            if (costRelevant) {
                penalty += penalties.getOrDefault(edge, 0).intValue();
            }
            if ((signalData = edge.getEdgeData()).hasPoints()) {
                for (TrackEdgePoint point : signalData.getPoints()) {
                    if (node1 == initialNode1 && point.getLocationOn(edge) < edge.getLength() - distanceToNode2) continue;
                    if (costRelevant && distance + (double)penalty > maxCost || !point.canNavigateVia(node2)) continue block2;
                    if (point instanceof SignalBoundary) {
                        SignalEdgeGroup signalEdgeGroup;
                        SignalBoundary signal = (SignalBoundary)point;
                        if (signal.isForcedRed(node2)) {
                            penalty += AccessorTrain.AccessorPenalties.railways$getRedstoneRedSignal();
                            continue;
                        }
                        UUID group = signal.getGroup(node2);
                        if (group == null || (signalEdgeGroup = (SignalEdgeGroup)Create.RAILWAYS.signalEdgeGroups.get(group)) == null) continue;
                        if (signalEdgeGroup.isOccupiedUnless(signal)) {
                            penalty += signalWeight;
                            signalWeight /= 2;
                        }
                    }
                    if (point instanceof GlobalStation) {
                        boolean isOwnStation;
                        GlobalStation station = (GlobalStation)point;
                        Train presentTrain = station.getPresentTrain();
                        boolean bl2 = isOwnStation = presentTrain == this.train;
                        if (presentTrain != null && !isOwnStation) {
                            penalty += AccessorTrain.AccessorPenalties.railways$getStationWithTrain();
                        }
                        if (station.canApproachFrom(node2) && pointTest.test(distance, distance + (double)penalty, reachedVia, (Pair<Couple<TrackNode>, TrackEdge>)Pair.of((Object)Couple.create((Object)node1, (Object)node2), (Object)edge), (TrackEdgePoint)station)) {
                            return;
                        }
                        if (!isOwnStation) {
                            penalty += AccessorTrain.AccessorPenalties.railways$getStation();
                        }
                    }
                    if (!pointTest.test(distance, distance + (double)penalty, reachedVia, (Pair<Couple<TrackNode>, TrackEdge>)Pair.of((Object)Couple.create((Object)node1, (Object)node2), (Object)edge), point)) continue;
                    return;
                }
            }
            if (costRelevant && distance + (double)penalty > maxCost) continue;
            ArrayList validTargets = new ArrayList();
            Map connectionsFrom = graph.getConnectionsFrom(node2);
            for (Map.Entry connection : connectionsFrom.entrySet()) {
                newNode = (TrackNode)connection.getKey();
                if (newNode == node1 || !edge.canTravelTo((TrackEdge)connection.getValue())) continue;
                validTargets.add(connection);
            }
            if (validTargets.isEmpty()) continue;
            for (Map.Entry target : validTargets) {
                if (!skipValidCheck && !validTypes.contains(((TrackEdge)target.getValue()).getTrackMaterial().trackType) && ((TrackEdge)target.getValue()).getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) continue;
                newNode = (TrackNode)target.getKey();
                TrackEdge newEdge = (TrackEdge)target.getValue();
                double newDistance = newEdge.getLength() + distance;
                int newPenalty = penalty;
                reachedVia.putIfAbsent(newEdge, (Pair<Boolean, Couple<TrackNode>>)Pair.of((Object)(validTargets.size() > 1 ? 1 : 0), (Object)Couple.create((Object)node1, (Object)node2)));
                frontier.add(new IGenerallySearchableNavigation.FrontierEntry(newDistance, newPenalty, node2, newNode, newEdge));
            }
        }
    }

    @Override
    public Pair<TrackSwitch, Pair<Boolean, Optional<TrackSwitchBlock.SwitchState>>> railways$findNearestApproachableSwitch(boolean forward) {
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return null;
        }
        MutableObject result = new MutableObject(null);
        MutableObject headOn = new MutableObject((Object)false);
        MutableObject targetState = new MutableObject(null);
        double acceleration = this.train.acceleration();
        double minDistance = 0.0;
        double maxDistance = Math.max(32.0, 1.5 * (this.train.speed * this.train.speed) / (2.0 * acceleration));
        this.railways$searchGeneral(maxDistance, forward, (distance, cost, reachedVia, currentEntry, trackPoint) -> {
            if (distance < minDistance) {
                return false;
            }
            TrackEdge edge = (TrackEdge)currentEntry.getSecond();
            double position = edge.getLength() - trackPoint.getLocationOn(edge);
            if (distance - position < minDistance) {
                return false;
            }
            if (trackPoint instanceof TrackSwitch) {
                TrackSwitch sw = (TrackSwitch)trackPoint;
                TrackNode node = (TrackNode)((Couple)currentEntry.getFirst()).getSecond();
                headOn.setValue((Object)sw.isPrimary(node));
                result.setValue((Object)sw);
                if (!((Boolean)headOn.getValue()).booleanValue()) {
                    for (TrackEdge reachedEdge : reachedVia.keySet()) {
                        TrackSwitchBlock.SwitchState state = sw.getTargetState(reachedEdge.node1.getLocation());
                        if (state == null) {
                            state = sw.getTargetState(reachedEdge.node2.getLocation());
                        }
                        targetState.setValue((Object)state);
                        if (state == null) continue;
                        break;
                    }
                }
                return true;
            }
            return false;
        });
        return Pair.of((Object)((Object)((TrackSwitch)((Object)result.getValue()))), (Object)Pair.of((Object)((Boolean)headOn.getValue()), Optional.ofNullable((TrackSwitchBlock.SwitchState)((Object)targetState.getValue()))));
    }

    @Inject(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at={@At(value="HEAD")})
    private void recordSearch(double maxDistance, double maxCost, boolean forward, ArrayList<GlobalStation> destinations, Navigation.StationTest stationTest, CallbackInfo ci) {
        ++MixinVariables.navigationCallDepth;
    }

    @Inject(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at={@At(value="RETURN")})
    private void recordSearchReturn(double maxDistance, double maxCost, boolean forward, ArrayList<GlobalStation> destinations, Navigation.StationTest stationTest, CallbackInfo ci) {
        if (MixinVariables.navigationCallDepth > 0) {
            --MixinVariables.navigationCallDepth;
        }
    }

    @Inject(method={"findNearestApproachable"}, at={@At(value="HEAD")}, cancellable=true)
    private void handcarsCannotApproachStations(boolean forward, CallbackInfoReturnable<GlobalStation> cir) {
        if (((IHandcarTrain)this.train).railways$isHandcar()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void resetBufferDistance(Level level, CallbackInfo ci) {
        this.railways$bufferDistance.set((Double)Double.MAX_VALUE);
    }

    @Inject(method={"lambda$tick$0"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/data/Pair;getFirst()Ljava/lang/Object;")})
    private void storeBufferSlowdown(MutableObject<Pair<UUID, Boolean>> trackingCrossSignal, double scanDistance, MutableDouble crossSignalDistanceTracker, double brakingDistanceNoFlicker, Double distance, Pair<TrackEdgePoint, Couple<TrackNode>> couple, CallbackInfoReturnable<Boolean> cir) {
        Object object = couple.getFirst();
        if (object instanceof TrackBuffer) {
            TrackBuffer trackBuffer = (TrackBuffer)((Object)object);
            double bufferedDistance = Math.max(0.0, distance - (double)TrackBuffer.getBufferRoom(this.train));
            this.railways$bufferDistance.set(Math.min(this.railways$bufferDistance.get(), bufferedDistance));
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;burnFuel()V")})
    private void applyBufferSlowdown(Level level, CallbackInfo ci, @Local(name={"targetDistance"}) LocalDoubleRef targetDistance) {
        if (this.railways$bufferDistance.get() < targetDistance.get()) {
            targetDistance.set(this.railways$bufferDistance.get().doubleValue());
        }
        this.railways$bufferDistance.set((Double)Double.MAX_VALUE);
    }

    @ModifyVariable(method={"tick"}, at=@At(value="NEW", target="(D)Lorg/apache/commons/lang3/mutable/MutableDouble;", ordinal=0), name={"brakingDistance"})
    private double ensureSufficientBufferDistance(double brakingDistance) {
        return brakingDistance + (double)TrackBuffer.getBufferRoom(this.train);
    }

    @ModifyVariable(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(DDD)D", remap=true), name={"brakingDistance"})
    private double resetSufficientBufferDistance(double brakingDistance) {
        return brakingDistance - (double)TrackBuffer.getBufferRoom(this.train);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void respectBuffersWithoutSchedule(Level level, CallbackInfo ci) {
        this.railways$updateControlsBlockInternal(false, false);
    }

    @Override
    @Unique
    public void railways$updateControlsBlock(boolean forceBackwards) {
        this.railways$updateControlsBlockInternal(true, forceBackwards);
    }

    @Unique
    private void railways$updateControlsBlockInternal(boolean simulate, boolean forceBackwards) {
        ((IBufferBlockedTrain)this.train).railways$setControlBlocked(false, forceBackwards);
        if (this.destination == null) {
            double target;
            double preDepartureLookAhead;
            double acceleration = this.train.acceleration();
            double brakingDistance = this.train.speed * this.train.speed / (2.0 * acceleration);
            boolean currentlyBackwards = this.train.speed < 0.0 || forceBackwards;
            double speedMod = currentlyBackwards ? -1.0 : 1.0;
            double d = preDepartureLookAhead = this.train.getCurrentStation() != null ? 4.5 : 0.0;
            if (this.train.graph == null) {
                return;
            }
            TravellingPoint leadingPoint = !currentlyBackwards ? ((Carriage)this.train.carriages.get(0)).getLeadingPoint() : ((Carriage)this.train.carriages.get(this.train.carriages.size() - 1)).getTrailingPoint();
            this.signalScout.node1 = leadingPoint.node1;
            this.signalScout.node2 = leadingPoint.node2;
            this.signalScout.edge = leadingPoint.edge;
            this.signalScout.position = leadingPoint.position;
            double brakingDistance2 = brakingDistance + (double)TrackBuffer.getBufferRoom(this.train);
            double brakingDistanceNoFlicker = brakingDistance2 + 3.0 - brakingDistance2 % 3.0;
            double scanDistance = Mth.m_14008_((double)brakingDistanceNoFlicker, (double)preDepartureLookAhead, (double)500.0);
            MutableDouble bufferDistance = new MutableDouble(Double.MAX_VALUE);
            this.signalScout.travel(this.train.graph, (scanDistance + 50.0) * speedMod, this.controlSignalScout(), (distance, couple) -> {
                if (distance > scanDistance) {
                    return true;
                }
                Object patt24237$temp = couple.getFirst();
                if (patt24237$temp instanceof TrackBuffer) {
                    TrackBuffer trackBuffer = (TrackBuffer)((Object)((Object)patt24237$temp));
                    double bufferedDistance = Math.max(0.0, distance - (double)TrackBuffer.getBufferRoom(this.train, currentlyBackwards));
                    bufferDistance.setValue(Math.min(bufferDistance.getValue(), bufferedDistance));
                    return true;
                }
                return false;
            }, (distance, edge) -> {});
            if (bufferDistance.getValue() >= Double.MAX_VALUE) {
                return;
            }
            double targetDistance = bufferDistance.getValue();
            if ((targetDistance += 0.25) < 3.0) {
                ((IBufferBlockedTrain)this.train).railways$setControlBlocked(true, forceBackwards);
            }
            if (simulate) {
                return;
            }
            if (targetDistance < 10.0 && (target = (double)this.train.maxSpeed() * (targetDistance / 10.0)) < Math.abs(this.train.speed)) {
                this.train.speed += (target - Math.abs(this.train.speed)) * 0.5 * Math.signum(this.train.speed);
                return;
            }
            if (targetDistance <= brakingDistance) {
                this.train.targetSpeed = 0.0;
                this.train.approachTargetSpeed(1.0f);
            }
        }
    }
}

