/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.entity.ArmoredSlimeEntity;

public class TerracubeEntity
extends ArmoredSlimeEntity {
    public TerracubeEntity(EntityType<? extends TerracubeEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean canSpawnHere(EntityType<? extends Slime> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        BlockPos down = pos.m_7495_();
        if (world.m_6425_(pos).m_205070_(FluidTags.f_13131_) && world.m_6425_(down).m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        return world.m_8055_(down).m_60643_((BlockGetter)world, down, entityType) && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
    }

    protected float m_6118_() {
        return 0.5f * this.m_20098_();
    }

    protected float m_7566_() {
        return (float)this.m_21133_(Attributes.f_22281_) + 2.0f;
    }

    protected ParticleOptions m_6300_() {
        return (ParticleOptions)TinkerWorld.terracubeParticle.get();
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    @Override
    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        float multiplier = difficulty.m_19057_();
        if (this.f_19796_.m_188501_() < 0.15f * multiplier) {
            ItemStack current;
            int armorQuality = this.f_19796_.m_188503_(3);
            if (this.f_19796_.m_188501_() < 0.25f) {
                ++armorQuality;
            }
            if (this.f_19796_.m_188501_() < 0.25f) {
                ++armorQuality;
            }
            if (this.f_19796_.m_188501_() < 0.25f) {
                ++armorQuality;
            }
            if ((current = this.m_6844_(EquipmentSlot.HEAD)).m_41619_()) {
                Item item;
                Item item2 = item = armorQuality == 5 ? Items.f_42354_ : TerracubeEntity.m_21412_((EquipmentSlot)EquipmentSlot.HEAD, (int)armorQuality);
                if (item != null) {
                    this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)item));
                    this.m_217051_(random, multiplier, EquipmentSlot.HEAD);
                }
            }
        }
    }
}

