/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.ArmorLootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ShowOffhandModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.LootingContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.interaction.DualOptionInteraction;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ShearsAbilityModifier
extends NoLevelsModifier
implements EntityInteractionModifierHook,
ToolActionModifierHook {
    private final int range;
    private final int priority;

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(ShowOffhandModule.DISALLOW_BROKEN);
        hookBuilder.addHook(this, ModifierHooks.ENTITY_INTERACT, ModifierHooks.TOOL_ACTION);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return DualOptionInteraction.formatModifierName(tool, this, super.getDisplayName(tool, entry, access));
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    protected void swingTool(Player player, InteractionHand hand) {
        player.m_6674_(hand);
        player.m_36346_();
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        if (this.isShears(tool)) {
            return toolAction == ToolActions.SHEARS_DIG || toolAction == ToolActions.SHEARS_HARVEST || toolAction == ToolActions.SHEARS_CARVE || toolAction == ToolActions.SHEARS_DISARM;
        }
        return false;
    }

    protected boolean isShears(IToolStackView tool) {
        return true;
    }

    @Override
    public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
        if (tool.isBroken() || !tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        EquipmentSlot slotType = source.getSlot(hand);
        ItemStack stack = player.m_6844_(slotType);
        LootingContext context = new LootingContext((LivingEntity)player, target, null, Util.getSlotType(hand));
        int looting = LootingModifierHook.getLooting(tool, context, player.m_21120_(hand).getEnchantmentLevel(Enchantments.f_44982_));
        looting = ArmorLootingModifierHook.getLooting(tool, context, looting);
        Level world = player.m_20193_();
        if (this.isShears(tool) && ShearsAbilityModifier.shearEntity(stack, tool, world, player, target, looting)) {
            int expanded;
            boolean broken = ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType);
            this.swingTool(player, hand);
            ShearsAbilityModifier.runShearHook(tool, player, target, true);
            if (!broken && (expanded = this.range + tool.getModifierLevel(TinkerModifiers.expanded.getId())) > 0) {
                for (LivingEntity aoeTarget : player.m_20193_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_((double)expanded, 0.25, (double)expanded))) {
                    if (aoeTarget == player || aoeTarget == target || aoeTarget instanceof ArmorStand && ((ArmorStand)aoeTarget).m_31677_() || !ShearsAbilityModifier.shearEntity(stack, tool, world, player, (Entity)aoeTarget, looting)) continue;
                    broken = ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType);
                    ShearsAbilityModifier.runShearHook(tool, player, (Entity)aoeTarget, false);
                    if (!broken) continue;
                    break;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void runShearHook(IToolStackView tool, Player player, Entity entity, boolean isTarget) {
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(ModifierHooks.SHEAR_ENTITY).afterShearEntity(tool, entry, player, entity, isTarget);
        }
    }

    private static boolean shearEntity(ItemStack itemStack, IToolStackView tool, Level world, Player player, Entity entity, int fortune) {
        IForgeShearable target;
        Event.Result result = new TinkerToolEvent.ToolShearEvent(itemStack, tool, world, player, entity, fortune).fire();
        if (result != Event.Result.DEFAULT) {
            return result == Event.Result.ALLOW;
        }
        if (entity instanceof IForgeShearable && (target = (IForgeShearable)entity).isShearable(itemStack, world, entity.m_20183_())) {
            if (!world.f_46443_) {
                target.onSheared(player, itemStack, world, entity.m_20183_(), fortune).forEach(stack -> ModifierUtil.dropItem(entity, stack));
            }
            return true;
        }
        return false;
    }

    public ShearsAbilityModifier(int range, int priority) {
        this.range = range;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

