/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;
import slimeknights.tconstruct.tables.client.inventory.ToolTableScreen;
import slimeknights.tconstruct.tables.client.inventory.widget.SlotButtonItem;
import slimeknights.tconstruct.tables.client.inventory.widget.TinkerStationButtonsWidget;
import slimeknights.tconstruct.tables.menu.TinkerStationContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.TinkerStationSlot;
import slimeknights.tconstruct.tables.network.TinkerStationRenamePacket;
import slimeknights.tconstruct.tables.network.TinkerStationSelectionPacket;

public class TinkerStationScreen
extends ToolTableScreen<TinkerStationBlockEntity, TinkerStationContainerMenu> {
    private static final Component COMPONENTS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.components");
    private static final Component ASCII_ANVIL = Component.m_237113_((String)"\n\n").m_130946_("       .\n").m_130946_("     /( _________\n").m_130946_("     |  >:=========`\n").m_130946_("     )(  \n").m_130946_("     \"\"").m_130940_(ChatFormatting.DARK_GRAY);
    private static final int STILL_FILLED_X = 112;
    private static final int STILL_FILLED_Y = 62;
    private static final int STILL_FILLED_SPACING = 18;
    private static final ResourceLocation TINKER_STATION_TEXTURE = TConstruct.getResource("textures/gui/tinker_station.png");
    private static final ElementScreen ACTIVE_TEXT_FIELD = new ElementScreen(TINKER_STATION_TEXTURE, 0, 210, 91, 12, 256, 256);
    private static final ElementScreen ITEM_COVER = ACTIVE_TEXT_FIELD.move(176, 18, 70, 64);
    private static final ElementScreen SLOT_BACKGROUND = ACTIVE_TEXT_FIELD.move(176, 0, 18, 18);
    private static final ElementScreen SLOT_BORDER = ACTIVE_TEXT_FIELD.move(194, 0, 18, 18);
    private static final ElementScreen SLOT_SPACE_TOP = ACTIVE_TEXT_FIELD.move(0, 176, 18, 2);
    private static final ElementScreen SLOT_SPACE_BOTTOM = ACTIVE_TEXT_FIELD.move(0, 174, 18, 2);
    private static final ElementScreen PANEL_SPACE_LEFT = ACTIVE_TEXT_FIELD.move(0, 174, 5, 4);
    private static final ElementScreen PANEL_SPACE_RIGHT = ACTIVE_TEXT_FIELD.move(9, 174, 9, 4);
    private static final ElementScreen LEFT_BEAM = ACTIVE_TEXT_FIELD.move(0, 180, 2, 7);
    private static final ElementScreen RIGHT_BEAM = ACTIVE_TEXT_FIELD.move(131, 180, 2, 7);
    private static final ScalableElementScreen CENTER_BEAM = new ScalableElementScreen(TINKER_STATION_TEXTURE, 2, 180, 129, 7, 256, 256);
    private static final ElementScreen TEXT_BOX = ACTIVE_TEXT_FIELD.move(0, 222, 90, 12);
    public static final int COLUMN_COUNT = 5;
    protected ElementScreen buttonDecorationTop = SLOT_SPACE_TOP;
    protected ElementScreen buttonDecorationBot = SLOT_SPACE_BOTTOM;
    protected ElementScreen panelDecorationL = PANEL_SPACE_LEFT;
    protected ElementScreen panelDecorationR = PANEL_SPACE_RIGHT;
    protected ElementScreen leftBeam = ACTIVE_TEXT_FIELD.move(0, 0, 0, 0);
    protected ElementScreen rightBeam = ACTIVE_TEXT_FIELD.move(0, 0, 0, 0);
    protected ScalableElementScreen centerBeam = CENTER_BEAM.move(0, 0, 0, 0);
    @Nonnull
    private final StationSlotLayout defaultLayout;
    @Nonnull
    private StationSlotLayout currentLayout;
    protected EditBox textField;
    protected TinkerStationButtonsWidget buttonsScreen;
    private final int maxInputs;
    protected int activeInputs;

    public TinkerStationScreen(TinkerStationContainerMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tinkerInfo.yOffset = 5;
        this.modifierInfo.yOffset = this.tinkerInfo.f_97727_ + 9;
        this.f_97727_ = 174;
        int max = 5;
        TinkerStationBlockEntity te = (TinkerStationBlockEntity)container.getTile();
        if (te != null) {
            max = te.getInputCount();
        }
        this.maxInputs = max;
        if (max > 3) {
            this.metal();
        } else {
            this.wood();
        }
        this.defaultLayout = te == null ? StationSlotLayout.EMPTY : StationSlotLayoutLoader.getInstance().get(BuiltInRegistries.f_256975_.m_7981_((Object)te.m_58900_().m_60734_()));
        this.currentLayout = this.defaultLayout;
        this.activeInputs = Math.min(this.defaultLayout.getInputCount(), max);
    }

    @Override
    public void m_7856_() {
        assert (this.f_96541_ != null);
        this.f_97736_ += 4;
        this.cornerY += 4;
        this.tinkerInfo.xOffset = 2;
        this.tinkerInfo.yOffset = this.centerBeam.h + this.panelDecorationL.h;
        this.modifierInfo.xOffset = this.tinkerInfo.xOffset;
        this.modifierInfo.yOffset = this.tinkerInfo.yOffset + this.tinkerInfo.f_97727_ + 4;
        for (ModuleScreen module : this.modules) {
            module.f_97736_ += 4;
        }
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.textField = new EditBox(this.f_96547_, x + 80, y + 5, 82, 9, (Component)Component.m_237119_());
        this.textField.m_94190_(true);
        this.textField.m_94202_(-1);
        this.textField.m_94205_(-1);
        this.textField.m_94182_(false);
        this.textField.m_94199_(50);
        this.textField.m_94151_(this::onNameChanged);
        this.textField.m_94144_("");
        this.m_7787_((GuiEventListener)this.textField);
        this.textField.f_93624_ = false;
        this.textField.m_94186_(false);
        super.m_7856_();
        int buttonsStyle = this.maxInputs > 3 ? 1 : 2;
        ArrayList layouts = Lists.newArrayList();
        layouts.add(this.defaultLayout);
        layouts.addAll(StationSlotLayoutLoader.getInstance().getSortedSlots().stream().filter(layout -> layout.getInputSlots().size() <= this.maxInputs).toList());
        this.buttonsScreen = new TinkerStationButtonsWidget(this, this.cornerX - TinkerStationButtonsWidget.width(5) - 2, this.cornerY + this.centerBeam.h + this.buttonDecorationTop.h, layouts, buttonsStyle);
        this.setupArmorStandPreview(-55, 190, 35);
        this.updateLayout();
    }

    public void updateLayout() {
        int stillFilled = 0;
        for (int i = 0; i <= this.maxInputs; ++i) {
            TinkerStationSlot tinkerSlot;
            Slot slot = ((TinkerStationContainerMenu)this.getMenu()).m_38853_(i);
            LayoutSlot layoutSlot = this.currentLayout.getSlot(i);
            if (layoutSlot.isHidden()) {
                slot.f_40220_ = 112 - 18 * stillFilled;
                slot.f_40221_ = 62;
                ++stillFilled;
                if (!(slot instanceof TinkerStationSlot)) continue;
                tinkerSlot = (TinkerStationSlot)slot;
                tinkerSlot.deactivate();
                continue;
            }
            slot.f_40220_ = layoutSlot.getX();
            slot.f_40221_ = layoutSlot.getY();
            if (!(slot instanceof TinkerStationSlot)) continue;
            tinkerSlot = (TinkerStationSlot)slot;
            tinkerSlot.activate(layoutSlot);
        }
        this.updateDisplay();
    }

    @Override
    public void updateDisplay() {
        if (this.tile == null) {
            return;
        }
        LazyToolStack lazyResult = ((TinkerStationBlockEntity)this.tile).getResult();
        Component currentError = ((TinkerStationBlockEntity)this.tile).getCurrentError();
        if (currentError != null) {
            this.error(currentError);
            return;
        }
        if (lazyResult == null || ((TinkerStationBlockEntity)this.tile).getInputCount() <= 4 && ((TinkerStationContainerMenu)this.getMenu()).m_38853_(0).m_6657_()) {
            this.textField.m_94186_(false);
            this.textField.m_94144_("");
            this.textField.f_93624_ = false;
        } else if (!this.textField.m_94222_()) {
            this.textField.m_94186_(true);
            this.textField.m_94144_("");
            this.textField.f_93624_ = true;
        } else {
            this.textField.m_94144_(((TinkerStationBlockEntity)this.tile).getItemName());
        }
        if (lazyResult == null) {
            lazyResult = ((TinkerStationBlockEntity)this.tile).getTool();
        }
        this.updateArmorStandPreview(lazyResult.getStack());
        if (lazyResult.hasTag(TinkerTags.Items.MODIFIABLE)) {
            ToolStack tool = lazyResult.getTool();
            this.updateToolPanel(lazyResult);
            this.updateModifierPanel(tool);
        } else {
            this.tinkerInfo.setCaption(this.currentLayout.getDisplayName());
            this.tinkerInfo.setText(this.currentLayout.getDescription());
            MutableComponent fullText = Component.m_237113_((String)"");
            boolean hasComponents = false;
            for (int i = 0; i <= this.activeInputs; ++i) {
                LayoutSlot layout = this.currentLayout.getSlot(i);
                String key = layout.getTranslationKey();
                if (layout.isHidden() || key.isEmpty()) continue;
                hasComponents = true;
                MutableComponent textComponent = Component.m_237113_((String)" * ");
                ItemStack slotStack = ((TinkerStationContainerMenu)this.getMenu()).m_38853_(i).m_7993_();
                if (!layout.isValid(slotStack)) {
                    textComponent.m_130940_(ChatFormatting.RED);
                }
                textComponent.m_7220_((Component)Component.m_237115_((String)key)).m_130946_("\n");
                fullText.m_7220_((Component)textComponent);
            }
            if (hasComponents) {
                this.modifierInfo.setCaption(COMPONENTS_TEXT);
                this.modifierInfo.setText(new Component[]{fullText});
            } else {
                this.modifierInfo.setCaption((Component)Component.m_237119_());
                this.modifierInfo.setText(ASCII_ANVIL);
            }
        }
    }

    protected void drawContainerName(GuiGraphics graphics) {
        graphics.m_280614_(this.f_96547_, this.m_96636_(), 8, 8, 0x404040, false);
    }

    public static void renderIcon(GuiGraphics graphics, LayoutIcon icon, int x, int y) {
        Pattern pattern = icon.getValue(Pattern.class);
        if (pattern != null) {
            GuiUtil.renderPattern(graphics, pattern, x, y);
            return;
        }
        ItemStack stack = icon.getValue(ItemStack.class);
        if (stack != null) {
            graphics.m_280480_(stack, x, y);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        Slot slot;
        int i;
        this.drawBackground(graphics, TINKER_STATION_TEXTURE);
        int x = 0;
        int y = 0;
        float scale = 3.7f;
        float xOff = 12.5f;
        float yOff = 22.0f;
        PoseStack renderPose = graphics.m_280168_();
        renderPose.m_85836_();
        renderPose.m_252880_(12.5f, 22.0f, 0.0f);
        renderPose.m_85841_(3.7f, 3.7f, 1.0f);
        TinkerStationScreen.renderIcon(graphics, this.currentLayout.getIcon(), (int)((float)this.cornerX / 3.7f), (int)((float)this.cornerY / 3.7f));
        renderPose.m_85849_();
        RenderUtils.setup(TINKER_STATION_TEXTURE, 1.0f, 1.0f, 1.0f, 0.82f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        ITEM_COVER.draw(graphics, this.cornerX + 7, this.cornerY + 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.28f);
        if (!this.currentLayout.getToolSlot().isHidden()) {
            Slot slot2 = ((TinkerStationContainerMenu)this.getMenu()).m_38853_(0);
            SLOT_BACKGROUND.draw(graphics, x + this.cornerX + slot2.f_40220_ - 1, y + this.cornerY + slot2.f_40221_ - 1);
        }
        for (i = 0; i < this.activeInputs; ++i) {
            slot = ((TinkerStationContainerMenu)this.getMenu()).m_38853_(i + 1);
            SLOT_BACKGROUND.draw(graphics, x + this.cornerX + slot.f_40220_ - 1, y + this.cornerY + slot.f_40221_ - 1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i <= this.maxInputs; ++i) {
            slot = ((TinkerStationContainerMenu)this.getMenu()).m_38853_(i);
            if (!(slot instanceof TinkerStationSlot) || ((TinkerStationSlot)slot).isDormant() && !slot.m_6657_()) continue;
            SLOT_BORDER.draw(graphics, x + this.cornerX + slot.f_40220_ - 1, y + this.cornerY + slot.f_40221_ - 1);
        }
        x = this.buttonsScreen.getLeftPos() - this.leftBeam.w;
        y = this.cornerY;
        this.leftBeam.draw(graphics, x, y);
        x += this.leftBeam.w;
        x += this.centerBeam.drawScaledX(graphics, x, y, this.buttonsScreen.getImageWidth());
        this.rightBeam.draw(graphics, x, y);
        x = this.tinkerInfo.f_97735_ - this.leftBeam.w;
        this.leftBeam.draw(graphics, x, y);
        x += this.leftBeam.w;
        x += this.centerBeam.drawScaledX(graphics, x, y, this.tinkerInfo.f_97726_);
        this.rightBeam.draw(graphics, x, y);
        for (SlotButtonItem button : this.buttonsScreen.getButtons()) {
            this.buttonDecorationTop.draw(graphics, button.m_252754_(), button.m_252907_() - this.buttonDecorationTop.h);
            if (button.buttonId >= this.buttonsScreen.getButtons().size() - 5) continue;
            this.buttonDecorationBot.draw(graphics, button.m_252754_(), button.m_252907_() + button.m_93694_());
        }
        this.panelDecorationL.draw(graphics, this.tinkerInfo.f_97735_ + 5, this.tinkerInfo.f_97736_ - this.panelDecorationL.h);
        this.panelDecorationR.draw(graphics, this.tinkerInfo.guiRight() - 5 - this.panelDecorationR.w, this.tinkerInfo.f_97736_ - this.panelDecorationR.h);
        this.panelDecorationL.draw(graphics, this.modifierInfo.f_97735_ + 5, this.modifierInfo.f_97736_ - this.panelDecorationL.h);
        this.panelDecorationR.draw(graphics, this.modifierInfo.guiRight() - 5 - this.panelDecorationR.w, this.modifierInfo.f_97736_ - this.panelDecorationR.h);
        for (int i2 = 0; i2 <= this.maxInputs; ++i2) {
            Pattern icon;
            slot = ((TinkerStationContainerMenu)this.getMenu()).m_38853_(i2);
            if (slot.m_6657_() || (icon = this.currentLayout.getSlot(i2).getIcon()) == null) continue;
            GuiUtil.renderPattern(graphics, icon, this.cornerX + slot.f_40220_, this.cornerY + slot.f_40221_);
        }
        RenderSystem.enableDepthTest();
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        this.buttonsScreen.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.textField != null && this.textField.f_93624_) {
            RenderUtils.setup(TINKER_STATION_TEXTURE, 1.0f, 1.0f, 1.0f, 1.0f);
            TEXT_BOX.draw(graphics, this.cornerX + 79, this.cornerY + 3);
            this.textField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderArmorStand(graphics);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.tinkerInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        if (this.tinkerInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.tinkerInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        if (this.modifierInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int state) {
        if (this.tinkerInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.modifierInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    static boolean needsDisplayUpdate(int keyCode) {
        if (keyCode == 340 || keyCode == 344) {
            return true;
        }
        if (Minecraft.f_91002_) {
            return keyCode == 343 || keyCode == 347;
        }
        return keyCode == 341 || keyCode == 345;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        if (this.textField.m_94204_()) {
            this.textField.m_7933_(keyCode, scanCode, modifiers);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void m_280092_(GuiGraphics graphics, Slot slotIn) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.m_6657_()) {
            return;
        }
        super.m_280092_(graphics, slotIn);
    }

    public boolean m_97774_(Slot slotIn, double mouseX, double mouseY) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.m_6657_()) {
            return false;
        }
        return super.m_97774_(slotIn, mouseX, mouseY);
    }

    protected void wood() {
        this.tinkerInfo.wood();
        this.modifierInfo.wood();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(18, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(18, 0);
        this.leftBeam = LEFT_BEAM;
        this.rightBeam = RIGHT_BEAM;
        this.centerBeam = CENTER_BEAM;
    }

    protected void metal() {
        this.tinkerInfo.metal();
        this.modifierInfo.metal();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w * 2, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w * 2, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(36, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(36, 0);
        this.leftBeam = LEFT_BEAM.shift(0, TinkerStationScreen.LEFT_BEAM.h);
        this.rightBeam = RIGHT_BEAM.shift(0, TinkerStationScreen.RIGHT_BEAM.h);
        this.centerBeam = CENTER_BEAM.shift(0, TinkerStationScreen.CENTER_BEAM.h);
    }

    @Override
    public void error(Component message) {
        this.tinkerInfo.setCaption(COMPONENT_ERROR);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((Component)Component.m_237119_());
        this.modifierInfo.setText(new Component[]{Component.m_237119_()});
    }

    @Override
    public void warning(Component message) {
        this.tinkerInfo.setCaption(COMPONENT_WARNING);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((Component)Component.m_237119_());
        this.modifierInfo.setText(new Component[]{Component.m_237119_()});
    }

    public void onToolSelection(StationSlotLayout layout) {
        this.activeInputs = Math.min(layout.getInputCount(), this.maxInputs);
        this.currentLayout = layout;
        this.updateLayout();
        TinkerNetwork.getInstance().sendToServer(new TinkerStationSelectionPacket(layout.getName()));
    }

    @Override
    public List<Rect2i> getModuleAreas() {
        List<Rect2i> list = super.getModuleAreas();
        list.add(this.buttonsScreen.getArea());
        return list;
    }

    @Override
    protected boolean m_7467_(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.buttonsScreen.m_5953_(mouseX, mouseY);
    }

    private void onNameChanged(String name) {
        if (this.tile != null) {
            ((TinkerStationBlockEntity)this.tile).setItemName(name);
            TinkerNetwork.getInstance().sendToServer(new TinkerStationRenamePacket(name));
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.textField.m_94120_();
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.textField.m_94155_();
        super.m_6574_(pMinecraft, pWidth, pHeight);
        this.textField.m_94144_(s);
    }

    public void m_7861_() {
        super.m_7861_();
        assert (this.f_96541_ != null);
    }

    public void m_7379_() {
        super.m_7379_();
        assert (this.f_96541_ != null);
    }

    @Nonnull
    public StationSlotLayout getDefaultLayout() {
        return this.defaultLayout;
    }

    @Nonnull
    public StationSlotLayout getCurrentLayout() {
        return this.currentLayout;
    }

    public int getMaxInputs() {
        return this.maxInputs;
    }
}

