/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.block.InventoryBlock;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.block.entity.CastingTankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;

public class CastingTankBlock
extends InventoryBlock
implements TankBlockEntity.ITankBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public CastingTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    protected boolean openGui(Player player, Level world, BlockPos pos) {
        return false;
    }

    @Deprecated
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CastingTankBlockEntity(pPos, pState, this);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CastingTankBlockEntity) {
            CastingTankBlockEntity tank = (CastingTankBlockEntity)blockEntity;
            tank.interact(player, hand, hit.m_82450_().f_82480_ - (double)pos.m_123342_() < 0.6875);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ITankBlockEntity) {
            ITankBlockEntity tankBlockEntity = (ITankBlockEntity)te;
            FluidStack fluid = tankBlockEntity.getTank().getFluid();
            return fluid.getFluid().getFluidType().getLightLevel(fluid);
        }
        return super.getLightEmission(state, world, pos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && (blockEntity = worldIn.m_7702_(pos)) instanceof CastingTankBlockEntity) {
            CastingTankBlockEntity tank = (CastingTankBlockEntity)blockEntity;
            tank.updateTank(nbt.m_128469_("tank"));
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    @Deprecated
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (!worldIn.m_5776_() && (blockEntity = worldIn.m_7702_(pos)) instanceof CastingTankBlockEntity) {
            CastingTankBlockEntity tank = (CastingTankBlockEntity)blockEntity;
            tank.handleRedstone(worldIn.m_276867_(pos));
        }
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity;
        if (!worldIn.m_5776_() && (blockEntity = worldIn.m_7702_(pos)) instanceof CastingTankBlockEntity) {
            CastingTankBlockEntity tank = (CastingTankBlockEntity)blockEntity;
            tank.swap();
        }
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return ITankBlockEntity.getComparatorInputOverride((LevelAccessor)worldIn, pos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntityHelper.get(CastingTankBlockEntity.class, (BlockGetter)world, (BlockPos)pos).ifPresent(te -> te.setTankTag(stack));
        return stack;
    }

    @Override
    public int getCapacity() {
        return 4000;
    }
}

