/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public class DynamicModifier
extends LazyModifier {
    private static final AtomicInteger INVALIDATION_COUNTER = new AtomicInteger(0);
    private int invalidationCount = -1;

    public DynamicModifier(ModifierId id) {
        super(id);
    }

    @Override
    protected Modifier getUnchecked() {
        if (this.invalidationCount < INVALIDATION_COUNTER.get()) {
            this.result = null;
        }
        if (this.result == null) {
            this.result = ModifierManager.getValue(this.id);
            this.invalidationCount = INVALIDATION_COUNTER.get();
        }
        return this.result;
    }

    @Override
    public Modifier get() {
        if (!ModifierManager.INSTANCE.isDynamicModifiersLoaded()) {
            throw new IllegalStateException("Cannot fetch a dynamic modifiers before datapacks load");
        }
        Modifier result = this.getUnchecked();
        if (result == ModifierManager.INSTANCE.getDefaultValue()) {
            throw new IllegalStateException("Dynamic modifier for " + this.id + " returned " + ModifierManager.EMPTY + ", this typically means the modifier is not registered");
        }
        return result;
    }

    @Override
    public String toString() {
        return "DynamicModifier{" + this.id + "}";
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ModifierManager.ModifiersLoadedEvent.class, e -> INVALIDATION_COUNTER.incrementAndGet());
    }
}

