/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.math;

import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.floats.FloatStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import slimeknights.tconstruct.library.json.math.StackOperation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PostFixOperator implements StackOperation
{
    ADD("+", Float::sum),
    SUBTRACT("-", (left, right) -> left - right),
    SUBTRACT_FLIPPED("!-", (left, right) -> right - left),
    MULTIPLY("*", (left, right) -> left * right),
    NEGATE("negate"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            stack.push(-stack.popFloat());
        }
    }
    ,
    DIVIDE("/", (left, right) -> {
        if (right == 0.0f) {
            return 0.0f;
        }
        return left / right;
    }),
    DIVIDE_FLIPPED("!/", (left, right) -> {
        if (left == 0.0f) {
            return 0.0f;
        }
        return right / left;
    }),
    POWER("^", (left, right) -> (float)Math.pow(left, right)),
    POWER_FLIPPED("!^", (left, right) -> (float)Math.pow(right, left)),
    EQUAL("==", (left, right) -> left == right ? 1.0f : 0.0f),
    NOT_EQUAL("!=", (left, right) -> left != right ? 1.0f : 0.0f),
    LESS_THAN("<", (left, right) -> left < right ? 1.0f : 0.0f),
    LESS_THAN_EQUAL("<=", (left, right) -> left <= right ? 1.0f : 0.0f),
    GREATER_THAN(">", (left, right) -> left > right ? 1.0f : 0.0f),
    GREATER_THAN_EQUAL(">=", (left, right) -> left >= right ? 1.0f : 0.0f),
    EQUAL_EPS("~~", (left, right) -> Mth.m_14033_((float)left, (float)right) ? 1.0f : 0.0f),
    NOT_EQUAL_EPS("!~", (left, right) -> Mth.m_14033_((float)left, (float)right) ? 0.0f : 1.0f),
    MIN("min", Math::min),
    MAX("max", Math::max),
    NON_NEGATIVE("non-negative"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            float value = stack.topFloat();
            if (value < 0.0f) {
                stack.popFloat();
                stack.push(0.0f);
            }
        }
    }
    ,
    PERCENT_CLAMP("percent_clamp"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            float value = stack.topFloat();
            if (value < 0.0f) {
                stack.popFloat();
                stack.push(0.0f);
            } else if (value > 1.0f) {
                stack.popFloat();
                stack.push(1.0f);
            }
        }
    }
    ,
    ABS("abs"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            float value = stack.topFloat();
            if (value < 0.0f) {
                stack.popFloat();
                stack.push(-value);
            }
        }
    }
    ,
    FLOOR("floor"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            stack.push((float)Mth.m_14143_((float)stack.popFloat()));
        }
    }
    ,
    CEIL("ceil"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            stack.push((float)Mth.m_14167_((float)stack.popFloat()));
        }
    }
    ,
    SWAP("swap"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            float first = stack.popFloat();
            float second = stack.popFloat();
            stack.push(first);
            stack.push(second);
        }
    }
    ,
    DUPLICATE("duplicate"){

        @Override
        public void perform(FloatStack stack, float[] variables) {
            stack.push(stack.topFloat());
        }
    };

    public static final int VALUE_INDEX;
    public static final int VARIABLE_INDEX;
    private final String serialized;
    private final BinaryOperator binary;

    private PostFixOperator(String serialized) {
        this(serialized, BinaryOperator.ZERO);
    }

    @Override
    public void perform(FloatStack stack, float[] variables) {
        float right = stack.popFloat();
        float left = stack.popFloat();
        stack.push(this.binary.apply(left, right));
    }

    public static PostFixOperator deserialize(String name) {
        for (PostFixOperator operator : PostFixOperator.values()) {
            if (!operator.serialized.equals(name)) continue;
            return operator;
        }
        throw new JsonSyntaxException("Unknown post fix operator '" + name + "'");
    }

    @Override
    public JsonPrimitive serialize(String[] variableNames) {
        return new JsonPrimitive(this.serialized);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this);
    }

    private PostFixOperator(String serialized, BinaryOperator binary) {
        this.serialized = serialized;
        this.binary = binary;
    }

    static {
        VALUE_INDEX = PostFixOperator.values().length;
        VARIABLE_INDEX = VALUE_INDEX + 1;
    }

    private static interface BinaryOperator {
        public static final BinaryOperator ZERO = (left, right) -> 0.0f;

        public float apply(float var1, float var2);
    }
}

