/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.registration.GeodeItemObject;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum Sounds {
    SAW("little_saw"),
    ITEM_FRAME_CLICK,
    CASTING_COOLS,
    CASTING_CLICKS,
    EARTH_CRYSTAL_CHIME("block.earth_crystal.chime"),
    SKY_CRYSTAL_CHIME("block.sky_crystal.chime"),
    ICHOR_CRYSTAL_CHIME("block.ichor_crystal.chime"),
    ENDER_CRYSTAL_CHIME("block.ender_crystal.chime"),
    SLIME_SLING,
    SLIME_SLING_TELEPORT("slime_sling.teleport"),
    THROWBALL_THROW("throw.throwball"),
    SHURIKEN_THROW("throw.shuriken"),
    LONGBOW_CHARGE("longbow.charge"),
    CRYSTALSHOT,
    BONK,
    SPIT,
    NECROTIC_HEAL,
    ENDERPORTING,
    EXTRA_JUMP,
    SLIME_TELEPORT,
    SLIMY_BOUNCE("slimy_bounce"),
    EQUIP_SLIME("equip.slime"),
    EQUIP_TRAVELERS("equip.travelers"),
    EQUIP_PLATE("equip.plate"),
    TOY_SQUEAK,
    CROSSBOW_RELOAD,
    STONE_HIT,
    WOOD_HIT,
    CHARGED,
    DISCHARGE;

    private final SoundEvent sound;
    public static final SoundType EARTH_CRYSTAL;
    public static final Map<GeodeItemObject.BudSize, SoundType> EARTH_CRYSTAL_CLUSTER;
    public static final SoundType SKY_CRYSTAL;
    public static final Map<GeodeItemObject.BudSize, SoundType> SKY_CRYSTAL_CLUSTER;
    public static final SoundType ICHOR_CRYSTAL;
    public static final Map<GeodeItemObject.BudSize, SoundType> ICHOR_CRYSTAL_CLUSTER;
    public static final SoundType ENDER_CRYSTAL;
    public static final Map<GeodeItemObject.BudSize, SoundType> ENDER_CRYSTAL_CLUSTER;

    private static SoundEvent createEvent(String name) {
        return SoundEvent.m_262824_((ResourceLocation)TConstruct.getResource(name));
    }

    private Sounds(String name) {
        this.sound = Sounds.createEvent(name);
    }

    private Sounds() {
        this.sound = Sounds.createEvent(this.name().toLowerCase(Locale.US));
    }

    @SubscribeEvent
    public static void registerSounds(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256840_) {
            for (Sounds sound : Sounds.values()) {
                ForgeRegistries.SOUND_EVENTS.register(sound.sound.m_11660_(), (Object)sound.getSound());
            }
        }
    }

    private static SoundType makeCrystalSound(float pitch) {
        return new SoundType(1.0f, pitch, SoundEvents.f_144242_, SoundEvents.f_144049_, SoundEvents.f_144048_, SoundEvents.f_144245_, SoundEvents.f_144244_);
    }

    private static Map<GeodeItemObject.BudSize, SoundType> makeClusterSounds(float pitch) {
        EnumMap<GeodeItemObject.BudSize, SoundType> map = new EnumMap<GeodeItemObject.BudSize, SoundType>(GeodeItemObject.BudSize.class);
        map.put(GeodeItemObject.BudSize.CLUSTER, new SoundType(1.0f, pitch, SoundEvents.f_144050_, SoundEvents.f_144054_, SoundEvents.f_144053_, SoundEvents.f_144052_, SoundEvents.f_144051_));
        map.put(GeodeItemObject.BudSize.SMALL, new SoundType(1.0f, pitch, SoundEvents.f_144224_, SoundEvents.f_144054_, SoundEvents.f_144225_, SoundEvents.f_144052_, SoundEvents.f_144051_));
        map.put(GeodeItemObject.BudSize.MEDIUM, new SoundType(1.0f, pitch, SoundEvents.f_144192_, SoundEvents.f_144054_, SoundEvents.f_144193_, SoundEvents.f_144052_, SoundEvents.f_144051_));
        map.put(GeodeItemObject.BudSize.LARGE, new SoundType(1.0f, pitch, SoundEvents.f_144179_, SoundEvents.f_144054_, SoundEvents.f_144180_, SoundEvents.f_144052_, SoundEvents.f_144051_));
        return map;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    static {
        EARTH_CRYSTAL = Sounds.makeCrystalSound(0.75f);
        EARTH_CRYSTAL_CLUSTER = Sounds.makeClusterSounds(0.75f);
        SKY_CRYSTAL = Sounds.makeCrystalSound(1.2f);
        SKY_CRYSTAL_CLUSTER = Sounds.makeClusterSounds(1.2f);
        ICHOR_CRYSTAL = Sounds.makeCrystalSound(0.35f);
        ICHOR_CRYSTAL_CLUSTER = Sounds.makeClusterSounds(0.35f);
        ENDER_CRYSTAL = Sounds.makeCrystalSound(1.45f);
        ENDER_CRYSTAL_CLUSTER = Sounds.makeClusterSounds(1.45f);
    }
}

