/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

class UpgradeContainer
implements Container {
    private static final int SIZE = 2;
    private final ITurtleAccess turtle;
    private final List<UpgradeData<ITurtleUpgrade>> lastUpgrade = Arrays.asList(null, null);
    private final NonNullList<ItemStack> lastStack = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);

    UpgradeContainer(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    private TurtleSide getSide(int slot) {
        return switch (slot) {
            case 0 -> TurtleSide.LEFT;
            case 1 -> TurtleSide.RIGHT;
            default -> throw new IllegalArgumentException("Invalid slot " + slot);
        };
    }

    public ItemStack m_8020_(int slot) {
        TurtleSide side = this.getSide(slot);
        UpgradeData<ITurtleUpgrade> upgrade = this.turtle.getUpgradeWithData(side);
        if (upgrade == null) {
            return ItemStack.f_41583_;
        }
        if (upgrade.equals(this.lastUpgrade.get(slot))) {
            return (ItemStack)this.lastStack.get(slot);
        }
        return this.setUpgradeStack(slot, upgrade);
    }

    private ItemStack setUpgradeStack(int slot, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        ItemStack stack = upgrade == null ? ItemStack.f_41583_ : upgrade.getUpgradeItem();
        this.lastUpgrade.set(slot, UpgradeData.copyOf(upgrade));
        this.lastStack.set(slot, (Object)stack);
        return stack;
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        UpgradeData<ITurtleUpgrade> upgrade = TurtleUpgrades.instance().get(itemStack);
        this.turtle.setUpgradeWithData(this.getSide(slot), upgrade);
        this.setUpgradeStack(slot, upgrade);
    }

    public int m_6643_() {
        return 2;
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7983_() {
        for (int i = 0; i < 2; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_7407_(int slot, int count) {
        return count <= 0 ? ItemStack.f_41583_ : this.m_8016_(slot);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack current = this.m_8020_(slot);
        this.m_6836_(slot, ItemStack.f_41583_);
        return current;
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < 2; ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }
}

