/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.MediaProvider;
import dan200.computercraft.shared.ModRegistry;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jspecify.annotations.Nullable;

public final class MediaProviders {
    private static final Map<Item, MediaProvider> itemProviders = new HashMap<Item, MediaProvider>();
    private static final Set<MediaProvider> providers = new LinkedHashSet<MediaProvider>();

    private MediaProviders() {
    }

    public static synchronized void register(MediaProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    public static @Nullable IMedia get(ItemStack stack) {
        IMedia media;
        if (stack.m_41619_()) {
            return null;
        }
        MediaProvider itemProvider = itemProviders.get(stack.m_41720_());
        if (itemProvider != null && (media = itemProvider.getMedia(stack)) != null) {
            return media;
        }
        for (MediaProvider mediaProvider : providers) {
            IMedia media2 = mediaProvider.getMedia(stack);
            if (media2 == null) continue;
            return media2;
        }
        return null;
    }

    public static synchronized void registerDefault() {
        ModRegistry.registerMedia(new ModRegistry.ItemComponent<IMedia>(){

            @Override
            public void registerForItems(BiFunction<ItemStack, @Nullable Void, @Nullable IMedia> provider, ItemLike ... items) {
                MediaProvider wrappedProvider = s -> (IMedia)provider.apply(s, null);
                for (ItemLike item : items) {
                    itemProviders.put(item.m_5456_(), wrappedProvider);
                }
            }

            @Override
            public void registerFallback(BiFunction<ItemStack, @Nullable Void, @Nullable IMedia> provider) {
                MediaProviders.register(s -> (IMedia)provider.apply(s, null));
            }
        });
    }
}

