/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.google.common.collect.Multimap;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlockItem;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItem;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.levelWrappers.WrappedServerLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.extensions.IForgeBaseRailBlock;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerHandler {
    private static final Map<BlockPos, List<ItemEntity>> CAPTURED_BLOCK_DROPS = new HashMap<BlockPos, List<ItemEntity>>();
    public static final Map<BlockPos, List<ItemEntity>> CAPTURED_BLOCK_DROPS_VIEW = Collections.unmodifiableMap(CAPTURED_BLOCK_DROPS);

    static boolean shouldActivate(ItemStack held, Level world, BlockPos targetPos, @Nullable Direction facing) {
        BucketItem bucketItem;
        Fluid fluid;
        if (held.m_41720_() instanceof BlockItem && world.m_8055_(targetPos).m_60734_() == ((BlockItem)held.m_41720_()).m_40614_()) {
            return false;
        }
        Item item = held.m_41720_();
        if (item instanceof BucketItem && (fluid = (bucketItem = (BucketItem)item).getFluid()) != Fluids.f_76191_ && world.m_6425_(targetPos).m_76152_() == fluid) {
            return false;
        }
        return held.m_41619_() || facing != Direction.DOWN || BlockEntityBehaviour.get((BlockGetter)world, targetPos, TransportedItemStackHandlerBehaviour.TYPE) == null;
    }

    static void activate(DeployerFakePlayer player, Vec3 vec, BlockPos clickedPos, Vec3 extensionVector, DeployerBlockEntity.Mode mode) {
        Multimap attributeModifiers = player.m_21205_().m_41638_(EquipmentSlot.MAINHAND);
        player.m_21204_().m_22178_(attributeModifiers);
        DeployerHandler.activateInner(player, vec, clickedPos, extensionVector, mode);
        player.m_21204_().m_22161_(attributeModifiers);
    }

    private static void activateInner(DeployerFakePlayer player, Vec3 vec, BlockPos clickedPos, Vec3 extensionVector, DeployerBlockEntity.Mode mode) {
        CompoundTag tag;
        ItemStack resultStack;
        InteractionResultHolder onItemRightClick;
        InteractionResult onItemUse;
        boolean flag1;
        InteractionResult actionresult;
        ClipContext rayTraceContext;
        BlockHitResult result;
        Vec3 rayOrigin = vec.m_82549_(extensionVector.m_82490_(1.515625));
        Vec3 rayTarget = vec.m_82549_(extensionVector.m_82490_(2.484375));
        player.m_6034_(rayOrigin.f_82479_, rayOrigin.f_82480_, rayOrigin.f_82481_);
        BlockPos pos = BlockPos.m_274446_((Position)vec);
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        ServerLevel level = player.m_284548_();
        List entities = level.m_45976_(Entity.class, new AABB(clickedPos)).stream().filter(e -> !(e instanceof AbstractContraptionEntity)).collect(Collectors.toList());
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!entities.isEmpty()) {
            Entity entity = (Entity)entities.get(level.f_46441_.m_188503_(entities.size()));
            ArrayList capturedDrops = new ArrayList();
            boolean success = false;
            entity.captureDrops(capturedDrops);
            if (mode == DeployerBlockEntity.Mode.USE) {
                InteractionResult cancelResult = ForgeHooks.onInteractEntity((Player)player, (Entity)entity, (InteractionHand)hand);
                if (cancelResult == InteractionResult.FAIL) {
                    entity.captureDrops(null);
                    return;
                }
                if (cancelResult == null) {
                    if (entity.m_6096_((Player)player, hand).m_19077_()) {
                        AbstractVillager villager;
                        if (entity instanceof AbstractVillager && (villager = (AbstractVillager)entity).m_7962_() instanceof DeployerFakePlayer) {
                            villager.m_7189_(null);
                        }
                        success = true;
                    } else if (entity instanceof LivingEntity && stack.m_41647_((Player)player, (LivingEntity)entity, hand).m_19077_()) {
                        success = true;
                    }
                }
                if (!success && entity instanceof Player) {
                    FoodProperties foodProperties;
                    Player playerEntity = (Player)entity;
                    if (stack.m_41614_() && playerEntity.m_36391_((foodProperties = item.getFoodProperties(stack, (LivingEntity)player)).m_38747_())) {
                        ItemStack copy = stack.m_41777_();
                        player.m_21008_(hand, stack.m_41671_((Level)level, (LivingEntity)playerEntity));
                        player.spawnedItemEffects = copy;
                        success = true;
                    }
                    if (AllTags.AllItemTags.DEPLOYABLE_DRINK.matches(stack)) {
                        player.spawnedItemEffects = stack.m_41777_();
                        player.m_21008_(hand, stack.m_41671_((Level)level, (LivingEntity)playerEntity));
                        success = true;
                    }
                }
            }
            if (mode == DeployerBlockEntity.Mode.PUNCH) {
                player.m_36334_();
                player.m_5706_(entity);
                success = true;
            }
            entity.captureDrops(null);
            capturedDrops.forEach(e -> player.m_150109_().m_150079_(e.m_32055_()));
            if (success) {
                return;
            }
        }
        if ((result = level.m_45547_(rayTraceContext = new ClipContext(rayOrigin, rayTarget, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player))).m_82425_() != clickedPos) {
            result = new BlockHitResult(result.m_82450_(), result.m_82434_(), clickedPos, result.m_82436_());
        }
        BlockState clickedState = level.m_8055_(clickedPos);
        Direction face = result.m_82434_();
        if (face == null) {
            face = Direction.m_122366_((double)extensionVector.f_82479_, (double)extensionVector.f_82480_, (double)extensionVector.f_82481_).m_122424_();
        }
        if (mode == DeployerBlockEntity.Mode.PUNCH) {
            if (!level.m_7966_((Player)player, clickedPos)) {
                return;
            }
            if (clickedState.m_60808_((BlockGetter)level, clickedPos).m_83281_()) {
                player.blockBreakingProgress = null;
                return;
            }
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)clickedPos, (Direction)face);
            if (event.isCanceled()) {
                return;
            }
            if (BlockHelper.extinguishFire((Level)level, (Player)player, clickedPos, face)) {
                return;
            }
            if (event.getUseBlock() != Event.Result.DENY) {
                clickedState.m_60686_((Level)level, clickedPos, (Player)player);
            }
            if (stack.m_41619_()) {
                return;
            }
            float progress = clickedState.m_60625_((Player)player, (BlockGetter)level, clickedPos) * 16.0f;
            float before = 0.0f;
            Pair<BlockPos, Float> blockBreakingProgress = player.blockBreakingProgress;
            if (blockBreakingProgress != null) {
                before = ((Float)blockBreakingProgress.getValue()).floatValue();
            }
            progress += before;
            level.m_5594_(null, clickedPos, clickedState.m_60827_().m_56778_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
            if (progress >= 1.0f) {
                DeployerHandler.tryHarvestBlock((ServerPlayer)player, player.f_8941_, clickedPos);
                level.m_6801_(player.m_19879_(), clickedPos, -1);
                player.blockBreakingProgress = null;
                return;
            }
            if (progress <= 0.0f) {
                player.blockBreakingProgress = null;
                return;
            }
            if ((int)(before * 10.0f) != (int)(progress * 10.0f)) {
                level.m_6801_(player.m_19879_(), clickedPos, (int)(progress * 10.0f));
            }
            player.blockBreakingProgress = Pair.of((Object)clickedPos, (Object)Float.valueOf(progress));
            return;
        }
        UseOnContext itemusecontext = new UseOnContext((Player)player, hand, result);
        Event.Result useBlock = Event.Result.DEFAULT;
        Event.Result useItem = Event.Result.DEFAULT;
        if (!clickedState.m_60808_((BlockGetter)level, clickedPos).m_83281_()) {
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)hand, (BlockPos)clickedPos, (BlockHitResult)result);
            useBlock = event.getUseBlock();
            useItem = event.getUseItem();
        }
        if (useItem != Event.Result.DENY && (actionresult = stack.onItemUseFirst(itemusecontext)) != InteractionResult.PASS) {
            return;
        }
        boolean holdingSomething = !player.m_21205_().m_41619_();
        boolean bl = flag1 = !player.m_6144_() || !holdingSomething || stack.doesSneakBypassUse((LevelReader)level, clickedPos, (Player)player);
        if (useBlock != Event.Result.DENY && flag1 && DeployerHandler.safeOnUse(clickedState, (Level)level, clickedPos, (Player)player, hand, result).m_19077_()) {
            return;
        }
        if (stack.m_41619_()) {
            return;
        }
        if (useItem == Event.Result.DENY) {
            return;
        }
        if (item instanceof CartAssemblerBlockItem && clickedState.m_60629_(new BlockPlaceContext(itemusecontext))) {
            return;
        }
        if (item == Items.f_42409_) {
            Direction newFace = result.m_82434_();
            BlockPos newPos = result.m_82425_();
            if (!BaseFireBlock.m_49255_((Level)level, (BlockPos)clickedPos, (Direction)newFace)) {
                newFace = Direction.UP;
            }
            if (clickedState.m_60795_()) {
                newPos = newPos.m_121945_(face.m_122424_());
            }
            result = new BlockHitResult(result.m_82450_(), newFace, newPos, result.m_82436_());
            itemusecontext = new UseOnContext((Player)player, hand, result);
        }
        if ((onItemUse = stack.m_41661_(itemusecontext)).m_19077_()) {
            BlockItem bi;
            if (item instanceof BlockItem && ((bi = (BlockItem)item).m_40614_() instanceof IForgeBaseRailBlock || bi.m_40614_() instanceof ITrackBlock)) {
                player.placedTracks = true;
            }
            return;
        }
        if (item == Items.f_42584_) {
            return;
        }
        if (AllTags.AllItemTags.DEPLOYABLE_DRINK.matches(item)) {
            return;
        }
        Object itemUseWorld = level;
        if (item instanceof BucketItem || item instanceof SandPaperItem) {
            itemUseWorld = new ItemUseWorld(level, face, pos);
        }
        if ((onItemRightClick = item.m_7203_((Level)itemUseWorld, (Player)player, hand)).m_19089_().m_19077_() && item instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)item;
            bucketItem.m_142131_((Player)player, (Level)level, stack, clickedPos);
        }
        if ((resultStack = (ItemStack)onItemRightClick.m_19095_()) != stack || resultStack.m_41613_() != stack.m_41613_() || resultStack.m_41779_() > 0 || resultStack.m_41773_() != stack.m_41773_()) {
            player.m_21008_(hand, (ItemStack)onItemRightClick.m_19095_());
        }
        if ((tag = stack.m_41783_()) != null && stack.m_41720_() instanceof SandPaperItem && tag.m_128441_("Polishing")) {
            player.spawnedItemEffects = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Polishing"));
            AllSoundEvents.SANDING_SHORT.playOnServer((Level)level, (Vec3i)pos, 0.25f, 1.0f);
        }
        if (!player.m_21211_().m_41619_()) {
            player.m_21008_(hand, stack.m_41671_((Level)level, (LivingEntity)player));
        }
        player.m_5810_();
    }

    public static boolean tryHarvestBlock(ServerPlayer player, ServerPlayerGameMode interactionManager, BlockPos pos) {
        ServerLevel world = player.m_284548_();
        BlockState blockstate = world.m_8055_(pos);
        GameType gameType = interactionManager.m_9290_();
        if (ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos) == -1) {
            return false;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (player.m_21205_().onBlockStartBreak(pos, (Player)player)) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, gameType)) {
            return false;
        }
        ItemStack prevHeldItem = player.m_21205_();
        ItemStack heldItem = prevHeldItem.m_41777_();
        boolean canHarvest = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
        prevHeldItem.m_41686_((Level)world, blockstate, pos, (Player)player);
        if (prevHeldItem.m_41619_() && !heldItem.m_41619_()) {
            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)heldItem, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        BlockPos posUp = pos.m_7494_();
        BlockState stateUp = world.m_8055_(posUp);
        if (blockstate.m_60734_() instanceof DoublePlantBlock && blockstate.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER && stateUp.m_60734_() == blockstate.m_60734_() && stateUp.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            world.m_7731_(posUp, Blocks.f_50016_.m_49966_(), 35);
        } else if (!blockstate.onDestroyedByPlayer((Level)world, pos, (Player)player, canHarvest, world.m_6425_(pos))) {
            return true;
        }
        blockstate.m_60734_().m_6786_((LevelAccessor)world, pos, blockstate);
        if (!canHarvest) {
            return true;
        }
        Block.m_49874_((BlockState)blockstate, (ServerLevel)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)prevHeldItem).forEach(item -> player.m_150109_().m_150079_(item));
        blockstate.m_222967_(world, pos, prevHeldItem, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractionResult safeOnUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ArrayList drops = new ArrayList(4);
        CAPTURED_BLOCK_DROPS.put(pos, drops);
        try {
            InteractionResult result = state.m_60664_(world, player, hand, ray);
            for (ItemEntity itemEntity : drops) {
                player.m_150109_().m_150079_(itemEntity.m_32055_());
            }
            InteractionResult interactionResult = result;
            return interactionResult;
        }
        finally {
            CAPTURED_BLOCK_DROPS.remove(pos);
        }
    }

    private static final class ItemUseWorld
    extends WrappedServerLevel {
        private final Direction face;
        private final BlockPos pos;
        boolean rayMode = false;

        private ItemUseWorld(ServerLevel level, Direction face, BlockPos pos) {
            super(level);
            this.face = face;
            this.pos = pos;
        }

        public BlockHitResult m_45547_(ClipContext context) {
            this.rayMode = true;
            BlockHitResult rayTraceBlocks = super.m_45547_(context);
            this.rayMode = false;
            return rayTraceBlocks;
        }

        public BlockState m_8055_(BlockPos position) {
            if (this.rayMode && (this.pos.m_5484_(this.face.m_122424_(), 3).equals((Object)position) || this.pos.m_5484_(this.face.m_122424_(), 1).equals((Object)position))) {
                return Blocks.f_50752_.m_49966_();
            }
            return this.level.m_8055_(position);
        }
    }
}

