/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.command.ArgumentBuilderBuilder;
import mcp.mobius.waila.command.CommonCommand;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.gui.screen.InspectorScreen;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class ClientCommand<S>
extends CommonCommand<S, Minecraft> {
    public ClientCommand() {
        super("wailac");
    }

    @Override
    protected boolean pluginCommandRequirement(S source) {
        return !Minecraft.m_91087_().m_91091_();
    }

    @Override
    protected boolean isPluginDisabledOnServer(PluginInfo plugin) {
        return plugin.isDisabledOnServer();
    }

    @Override
    protected final void register(ArgumentBuilderBuilder<S> command) {
        command.then((ArgumentBuilder<S, ?>)this.literal("config")).then((ArgumentBuilder<S, ?>)this.literal("open")).executes(context -> {
            Minecraft client = Minecraft.m_91087_();
            client.m_6937_(() -> client.m_91152_((Screen)new HomeScreen(client.f_91080_)));
            return 1;
        }).pop("open").then((ArgumentBuilder<S, ?>)this.literal("plugin")).then(this.argument("id", ResourceLocationArgument.m_106984_())).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(PluginConfig.getAllKeys(), (SuggestionsBuilder)builder)).executes(context -> {
            Object source = context.getSource();
            ResourceLocation id = (ResourceLocation)context.getArgument("id", ResourceLocation.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry == null) {
                this.fail(source, (Component)Component.m_237110_((String)"command.waila.config.unknown_id", (Object[])new Object[]{id}));
                return 0;
            }
            this.success(source, () -> Component.m_237110_((String)"command.waila.config.get.id", (Object[])new Object[]{id}));
            this.success(source, () -> Component.m_237110_((String)"command.waila.config.get.synced", (Object[])new Object[]{entry.isSynced()}));
            this.success(source, () -> Component.m_237110_((String)"command.waila.config.get.current_value", (Object[])new Object[]{entry.getValue(false).toString()}));
            this.success(source, () -> Component.m_237110_((String)"command.waila.config.get.default_value", (Object[])new Object[]{entry.getDefaultValue().toString()}));
            if (entry.isServerRequired()) {
                this.success(source, () -> Component.m_237110_((String)"command.waila.config.get.client_only_value", (Object[])new Object[]{entry.getClientOnlyValue().toString()}));
            }
            return 1;
        }).then(this.argument("value", StringArgumentType.word())).suggests((context, builder) -> {
            ResourceLocation id = (ResourceLocation)context.getArgument("id", ResourceLocation.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry != null) {
                if (entry.getType().equals(ConfigEntry.BOOLEAN)) {
                    return SharedSuggestionProvider.m_82967_((String[])new String[]{String.valueOf((Boolean)entry.getValue(false) == false)}, (SuggestionsBuilder)builder);
                }
                if (entry.getType().equals(ConfigEntry.ENUM)) {
                    Stream<String> suggestions = Arrays.stream(entry.getLocalValue().getClass().getEnumConstants()).filter(e -> e != entry.getLocalValue()).map(e -> ((Enum)e).name());
                    return SharedSuggestionProvider.m_82981_(suggestions, (SuggestionsBuilder)builder);
                }
            }
            return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
        }).executes(context -> {
            Object source = context.getSource();
            ResourceLocation id = (ResourceLocation)context.getArgument("id", ResourceLocation.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry == null) {
                this.fail(source, (Component)Component.m_237110_((String)"command.waila.config.unknown_id", (Object[])new Object[]{id}));
                return 0;
            }
            if (entry.blocksClientEdit() && Minecraft.m_91087_().m_91089_() != null) {
                this.fail(source, (Component)Component.m_237110_((String)"command.waila.config.set.synced", (Object[])new Object[]{id}));
            }
            JsonPrimitive jsonValue = new JsonPrimitive((String)context.getArgument("value", String.class));
            try {
                entry.setLocalValue(entry.getType().parser.apply((JsonElement)jsonValue, (JsonElement)entry.getDefaultValue()));
                this.success(source, () -> Component.m_237110_((String)"command.waila.config.set.success", (Object[])new Object[]{id, entry.getLocalValue()}));
                return 1;
            }
            catch (Throwable throwable) {
                this.fail(source, (Component)Component.m_237110_((String)"command.waila.config.set.parse_fail", (Object[])new Object[]{throwable.getMessage()}));
                throwable.printStackTrace();
                return 0;
            }
        }).pop("value", "id", "plugin", "config").then((ArgumentBuilder<S, ?>)this.literal("overlay")).then(this.argument("enabled", BoolArgumentType.bool())).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{String.valueOf(!Waila.CONFIG.get().getGeneral().isDisplayTooltip())}, (SuggestionsBuilder)builder)).executes(context -> {
            Object source = context.getSource();
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            Waila.CONFIG.get().getGeneral().setDisplayTooltip(enabled);
            this.success(source, () -> Component.m_237115_((String)(enabled ? "command.waila.overlay.true" : "command.waila.overlay.false")));
            return enabled ? 1 : 0;
        }).pop("enabled", "overlay");
        if (Waila.ENABLE_DEBUG_COMMAND) {
            command.then((ArgumentBuilder<S, ?>)this.literal("debug")).then((ArgumentBuilder<S, ?>)this.literal("showComponentBounds")).then(this.argument("enabled", BoolArgumentType.bool())).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{String.valueOf(!WailaClient.showComponentBounds)}, (SuggestionsBuilder)builder)).executes(context -> {
                Object source = context.getSource();
                boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
                Minecraft.m_91087_().execute(() -> {
                    WailaClient.showComponentBounds = enabled;
                });
                this.success(source, () -> Component.m_237113_((String)((enabled ? "En" : "Dis") + "abled component bounds")));
                return enabled ? 1 : 0;
            }).pop("enabled", "showComponentBounds").then((ArgumentBuilder<S, ?>)this.literal("showFps")).then(this.argument("enabled", BoolArgumentType.bool())).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{String.valueOf(!WailaClient.showFps)}, (SuggestionsBuilder)builder)).executes(context -> {
                Object source = context.getSource();
                boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
                Minecraft.m_91087_().execute(() -> {
                    WailaClient.showFps = enabled;
                });
                this.success(source, () -> Component.m_237113_((String)((enabled ? "En" : "Dis") + "abled FPS display")));
                return enabled ? 1 : 0;
            }).pop("enabled", "showFps").then((ArgumentBuilder<S, ?>)this.literal("inspect")).executes(context -> {
                Minecraft client = Minecraft.m_91087_();
                client.m_6937_(() -> client.m_91152_((Screen)new InspectorScreen()));
                return 1;
            }).pop("inspect").pop("debug");
        }
    }

    @Override
    protected Minecraft getExecutor(S source) {
        return Minecraft.m_91087_();
    }

    @Override
    protected void reloadPlugins(Minecraft executor) {
        PluginLoader.reloadClientPlugins();
    }
}

