/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.scarecrowsterritory;

import com.supermartijn642.scarecrowsterritory.ReflectionUtil;
import com.supermartijn642.scarecrowsterritory.ScarecrowTracker;
import com.supermartijn642.scarecrowsterritory.ScarecrowsTerritoryConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.ForgeEventFactory;

public class MobSpawningUtil {
    private static final Method canSpawn = ReflectionUtil.findMethod(NaturalSpawner.SpawnState.class, "m_47127_", EntityType.class, BlockPos.class, ChunkAccess.class);
    private static final Method afterSpawn = ReflectionUtil.findMethod(NaturalSpawner.SpawnState.class, "m_47131_", Mob.class, ChunkAccess.class);
    private static final Method getRandomSpawnMobAt = ReflectionUtil.findMethod(NaturalSpawner.class, "m_220429_", ServerLevel.class, StructureManager.class, ChunkGenerator.class, MobCategory.class, RandomSource.class, BlockPos.class);
    private static final Method canSpawnMobAt = ReflectionUtil.findMethod(NaturalSpawner.class, "m_220436_", ServerLevel.class, StructureManager.class, ChunkGenerator.class, MobCategory.class, MobSpawnSettings.SpawnerData.class, BlockPos.class);
    private static final Method getMobForSpawn = ReflectionUtil.findMethod(NaturalSpawner.class, "m_46988_", ServerLevel.class, EntityType.class);
    private static final Method getRandomPosWithin = ReflectionUtil.findMethod(NaturalSpawner.class, "m_47062_", Level.class, LevelChunk.class);

    private static boolean canSpawn(NaturalSpawner.SpawnState densityManager, EntityType<?> type, BlockPos pos, ChunkAccess chunk) {
        try {
            return (Boolean)canSpawn.invoke((Object)densityManager, type, pos, chunk);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void afterSpawn(NaturalSpawner.SpawnState densityManager, Mob entity, ChunkAccess chunk) {
        try {
            afterSpawn.invoke((Object)densityManager, entity, chunk);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory classification, RandomSource random, BlockPos pos) {
        try {
            return (Optional)getRandomSpawnMobAt.invoke(null, world, structureManager, chunkGenerator, classification, random, pos);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static boolean canSpawnMobAt(ServerLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory classification, MobSpawnSettings.SpawnerData spawnerData, BlockPos pos) {
        try {
            return (Boolean)canSpawnMobAt.invoke(null, world, structureManager, chunkGenerator, classification, spawnerData, pos);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Mob getMobForSpawn(ServerLevel level, EntityType<?> entityType) {
        try {
            return (Mob)getMobForSpawn.invoke(null, level, entityType);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BlockPos getRandomPosWithin(Level level, LevelChunk chunk) {
        try {
            return (BlockPos)getRandomPosWithin.invoke(null, level, chunk);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void spawnEntitiesInChunk(ServerLevel level, LevelChunk chunk, NaturalSpawner.SpawnState densityManager, boolean spawnPassives, boolean spawnHostiles, boolean spawnAnimals) {
        level.m_46473_().m_6180_("spawner");
        for (MobCategory classification : NaturalSpawner.f_46979_) {
            if (!spawnPassives && classification.m_21609_() || !spawnHostiles && !classification.m_21609_() || !spawnAnimals && classification.m_21610_() || !MobSpawningUtil.canSpawnForCategory(densityManager, classification, (LevelAccessor)level)) continue;
            MobSpawningUtil.spawnCategoryForChunk(classification, level, chunk, (type, pos, c) -> MobSpawningUtil.canSpawn(densityManager, type, pos, c), (entity, c) -> MobSpawningUtil.afterSpawn(densityManager, entity, c));
        }
        level.m_46473_().m_7238_();
    }

    private static void spawnCategoryForChunk(MobCategory classification, ServerLevel level, LevelChunk chunk, NaturalSpawner.SpawnPredicate densityCheck, NaturalSpawner.AfterSpawnCallback densityAdder) {
        BlockPos blockpos = MobSpawningUtil.getRandomPosWithin((Level)level, chunk);
        if (blockpos.m_123342_() >= level.m_141937_() + 1) {
            MobSpawningUtil.spawnCategoryForPosition(classification, level, (ChunkAccess)chunk, blockpos, densityCheck, densityAdder);
        }
    }

    private static void spawnCategoryForPosition(MobCategory classification, ServerLevel level, ChunkAccess chunk, BlockPos pos, NaturalSpawner.SpawnPredicate densityCheck, NaturalSpawner.AfterSpawnCallback densityAdder) {
        StructureManager structureManager = level.m_215010_();
        ChunkGenerator chunkgenerator = level.m_7726_().m_8481_();
        int y = pos.m_123342_();
        BlockState blockstate = chunk.m_8055_(pos);
        if (!blockstate.m_60796_((BlockGetter)chunk, pos)) {
            BlockPos.MutableBlockPos spawnPos = new BlockPos.MutableBlockPos();
            int entitiesSpawned = 0;
            block0: for (int k = 0; k < 3; ++k) {
                int spawnX = pos.m_123341_();
                int spawnZ = pos.m_123343_();
                MobSpawnSettings.SpawnerData spawner = null;
                SpawnGroupData entityData = null;
                int groupSize = Mth.m_14167_((float)(level.f_46441_.m_188501_() * 4.0f));
                int entitiesInGroup = 0;
                for (int i2 = 0; i2 < groupSize; ++i2) {
                    spawnPos.m_122178_(spawnX += level.f_46441_.m_188503_(6) - level.f_46441_.m_188503_(6), y, spawnZ += level.f_46441_.m_188503_(6) - level.f_46441_.m_188503_(6));
                    double spawnXCenter = (double)spawnX + 0.5;
                    double spawnZCenter = (double)spawnZ + 0.5;
                    if (!ScarecrowTracker.isScarecrowInRange((LevelAccessor)level, pos.m_252807_(), ScarecrowsTerritoryConfig.passiveMobRange.get())) continue;
                    if (spawner == null) {
                        Optional<MobSpawnSettings.SpawnerData> optional = MobSpawningUtil.getRandomSpawnMobAt(level, structureManager, chunkgenerator, classification, level.f_46441_, (BlockPos)spawnPos);
                        if (optional.isEmpty()) continue block0;
                        spawner = optional.get();
                        groupSize = spawner.f_48405_ + level.f_46441_.m_188503_(1 + spawner.f_48406_ - spawner.f_48405_);
                    }
                    if (!MobSpawningUtil.isValidSpawnPositionForType(level, classification, structureManager, chunkgenerator, spawner, spawnPos) || !densityCheck.m_47106_(spawner.f_48404_, (BlockPos)spawnPos, chunk)) continue;
                    Mob entity = MobSpawningUtil.getMobForSpawn(level, spawner.f_48404_);
                    if (entity == null) {
                        return;
                    }
                    entity.getPersistentData().m_128379_("spawnedByScarecrow", true);
                    entity.m_7678_(spawnXCenter, (double)y, spawnZCenter, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                    if (!ForgeEventFactory.checkSpawnPosition((Mob)entity, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL)) continue;
                    entityData = ForgeEventFactory.onFinalizeSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.NATURAL, entityData, null);
                    ++entitiesInGroup;
                    level.m_47205_((Entity)entity);
                    densityAdder.m_47100_(entity, chunk);
                    if (++entitiesSpawned >= ForgeEventFactory.getMaxSpawnPackSize((Mob)entity)) {
                        return;
                    }
                    if (entity.m_7296_(entitiesInGroup)) continue block0;
                }
            }
        }
    }

    private static boolean isValidSpawnPositionForType(ServerLevel level, MobCategory classification, StructureManager structureManager, ChunkGenerator chunkGenerator, MobSpawnSettings.SpawnerData spawners, BlockPos.MutableBlockPos pos) {
        EntityType entityType = spawners.f_48404_;
        if (entityType.m_20674_() == MobCategory.MISC) {
            return false;
        }
        if (entityType.m_20654_() && MobSpawningUtil.canSpawnMobAt(level, structureManager, chunkGenerator, classification, spawners, (BlockPos)pos)) {
            SpawnPlacements.Type placementType = SpawnPlacements.m_21752_((EntityType)entityType);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)placementType, (LevelReader)level, (BlockPos)pos, (EntityType)entityType) || !SpawnPlacements.m_217074_((EntityType)entityType, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)level.f_46441_)) {
                return false;
            }
            return level.m_45772_(entityType.m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5));
        }
        return false;
    }

    private static boolean canSpawnForCategory(NaturalSpawner.SpawnState densityManager, MobCategory classification, LevelAccessor world) {
        int spawnableChunks = Math.max(1, densityManager.m_47126_() / 289);
        return densityManager.m_47148_().getInt((Object)classification) < classification.m_21608_() * spawnableChunks;
    }
}

