/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.test;

import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.EnergyData;
import mcp.mobius.waila.api.data.FluidData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public enum ExtraTest implements IDataProvider<ChestBlockEntity>
{
    INSTANCE;

    public static final ResourceLocation ENERGY;
    public static final ResourceLocation ENERGY_INF_STORED;
    public static final ResourceLocation ENERGY_INF_CAPACITY;
    public static final ResourceLocation FLUID;
    private int tickEnergy = 0;
    private int tickWater = 0;
    private int tickLava = 0;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<ChestBlockEntity> accessor, IPluginConfig config) {
        if (config.getBoolean(ENERGY)) {
            data.add(EnergyData.class, res -> {
                ++this.tickEnergy;
                if (this.tickEnergy == 500) {
                    this.tickEnergy = 0;
                }
                if (config.getBoolean(ENERGY_INF_STORED)) {
                    res.add(EnergyData.of(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
                } else if (config.getBoolean(ENERGY_INF_CAPACITY)) {
                    res.add(EnergyData.of((long)this.tickEnergy * 100L, Double.POSITIVE_INFINITY));
                } else {
                    res.add(EnergyData.of((long)this.tickEnergy * 100L, 50000.0));
                }
            });
        }
        if (config.getBoolean(FLUID)) {
            data.add(FluidData.class, res -> {
                ++this.tickWater;
                if (this.tickWater == 500) {
                    this.tickWater = 0;
                }
                ++this.tickLava;
                if (this.tickLava == 250) {
                    this.tickLava = 0;
                }
                res.add(FluidData.of(FluidData.Unit.MILLIBUCKETS, 2).add((Fluid)Fluids.f_76193_, null, (double)this.tickWater * 100.0, 50000.0).add((Fluid)Fluids.f_76195_, null, (double)this.tickLava * 100.0, 25000.0));
            });
        }
    }

    static {
        ENERGY = new ResourceLocation("test:energy");
        ENERGY_INF_STORED = new ResourceLocation("test:energy.inf_stored");
        ENERGY_INF_CAPACITY = new ResourceLocation("test:energy.inf_capacity");
        FLUID = new ResourceLocation("test:fluid");
    }
}

