/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import java.util.List;
import java.util.Objects;
import java.util.function.ObjDoubleConsumer;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayCaster {
    public static void cast(Level world, Entity camera, Vec3 origin, Vec3 direction, float maxDistance, ObjDoubleConsumer<HitResult> results) {
        boolean showBlock = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK);
        boolean showFluid = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID);
        boolean showEntity = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY);
        Vec3 max = origin.m_82520_(direction.f_82479_ * (double)maxDistance, direction.f_82480_ * (double)maxDistance, direction.f_82481_ * (double)maxDistance);
        if (showBlock || showFluid) {
            BlockGetter.m_151361_((Vec3)origin, (Vec3)max, (Object)Unit.INSTANCE, (unit, pos) -> {
                VoxelShape fluidShape;
                BlockHitResult fluidHit;
                FluidState fluidState;
                BlockState blockState;
                if (showBlock && !(blockState = world.m_8055_(pos)).m_60795_()) {
                    VoxelShape blockShape = blockState.m_60808_((BlockGetter)world, pos);
                    BlockHitResult blockHit = world.m_45558_(origin, max, pos.m_7949_(), blockShape, blockState);
                    if (blockHit != null) {
                        results.accept((HitResult)blockHit, origin.m_82557_(blockHit.m_82450_()));
                    }
                }
                if (showFluid && (fluidState = world.m_6425_(pos)).m_76170_() && (fluidHit = (fluidShape = fluidState.m_76183_((BlockGetter)world, pos)).m_83220_(origin, max, pos.m_7949_())) != null) {
                    results.accept((HitResult)fluidHit, origin.m_82557_(fluidHit.m_82450_()));
                }
                return null;
            }, unit -> unit);
        }
        if (showEntity) {
            List entities = world.m_6249_(camera, new AABB(origin, max), EntitySelector.f_20402_);
            for (Entity entity : entities) {
                AABB bounds = entity.m_20191_();
                Vec3 clip = bounds.m_82371_(origin, max).orElse(null);
                if (bounds.m_82390_(origin)) {
                    clip = Objects.requireNonNullElse(clip, origin);
                }
                if (clip == null) continue;
                results.accept((HitResult)new EntityHitResult(entity, clip), origin.m_82557_(clip));
            }
        }
    }
}

