/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper.terrainzapper;

import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.content.equipment.zapper.terrainzapper.FlattenTool;
import com.simibubi.create.foundation.gui.AllIcons;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum TerrainTools {
    Fill(AllIcons.I_FILL),
    Place(AllIcons.I_PLACE),
    Replace(AllIcons.I_REPLACE),
    Clear(AllIcons.I_CLEAR),
    Overlay(AllIcons.I_OVERLAY),
    Flatten(AllIcons.I_FLATTEN);

    public String translationKey = Lang.asId((String)this.name());
    public AllIcons icon;

    private TerrainTools(AllIcons icon) {
        this.icon = icon;
    }

    public boolean requiresSelectedBlock() {
        return this != Clear && this != Flatten;
    }

    public void run(Level world, List<BlockPos> targetPositions, Direction facing, @Nullable BlockState paintedState, @Nullable CompoundTag data, Player player) {
        switch (this) {
            case Clear: {
                targetPositions.forEach(p -> world.m_46597_(p, Blocks.f_50016_.m_49966_()));
                break;
            }
            case Fill: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.m_8055_(p);
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.m_46597_(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case Flatten: {
                FlattenTool.apply(world, targetPositions, facing);
                break;
            }
            case Overlay: {
                targetPositions.forEach(p -> {
                    BlockState toOverlay = world.m_8055_(p);
                    if (TerrainTools.isReplaceable(toOverlay)) {
                        return;
                    }
                    if (toOverlay == paintedState) {
                        return;
                    }
                    BlockState toReplace = world.m_8055_(p = p.m_7494_());
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.m_46597_(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case Place: {
                targetPositions.forEach(p -> {
                    world.m_46597_(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case Replace: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.m_8055_(p);
                    if (TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.m_46597_(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
            }
        }
    }

    public static boolean isReplaceable(BlockState toReplace) {
        return toReplace.m_247087_();
    }
}

