/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.roller;

import com.simibubi.create.content.contraptions.actors.roller.PaveTask;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.track.BezierConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TrackPaverV2 {
    public static void pave(PaveTask task, TrackGraph graph, TrackEdge edge, double from, double to) {
        if (edge.isTurn()) {
            TrackPaverV2.paveCurve(task, edge.getTurn(), from, to);
            return;
        }
        Vec3 location1 = edge.node1.getLocation().getLocation();
        Vec3 location2 = edge.node2.getLocation().getLocation();
        Vec3 diff = location2.m_82546_(location1);
        Vec3 direction = VecHelper.clampComponentWise((Vec3)diff, (float)1.0f);
        int extent = (int)Math.round((to - from) / direction.m_82553_());
        double length = edge.getLength();
        BlockPos pos = BlockPos.m_274446_((Position)edge.getPosition(graph, Mth.m_14008_((double)from, (double)0.0625, (double)(length - 0.0625)) / length).m_82492_(0.0, diff.f_82480_ != 0.0 ? 1.0 : 0.5, 0.0));
        TrackPaverV2.paveStraight(task, pos, direction, extent);
    }

    public static void paveStraight(PaveTask task, BlockPos startPos, Vec3 direction, int extent) {
        HashSet<BlockPos> toPlaceOn = new HashSet<BlockPos>();
        Vec3 start = VecHelper.getCenterOf((Vec3i)startPos);
        Vec3 mainNormal = direction.m_82537_(new Vec3(0.0, 1.0, 0.0));
        Vec3 normalizedDirection = direction.m_82541_();
        boolean isDiagonalTrack = direction.m_82542_(1.0, 0.0, 1.0).m_82553_() > 1.125;
        double r1 = (Double)task.getHorizontalInterval().getFirst();
        int flip = (int)Math.signum(r1);
        double r2 = r1 + (double)flip;
        if (isDiagonalTrack) {
            r1 /= (double)Mth.f_13994_;
            r2 /= (double)Mth.f_13994_;
        }
        int currentOffset = (int)(Math.abs(r1) * 2.0 + 0.5);
        int nextOffset = (int)(Math.abs(r2) * 2.0 + 0.5);
        for (int i = 0; i < extent; ++i) {
            boolean placeSides;
            Vec3 offset = direction.m_82490_((double)i);
            Vec3 mainPos = start.m_82520_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            Vec3 targetVec = mainPos.m_82549_(mainNormal.m_82490_((double)(flip * (int)((double)currentOffset / 2.0))));
            if (!isDiagonalTrack) {
                toPlaceOn.add(BlockPos.m_274446_((Position)targetVec));
                continue;
            }
            boolean placeRow = currentOffset % 2 == 0 || nextOffset % 2 == 1;
            boolean bl = placeSides = currentOffset % 2 == 1 || nextOffset % 2 == 0;
            if (placeSides) {
                for (int side : Iterate.positiveAndNegative) {
                    Vec3 sideOffset = normalizedDirection.m_82490_((double)side).m_82549_(mainNormal.m_82541_().m_82490_((double)flip)).m_82490_(0.5);
                    toPlaceOn.add(BlockPos.m_274446_((Position)targetVec.m_82549_(sideOffset)));
                }
            }
            if (!placeRow) continue;
            if (Math.abs(currentOffset % 2) == 1) {
                targetVec = mainPos.m_82549_(mainNormal.m_82490_((double)(flip * (int)((double)(currentOffset + 1) / 2.0))));
            }
            toPlaceOn.add(BlockPos.m_274446_((Position)targetVec));
        }
        toPlaceOn.forEach(task::put);
    }

    public static void paveCurve(PaveTask task, BezierConnection bc, double from, double to) {
        HashMap<Pair, Double> yLevels = new HashMap<Pair, Double>();
        HashMap<Pair, Double> tLevels = new HashMap<Pair, Double>();
        BlockPos bePosition = (BlockPos)bc.bePositions.getFirst();
        double radius = -((Double)task.getHorizontalInterval().getFirst()).doubleValue();
        double r1 = radius - 0.575;
        double r2 = radius + 0.575;
        double handleLength = bc.getHandleLength();
        Vec3 start = ((Vec3)bc.starts.getFirst()).m_82546_(Vec3.m_82528_((Vec3i)bePosition)).m_82520_(0.0, 0.1875, 0.0);
        Vec3 end = ((Vec3)bc.starts.getSecond()).m_82546_(Vec3.m_82528_((Vec3i)bePosition)).m_82520_(0.0, 0.1875, 0.0);
        Vec3 startHandle = ((Vec3)bc.axes.getFirst()).m_82490_(handleLength).m_82549_(start);
        Vec3 endHandle = ((Vec3)bc.axes.getSecond()).m_82490_(handleLength).m_82549_(end);
        Vec3 startNormal = (Vec3)bc.normals.getFirst();
        Vec3 endNormal = (Vec3)bc.normals.getSecond();
        int segCount = bc.getSegmentCount();
        float[] lut = bc.getStepLUT();
        double localFrom = from / bc.getLength();
        double localTo = to / bc.getLength();
        for (int i = 0; i < segCount; ++i) {
            float t1;
            float t = i == segCount ? 1.0f : (float)i * lut[i] / (float)segCount;
            float f = t1 = i + 1 == segCount ? 1.0f : (float)(i + 1) * lut[i + 1] / (float)segCount;
            if ((double)t1 < localFrom || (double)t > localTo) continue;
            Vec3 vt = VecHelper.bezier((Vec3)start, (Vec3)end, (Vec3)startHandle, (Vec3)endHandle, (float)t);
            Vec3 vNormal = startNormal.equals((Object)endNormal) ? startNormal : VecHelper.slerp((float)t, (Vec3)startNormal, (Vec3)endNormal);
            Vec3 hNormal = vNormal.m_82537_(VecHelper.bezierDerivative((Vec3)start, (Vec3)end, (Vec3)startHandle, (Vec3)endHandle, (float)t).m_82541_()).m_82541_();
            vt = vt.m_82549_(vNormal.m_82490_((double)-1.175f));
            Vec3 vt1 = VecHelper.bezier((Vec3)start, (Vec3)end, (Vec3)startHandle, (Vec3)endHandle, (float)t1);
            Vec3 vNormal1 = startNormal.equals((Object)endNormal) ? startNormal : VecHelper.slerp((float)t1, (Vec3)startNormal, (Vec3)endNormal);
            Vec3 hNormal1 = vNormal1.m_82537_(VecHelper.bezierDerivative((Vec3)start, (Vec3)end, (Vec3)startHandle, (Vec3)endHandle, (float)t1).m_82541_()).m_82541_();
            vt1 = vt1.m_82549_(vNormal1.m_82490_((double)-1.175f));
            Vec3 a3 = vt.m_82549_(hNormal.m_82490_(r2));
            Vec3 b3 = vt1.m_82549_(hNormal1.m_82490_(r2));
            Vec3 c3 = vt1.m_82549_(hNormal1.m_82490_(r1));
            Vec3 d3 = vt.m_82549_(hNormal.m_82490_(r1));
            Vec2 a = TrackPaverV2.vec2(a3);
            Vec2 b = TrackPaverV2.vec2(b3);
            Vec2 c = TrackPaverV2.vec2(c3);
            Vec2 d = TrackPaverV2.vec2(d3);
            AABB aabb = new AABB(a3, b3).m_82367_(new AABB(c3, d3));
            double y = vt.m_82549_((Vec3)vt1).f_82480_ / 2.0;
            int scanX = Mth.m_14107_((double)aabb.f_82288_);
            while ((double)scanX <= aabb.f_82291_) {
                int scanZ = Mth.m_14107_((double)aabb.f_82290_);
                while ((double)scanZ <= aabb.f_82293_) {
                    Pair key;
                    Vec2 p = new Vec2((float)scanX + 0.5f, (float)scanZ + 0.5f);
                    if ((TrackPaverV2.isInTriangle(a, b, c, p) || TrackPaverV2.isInTriangle(a, c, d, p)) && (!yLevels.containsKey(key = Pair.of((Object)scanX, (Object)scanZ)) || (Double)yLevels.get(key) > y)) {
                        yLevels.put(key, y);
                        tLevels.put(key, (double)(t + t1) / 2.0);
                    }
                    ++scanZ;
                }
                ++scanX;
            }
        }
        for (Map.Entry entry : yLevels.entrySet()) {
            double yValue = (Double)entry.getValue();
            int floor = Mth.m_14107_((double)yValue);
            BlockPos targetPos = new BlockPos(((Integer)((Pair)entry.getKey()).getFirst()).intValue(), floor, ((Integer)((Pair)entry.getKey()).getSecond()).intValue()).m_121955_((Vec3i)bePosition);
            task.put(targetPos.m_123341_(), targetPos.m_123343_(), (float)targetPos.m_123342_() + (yValue - (double)floor >= 0.5 ? 0.5f : 0.0f));
        }
    }

    private static Vec2 vec2(Vec3 vec3) {
        return new Vec2((float)vec3.f_82479_, (float)vec3.f_82481_);
    }

    private static boolean isInTriangle(Vec2 a, Vec2 b, Vec2 c, Vec2 p) {
        float pcx = p.f_82470_ - c.f_82470_;
        float pcy = p.f_82471_ - c.f_82471_;
        float cbx = c.f_82470_ - b.f_82470_;
        float bcy = b.f_82471_ - c.f_82471_;
        float d = bcy * (a.f_82470_ - c.f_82470_) + cbx * (a.f_82471_ - c.f_82471_);
        float s = bcy * pcx + cbx * pcy;
        float t = (c.f_82471_ - a.f_82471_) * pcx + (a.f_82470_ - c.f_82470_) * pcy;
        return d < 0.0f ? s <= 0.0f && t <= 0.0f && s + t >= d : s >= 0.0f && t >= 0.0f && s + t <= d;
    }

    public static double lineToPointDiff2d(Vec3 l1, Vec3 l2, Vec3 p) {
        return Math.abs((l2.f_82479_ - l1.f_82479_) * (l1.f_82481_ - p.f_82481_) - (l1.f_82479_ - p.f_82479_) * (l2.f_82481_ - l1.f_82481_));
    }
}

