/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidBuilder<T extends FluidBuilder<T>> {
    protected Supplier<? extends FluidType> type;
    @Nullable
    protected Supplier<? extends Item> bucket;
    @Nullable
    protected Supplier<? extends LiquidBlock> block;
    private int slopeFindDistance = 4;
    private int levelDecreasePerBlock = 1;
    private float explosionResistance = 1.0f;
    private int tickRate = 5;

    public static FluidBuilder<?> create(Supplier<? extends FluidType> type) {
        FluidBuilder builder = new FluidBuilder();
        builder.type = type;
        return builder;
    }

    private T self() {
        return (T)this;
    }

    public T bucket(Supplier<? extends Item> value) {
        this.bucket = value;
        return this.self();
    }

    public T block(Supplier<? extends LiquidBlock> value) {
        this.block = value;
        return this.self();
    }

    public T slopeFindDistance(int value) {
        this.slopeFindDistance = value;
        return this.self();
    }

    public T levelDecreasePerBlock(int value) {
        this.levelDecreasePerBlock = value;
        return this.self();
    }

    public T explosionResistance(int value) {
        this.explosionResistance = value;
        return this.self();
    }

    public T tickRate(int value) {
        this.tickRate = value;
        return this.self();
    }

    public ForgeFlowingFluid.Properties build(Supplier<? extends FluidType> type, Supplier<? extends Fluid> still, Supplier<? extends Fluid> flowing) {
        return new ForgeFlowingFluid.Properties(type, still, flowing).slopeFindDistance(this.slopeFindDistance).levelDecreasePerBlock(this.levelDecreasePerBlock).explosionResistance(this.explosionResistance).tickRate(this.tickRate).block(this.block).bucket(this.bucket);
    }

    public Supplier<? extends FluidType> getType() {
        return this.type;
    }

    @Nullable
    public Supplier<? extends Item> getBucket() {
        return this.bucket;
    }

    @Nullable
    public Supplier<? extends LiquidBlock> getBlock() {
        return this.block;
    }

    public int getSlopeFindDistance() {
        return this.slopeFindDistance;
    }

    public int getLevelDecreasePerBlock() {
        return this.levelDecreasePerBlock;
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    protected FluidBuilder() {
    }
}

