/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui;

import journeymap.client.JourneymapClient;
import journeymap.client.data.WaypointsData;
import journeymap.client.log.ChatLog;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.dialog.AboutDialog;
import journeymap.client.ui.dialog.AddonOptionsManager;
import journeymap.client.ui.dialog.GridEditor;
import journeymap.client.ui.dialog.MinimapOptions;
import journeymap.client.ui.dialog.MultiplayerOptionsManager;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.client.ui.dialog.ServerOptionsManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.waypoint.WaypointEditor;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public enum UIManager {
    INSTANCE;

    private final Logger logger = Journeymap.getLogger();
    private final MiniMap miniMap;
    Minecraft minecraft = Minecraft.m_91087_();

    private UIManager() {
        MiniMap tmp;
        try {
            int preset = JourneymapClient.getInstance().getMiniMapProperties1().isActive() ? 1 : 2;
            tmp = new MiniMap(JourneymapClient.getInstance().getMiniMapProperties(preset));
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error: " + LogFormatter.toString(e));
            if (e instanceof LinkageError) {
                ChatLog.announceError(e.getMessage() + " : JourneyMap is not compatible with this build of Forge!");
            }
            tmp = new MiniMap(new MiniMapProperties(1));
        }
        this.miniMap = tmp;
    }

    public static void handleLinkageError(LinkageError error) {
        Journeymap.getLogger().error(LogFormatter.toString(error));
        try {
            ChatLog.announceError(error.getMessage() + " : JourneyMap is not compatible with this build of Forge!");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void closeAll() {
        try {
            this.closeCurrent();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error: " + LogFormatter.toString(e));
        }
        this.minecraft.m_91152_(null);
        this.minecraft.m_7440_(true);
    }

    public void closeCurrent() {
        try {
            if (this.minecraft.f_91080_ != null && this.minecraft.f_91080_ instanceof JmUI) {
                this.logger.debug("Closing " + this.minecraft.f_91080_.getClass());
                ((JmUI)this.minecraft.f_91080_).close();
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error: " + LogFormatter.toString(e));
        }
    }

    public void openInventory() {
        this.logger.debug("Opening inventory");
        this.closeAll();
        this.minecraft.m_91152_((Screen)new InventoryScreen((Player)this.minecraft.f_91074_));
    }

    public <T extends JmUI> T open(Class<T> uiClass, JmUI returnDisplay) {
        try {
            return (T)this.open((JmUI)uiClass.getConstructor(JmUI.class).newInstance(returnDisplay));
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
            return null;
        }
        catch (Throwable e) {
            try {
                return (T)this.open((JmUI)uiClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable e2) {
                this.logger.log(Level.ERROR, "1st unexpected exception creating UI: " + LogFormatter.toString(e));
                this.logger.log(Level.ERROR, "2nd unexpected exception creating UI: " + LogFormatter.toString(e2));
                this.closeCurrent();
                return null;
            }
        }
    }

    public <T extends JmUI> T open(Class<T> uiClass) {
        try {
            if (MiniMap.uiState().active) {
                MiniMap.updateUIState(false);
            }
            JmUI ui = (JmUI)uiClass.newInstance();
            return (T)this.open(ui);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
            return null;
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception creating UI: " + LogFormatter.toString(e));
            this.closeCurrent();
            return null;
        }
    }

    public <T extends Screen> T open(T ui) {
        this.closeCurrent();
        this.logger.debug("Opening UI " + ui.getClass().getSimpleName());
        try {
            if (ui instanceof Fullscreen) {
                ((Fullscreen)ui).reset();
            }
            if (ui instanceof WaypointManager) {
                ui = new WaypointManager((JmUI)((WaypointManager)ui).getReturnDisplay());
            }
            this.minecraft.m_91152_(ui);
            KeyMapping.m_90847_();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
            return null;
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception opening UI %s: %s", ui.getClass(), LogFormatter.toString(t)));
        }
        return ui;
    }

    public void toggleMinimap() {
        try {
            this.setMiniMapEnabled(!this.isMiniMapEnabled());
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception in toggleMinimap: %s", LogFormatter.toString(t)));
        }
    }

    public boolean isMiniMapEnabled() {
        try {
            return this.miniMap.getCurrentMinimapProperties().enabled.get();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception in isMiniMapEnabled: %s", LogFormatter.toString(t)));
        }
        return false;
    }

    public void setMiniMapEnabled(boolean enable) {
        try {
            this.miniMap.getCurrentMinimapProperties().enabled.set(enable);
            this.miniMap.getCurrentMinimapProperties().save();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception in setMiniMapEnabled: %s", LogFormatter.toString(t)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMiniMap(GuiGraphics graphics) {
        this.minecraft.m_91307_().m_6180_("journeymap");
        try {
            boolean doDraw = false;
            if (this.miniMap.getCurrentMinimapProperties().enabled.get().booleanValue()) {
                Screen currentScreen = this.minecraft.f_91080_;
                boolean bl = doDraw = currentScreen == null || currentScreen instanceof ChatScreen;
                if (doDraw) {
                    if (!MiniMap.uiState().active) {
                        if (MiniMap.state().getLastMapTypeChange() == 0L) {
                            this.miniMap.reset();
                        } else {
                            MiniMap.state().requireRefresh();
                        }
                    }
                    this.miniMap.drawMap(graphics);
                }
            } else if (!this.miniMap.getCurrentMinimapProperties().enabled.get().booleanValue() && MiniMap.uiState().active) {
                MiniMap.updateUIState(false);
            }
            if (doDraw && !MiniMap.uiState().active) {
                MiniMap.updateUIState(true);
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error drawing minimap: " + LogFormatter.toString(e));
        }
        finally {
            this.minecraft.m_91307_().m_7238_();
        }
    }

    public MiniMap getMiniMap() {
        return this.miniMap;
    }

    public Fullscreen openFullscreenMap() {
        if (this.minecraft.f_91080_ instanceof Fullscreen) {
            return (Fullscreen)this.minecraft.f_91080_;
        }
        if (this.minecraft.f_91080_ instanceof JmUI || this.minecraft.f_91080_ == null) {
            KeyMapping.m_90847_();
            return (Fullscreen)((Object)this.open((Screen)Fullscreen.class));
        }
        return null;
    }

    public void openFullscreenMap(Waypoint waypoint) {
        try {
            if (waypoint.isInPlayerDimension()) {
                Fullscreen map = (Fullscreen)((Object)this.open((Screen)Fullscreen.class));
                map.centerOn(waypoint);
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening map on waypoint: " + LogFormatter.toString(e));
        }
    }

    public void openOptionsManager() {
        this.open((Screen)OptionsManager.class);
    }

    public void openOptionsManager(JmUI returnDisplay, Category ... initialCategories) {
        try {
            this.open(new OptionsManager(returnDisplay, initialCategories));
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception creating MasterOptions with return class: " + LogFormatter.toString(e));
        }
    }

    public void openSplash(JmUI returnDisplay) {
        this.open(AboutDialog.class, returnDisplay);
    }

    public void openWaypointManager(Waypoint waypoint, JmUI returnDisplay) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointManager manager = new WaypointManager(waypoint, returnDisplay);
                this.open(manager);
            }
            catch (LinkageError e) {
                UIManager.handleLinkageError(e);
            }
            catch (Throwable e) {
                Journeymap.getLogger().error("Error opening waypoint manager: " + LogFormatter.toString(e));
            }
        }
    }

    public void openWaypointEditor(Waypoint waypoint, boolean isNew, JmUI returnDisplay, boolean openedWithHotkey) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointEditor editor = new WaypointEditor(waypoint, isNew, returnDisplay, openedWithHotkey);
                this.open(editor);
            }
            catch (LinkageError e) {
                UIManager.handleLinkageError(e);
            }
            catch (Throwable e) {
                Journeymap.getLogger().error("Error opening waypoint editor: " + LogFormatter.toString(e));
            }
        }
    }

    public void openWaypointEditor(Waypoint waypoint, boolean isNew, JmUI returnDisplay) {
        this.openWaypointEditor(waypoint, isNew, returnDisplay, false);
    }

    public void openGridEditor(JmUI returnDisplay) {
        try {
            GridEditor editor = new GridEditor(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening grid editor: " + LogFormatter.toString(e));
        }
    }

    public void openMinimapPosition(JmUI returnDisplay, MiniMapProperties properties) {
        try {
            MinimapOptions editor = new MinimapOptions(returnDisplay, properties);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening grid editor: " + LogFormatter.toString(e));
        }
    }

    public void openServerEditor(JmUI returnDisplay) {
        try {
            ServerOptionsManager editor = new ServerOptionsManager(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening server manager: " + LogFormatter.toString(e));
        }
    }

    public void openMultiplayerEditor(JmUI returnDisplay) {
        try {
            MultiplayerOptionsManager editor = new MultiplayerOptionsManager(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening multiplayer options manager: " + LogFormatter.toString(e));
        }
    }

    public void openAddonOptionsEditor(JmUI returnDisplay) {
        try {
            AddonOptionsManager editor = new AddonOptionsManager(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening Addon options manager: " + LogFormatter.toString(e));
        }
    }

    public ServerOptionsManager getServerEditor() {
        if (this.minecraft.f_91080_ instanceof ServerOptionsManager) {
            return (ServerOptionsManager)this.minecraft.f_91080_;
        }
        return null;
    }

    public MultiplayerOptionsManager getMultiplayerOptions() {
        if (this.minecraft.f_91080_ instanceof MultiplayerOptionsManager) {
            return (MultiplayerOptionsManager)this.minecraft.f_91080_;
        }
        return null;
    }

    public void reset() {
        try {
            Fullscreen.state().requireRefresh();
            this.miniMap.reset();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error during reset: " + LogFormatter.toString(e));
        }
    }

    public void switchMiniMapPreset() {
        try {
            int currentPreset = this.miniMap.getCurrentMinimapProperties().getId();
            this.switchMiniMapPreset(currentPreset == 1 ? 2 : 1);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error during switchMiniMapPreset: " + LogFormatter.toString(e));
        }
    }

    public void switchMiniMapPreset(int which) {
        try {
            this.miniMap.setMiniMapProperties(JourneymapClient.getInstance().getMiniMapProperties(which));
            MiniMap.state().requireRefresh();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error during switchMiniMapPreset: " + LogFormatter.toString(e));
        }
    }
}

