/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.quadTree;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.Pos2D;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.gridList.MovableGridRingList;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class QuadTree<T> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final byte treeMinDetailLevel;
    public final byte treeMaxDetailLevel;
    private final int diameterInBlocks;
    private final MovableGridRingList<QuadNode<T>> topRingList;
    private DhBlockPos2D centerBlockPos;

    public QuadTree(int diameterInBlocks, DhBlockPos2D centerBlockPos, byte treeMaxDetailLevel) {
        this.centerBlockPos = centerBlockPos;
        this.diameterInBlocks = diameterInBlocks;
        this.treeMaxDetailLevel = treeMaxDetailLevel;
        this.treeMinDetailLevel = (byte)Math.max(Math.max(1, this.treeMaxDetailLevel), MathUtil.log2(diameterInBlocks));
        int halfSizeInRootNodes = Math.floorDiv(this.diameterInBlocks, 2) / BitShiftUtil.powerOfTwo(this.treeMinDetailLevel);
        Pos2D ringListCenterPos = new Pos2D(BitShiftUtil.divideByPowerOfTwo(this.centerBlockPos.x, this.treeMinDetailLevel), BitShiftUtil.divideByPowerOfTwo(this.centerBlockPos.z, this.treeMinDetailLevel));
        this.topRingList = new MovableGridRingList(++halfSizeInRootNodes, ringListCenterPos.getX(), ringListCenterPos.getY());
    }

    @Nullable
    public final QuadNode<T> getNode(long pos) throws IndexOutOfBoundsException {
        return this.getOrSetNode(pos, false, null, true);
    }

    @Nullable
    public final T getValue(long pos) throws IndexOutOfBoundsException {
        QuadNode<T> node = this.getNode(pos);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    @Nullable
    public final T setValue(long pos, T value) throws IndexOutOfBoundsException {
        T previousValue = this.getValue(pos);
        this.getOrSetNode(pos, true, value, true);
        return previousValue;
    }

    @Nullable
    protected final QuadNode<T> getOrSetNode(long pos, boolean setNewValue, T newValue, boolean runBoundaryChecks) throws IndexOutOfBoundsException {
        int ringListPosZ;
        if (runBoundaryChecks && !this.isSectionPosInBounds(pos)) {
            int radius = this.diameterInBlocks() / 2;
            DhBlockPos2D minPos = this.getCenterBlockPos().add(new DhBlockPos2D(-radius, -radius));
            DhBlockPos2D maxPos = this.getCenterBlockPos().add(new DhBlockPos2D(radius, radius));
            throw new IndexOutOfBoundsException("QuadTree GetOrSet failed. Position out of bounds, min pos: " + minPos + ", max pos: " + maxPos + ", min detail level: " + this.treeMaxDetailLevel + ", max detail level: " + this.treeMinDetailLevel + ". Given Position: [" + DhSectionPos.toString(pos) + "] = block pos: " + DhSectionPos.convertToDetailLevel(pos, (byte)0));
        }
        long rootPos = DhSectionPos.convertToDetailLevel(pos, this.treeMinDetailLevel);
        int ringListPosX = DhSectionPos.getX(rootPos);
        QuadNode<T> topQuadNode = this.topRingList.get(ringListPosX, ringListPosZ = DhSectionPos.getZ(rootPos));
        if (topQuadNode == null) {
            if (!setNewValue) {
                return null;
            }
            topQuadNode = new QuadNode(rootPos, this.treeMaxDetailLevel);
            boolean successfullyAdded = this.topRingList.set(ringListPosX, ringListPosZ, topQuadNode);
            if (!successfullyAdded) {
                LodUtil.assertNotReach("Failed to add top quadTree node at position: " + rootPos);
            }
        }
        if (!DhSectionPos.contains(topQuadNode.sectionPos, pos)) {
            LodUtil.assertNotReach("failed to get a root node that contains the input position: " + pos + " root node pos: " + topQuadNode.sectionPos);
        }
        QuadNode<T> returnNode = topQuadNode.getNode(pos);
        if (setNewValue) {
            topQuadNode.setValue(pos, newValue);
        }
        return returnNode;
    }

    public boolean isSectionPosInBounds(long testPos) {
        boolean detailLevelWithinBounds;
        boolean bl = detailLevelWithinBounds = this.treeMaxDetailLevel <= DhSectionPos.getDetailLevel(testPos) && DhSectionPos.getDetailLevel(testPos) <= this.treeMinDetailLevel;
        if (!detailLevelWithinBounds) {
            return false;
        }
        DhBlockPos2D treeBlockCorner = this.centerBlockPos.add(new DhBlockPos2D(-this.diameterInBlocks / 2, -this.diameterInBlocks / 2));
        DhLodPos treeCornerPos = new DhLodPos(0, treeBlockCorner.x, treeBlockCorner.z);
        long inputSectionCorner = DhSectionPos.convertToDetailLevel(testPos, (byte)0);
        DhLodPos inputCornerPos = new DhLodPos(0, DhSectionPos.getX(inputSectionCorner), DhSectionPos.getZ(inputSectionCorner));
        int inputBlockWidth = BitShiftUtil.powerOfTwo(DhSectionPos.getDetailLevel(testPos));
        return QuadTree.DoSquaresOverlap(treeCornerPos, this.diameterInBlocks, inputCornerPos, inputBlockWidth);
    }

    private static boolean DoSquaresOverlap(DhLodPos square1Min, int square1Width, DhLodPos square2Min, int square2Width) {
        float rect1MinX = square1Min.x;
        float rect1MaxX = square1Min.x + square1Width;
        float rect1MinZ = square1Min.z;
        float rect1MaxZ = square1Min.z + square1Width;
        float rect2MinX = square2Min.x;
        float rect2MaxX = square2Min.x + square2Width;
        float rect2MinZ = square2Min.z;
        float rect2MaxZ = square2Min.z + square2Width;
        return rect1MinX < rect2MaxX && rect1MaxX > rect2MinX && rect1MinZ < rect2MaxZ && rect1MaxZ > rect2MinZ;
    }

    public int getNonNullChildCountAtPos(long pos) {
        return this.getChildCountAtPos(pos, false);
    }

    public int getChildCountAtPos(long pos, boolean includeNullValues) {
        int childCount = 0;
        for (int i = 0; i < 4; ++i) {
            long childPos = DhSectionPos.getChildByIndex(pos, i);
            if (!this.isSectionPosInBounds(childPos)) continue;
            T value = this.getValue(childPos);
            if (!includeNullValues && value == null) continue;
            ++childCount;
        }
        return childCount;
    }

    public LongIterator rootNodePosIterator() {
        return new QuadTreeRootPosIterator(true);
    }

    public Iterator<QuadNode<T>> nodeIterator() {
        return new QuadTreeNodeIterator(false);
    }

    public Iterator<QuadNode<T>> leafNodeIterator() {
        return new QuadTreeNodeIterator(true);
    }

    public void setCenterBlockPos(DhBlockPos2D newCenterPos) {
        this.setCenterBlockPos(newCenterPos, null);
    }

    public void setCenterBlockPos(DhBlockPos2D newCenterPos, Consumer<? super T> removedItemConsumer) {
        this.centerBlockPos = newCenterPos;
        Pos2D expectedCenterPos = new Pos2D(BitShiftUtil.divideByPowerOfTwo(this.centerBlockPos.x, this.treeMinDetailLevel), BitShiftUtil.divideByPowerOfTwo(this.centerBlockPos.z, this.treeMinDetailLevel));
        if (this.topRingList.getCenter().equals(expectedCenterPos)) {
            return;
        }
        this.topRingList.moveTo(expectedCenterPos.getX(), expectedCenterPos.getY(), quadNode -> {
            if (quadNode != null && removedItemConsumer != null) {
                quadNode.deleteAllChildren(removedItemConsumer);
                removedItemConsumer.accept((Object)quadNode.value);
            }
        });
    }

    public final DhBlockPos2D getCenterBlockPos() {
        return this.centerBlockPos;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public int count() {
        int count = 0;
        for (QuadNode quadNode : this.topRingList) {
            if (quadNode == null) continue;
            Iterator nodeIterator = quadNode.getNodeIterator();
            while (nodeIterator.hasNext()) {
                if (nodeIterator.next().value == null) continue;
                ++count;
            }
        }
        return count;
    }

    public int leafNodeCount() {
        int count = 0;
        for (QuadNode quadNode : this.topRingList) {
            if (quadNode == null) continue;
            Iterator leafNodeIterator = quadNode.getLeafNodeIterator();
            while (leafNodeIterator.hasNext()) {
                leafNodeIterator.next();
                ++count;
            }
        }
        return count;
    }

    public int ringListWidth() {
        return 3;
    }

    public int ringListHalfWidth() {
        return 1;
    }

    public int diameterInBlocks() {
        return this.diameterInBlocks;
    }

    public String toString() {
        return "center block: " + this.centerBlockPos + ", block width: " + this.diameterInBlocks + ", detail level range: [" + this.treeMaxDetailLevel + "-" + this.treeMinDetailLevel + "], leaf #: " + this.leafNodeCount();
    }

    private class QuadTreeRootPosIterator
    implements LongIterator {
        private final LongArrayFIFOQueue iteratorPosQueue = new LongArrayFIFOQueue();

        public QuadTreeRootPosIterator(boolean includeNullNodes) {
            QuadTree.this.topRingList.forEachPosOrdered((node, pos2D) -> {
                long rootPos;
                if ((node != null || includeNullNodes) && QuadTree.this.isSectionPosInBounds(rootPos = DhSectionPos.encode(QuadTree.this.treeMinDetailLevel, pos2D.getX(), pos2D.getY()))) {
                    this.iteratorPosQueue.enqueue(rootPos);
                }
            });
        }

        public boolean hasNext() {
            return this.iteratorPosQueue.size() != 0;
        }

        public long nextLong() {
            if (this.iteratorPosQueue.size() == 0) {
                throw new NoSuchElementException();
            }
            long sectionPos = this.iteratorPosQueue.dequeueLong();
            return sectionPos;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public void forEachRemaining(LongConsumer action) {
            super.forEachRemaining(action);
        }
    }

    private class QuadTreeNodeIterator
    implements Iterator<QuadNode<T>> {
        private final QuadTreeRootPosIterator rootNodeIterator;
        private Iterator<QuadNode<T>> currentNodeIterator;
        private QuadNode<T> lastNode = null;
        private final boolean onlyReturnLeaves;

        public QuadTreeNodeIterator(boolean onlyReturnLeaves) {
            this.rootNodeIterator = new QuadTreeRootPosIterator(false);
            this.onlyReturnLeaves = onlyReturnLeaves;
        }

        @Override
        public boolean hasNext() {
            if (!this.rootNodeIterator.hasNext() && this.currentNodeIterator != null && !this.currentNodeIterator.hasNext()) {
                return false;
            }
            if (this.currentNodeIterator == null || !this.currentNodeIterator.hasNext()) {
                this.currentNodeIterator = this.getNextChildNodeIterator();
            }
            return this.currentNodeIterator != null && this.currentNodeIterator.hasNext();
        }

        @Override
        public QuadNode<T> next() {
            if (this.currentNodeIterator == null || !this.currentNodeIterator.hasNext()) {
                this.currentNodeIterator = this.getNextChildNodeIterator();
            }
            this.lastNode = this.currentNodeIterator.next();
            return this.lastNode;
        }

        private Iterator<QuadNode<T>> getNextChildNodeIterator() {
            Iterator nodeIterator = null;
            while ((nodeIterator == null || !nodeIterator.hasNext()) && this.rootNodeIterator.hasNext()) {
                long sectionPos = this.rootNodeIterator.nextLong();
                QuadNode rootNode = QuadTree.this.getNode(sectionPos);
                if (rootNode == null) continue;
                nodeIterator = this.onlyReturnLeaves ? rootNode.getLeafNodeIterator() : rootNode.getNodeIterator();
            }
            return nodeIterator;
        }

        @Override
        public void remove() {
            if (this.lastNode == null) {
                throw new NoSuchElementException("No last node found.");
            }
            QuadNode<Object> node = QuadTree.this.getOrSetNode(this.lastNode.sectionPos, true, null, false);
            if (node != null) {
                node.deleteAllChildren();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super QuadNode<T>> action) {
            Iterator.super.forEachRemaining(action);
        }
    }
}

