/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.overlay;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.ActionDescriptions;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonIcons;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.overlay.IOverlay;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.controllable.platform.ClientServices;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ActionHintOverlay
implements IOverlay {
    private final Map<Integer, Action> actions = new HashMap<Integer, Action>();

    @Override
    public boolean isVisible() {
        return !Minecraft.m_91087_().f_91066_.f_92062_ && Controllable.getController() != null && Controllable.getInput().getLastUse() > 0;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int[] positions = new int[2];
        for (int button : this.actions.keySet()) {
            Action.Side side;
            Action action = this.actions.get(button);
            Action.Side side2 = side = ClientHelper.isSubtitleShowing() ? Action.Side.LEFT : action.getSide();
            if (ClientHelper.isChatVisible() && side == Action.Side.LEFT && positions[0] >= 2) continue;
            int position = positions[side.ordinal()];
            this.drawHint(graphics, action, side, button, position);
            positions[side.ordinal()] = position + 1;
        }
    }

    private void drawHint(GuiGraphics graphics, Action action, Action.Side side, int button, int position) {
        Minecraft mc = Minecraft.m_91087_();
        int size = 13;
        int texU = button * size;
        int texV = ((ButtonIcons)Config.CLIENT.client.options.controllerIcons.get()).ordinal() * size;
        int x = side == Action.Side.LEFT ? 5 : mc.m_91268_().m_85445_() - 5 - size;
        int y = mc.m_91268_().m_85446_() + position * -15 - size - 5;
        graphics.m_280163_(ButtonIcons.TEXTURE, x, y, (float)texU, (float)texV, size, size, 299, ButtonIcons.TEXTURE_HEIGHT);
        int textWidth = mc.f_91062_.m_92852_((FormattedText)action.getDescription());
        int labelX = side == Action.Side.LEFT ? x + 18 : x - 5 - textWidth;
        this.drawHintBackground(graphics, labelX, y, textWidth, 13);
        this.drawHintLabel(graphics, action.getDescription(), labelX, y + 3);
    }

    private void drawHintBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        if (((Boolean)Config.CLIENT.client.options.drawHintBackground.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            int backgroundColor = mc.f_91066_.m_92170_(0.5f);
            ScreenHelper.drawRoundedBox(graphics, x, y, width, height, backgroundColor);
        }
    }

    private void drawHintLabel(GuiGraphics graphics, Component label, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280430_(mc.f_91062_, label, x, y, -1);
        graphics.m_280168_().m_85849_();
    }

    @Override
    public void tick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92062_) {
            return;
        }
        this.actions.clear();
        ActionVisibility visibility = (ActionVisibility)Config.CLIENT.client.options.showButtonHints.get();
        if (visibility == ActionVisibility.NONE) {
            return;
        }
        boolean verbose = visibility == ActionVisibility.ALL;
        LinkedHashMap<ButtonBinding, Action> actionMap = new LinkedHashMap<ButtonBinding, Action>();
        Screen screen = mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                slot = ClientServices.CLIENT.getSlotUnderMouse(containerScreen);
                if (slot != null && slot.m_6657_()) {
                    actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(ActionDescriptions.PICKUP_STACK, Action.Side.LEFT));
                    actionMap.put(ButtonBindings.SPLIT_STACK, new Action(ActionDescriptions.SPLIT_STACK, Action.Side.LEFT));
                    actionMap.put(ButtonBindings.QUICK_MOVE, new Action(ActionDescriptions.QUICK_MOVE, Action.Side.LEFT));
                }
            } else {
                actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(ActionDescriptions.PLACE_STACK, Action.Side.LEFT));
                actionMap.put(ButtonBindings.SPLIT_STACK, new Action(ActionDescriptions.PLACE_ITEM, Action.Side.LEFT));
                slot = ClientServices.CLIENT.getSlotUnderMouse(containerScreen);
                if (slot != null && slot.m_6657_()) {
                    actionMap.put(ButtonBindings.QUICK_MOVE, new Action(ActionDescriptions.QUICK_MOVE, Action.Side.LEFT));
                }
            }
            actionMap.put(ButtonBindings.CLOSE_INVENTORY, new Action(ActionDescriptions.CLOSE_INVENTORY, Action.Side.RIGHT));
        } else if (mc.f_91080_ == null) {
            if (RadialMenuHandler.instance().isVisible()) {
                if (RadialMenuHandler.instance().getSelected() != null) {
                    actionMap.put(ButtonBindings.RADIAL_MENU, new Action(ActionDescriptions.PERFORM_ACTION, Action.Side.RIGHT));
                } else {
                    actionMap.put(ButtonBindings.RADIAL_MENU, new Action(ActionDescriptions.CLOSE_MENU, Action.Side.RIGHT));
                }
            } else {
                ItemStack currentItem;
                ItemStack offHandStack;
                boolean blockHit = mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK;
                boolean canOpenBlock = false;
                if (blockHit) {
                    BlockHitResult blockHitResult = (BlockHitResult)mc.f_91077_;
                    boolean bl = canOpenBlock = mc.f_91073_ != null && mc.f_91073_.m_8055_(blockHitResult.m_82425_()).m_60734_() instanceof BaseEntityBlock;
                }
                if (!mc.f_91074_.m_6117_()) {
                    if (blockHit) {
                        actionMap.put(ButtonBindings.ATTACK, new Action(ActionDescriptions.BREAK, Action.Side.RIGHT));
                    } else {
                        actionMap.put(ButtonBindings.ATTACK, new Action(ActionDescriptions.ATTACK, Action.Side.RIGHT));
                    }
                }
                if ((offHandStack = mc.f_91074_.m_21206_()).m_41780_() != UseAnim.NONE) {
                    switch (offHandStack.m_41780_()) {
                        case EAT: {
                            if (!mc.f_91074_.m_36324_().m_38721_()) break;
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.EAT, Action.Side.RIGHT));
                            break;
                        }
                        case DRINK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.DRINK, Action.Side.RIGHT));
                            break;
                        }
                        case BLOCK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.BLOCK, Action.Side.RIGHT));
                            break;
                        }
                        case BOW: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PULL_BOW, Action.Side.RIGHT));
                        }
                    }
                }
                if ((currentItem = mc.f_91074_.m_21205_()).m_41780_() != UseAnim.NONE) {
                    switch (currentItem.m_41780_()) {
                        case EAT: {
                            FoodProperties properties = currentItem.m_41720_().m_41473_();
                            if (properties == null || !mc.f_91074_.m_36391_(properties.m_38747_())) break;
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.EAT, Action.Side.RIGHT));
                            break;
                        }
                        case DRINK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.DRINK, Action.Side.RIGHT));
                            break;
                        }
                        case BLOCK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.BLOCK, Action.Side.RIGHT));
                            break;
                        }
                        case BOW: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PULL_BOW, Action.Side.RIGHT));
                        }
                    }
                } else if (currentItem.m_41720_() instanceof BlockItem) {
                    if (blockHit) {
                        actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PLACE_BLOCK, Action.Side.RIGHT));
                    }
                } else if (!currentItem.m_41619_() && !mc.f_91074_.m_6117_()) {
                    actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.USE_ITEM, Action.Side.RIGHT));
                }
                if (!mc.f_91074_.m_6047_() && blockHit && canOpenBlock && !mc.f_91074_.m_6117_()) {
                    actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.INTERACT, Action.Side.RIGHT));
                }
                if (verbose) {
                    actionMap.put(ButtonBindings.JUMP, new Action(ActionDescriptions.JUMP, Action.Side.LEFT));
                }
                actionMap.put(ButtonBindings.OPEN_INVENTORY, new Action(ActionDescriptions.OPEN_INVENTORY, Action.Side.LEFT));
                if (!(!verbose || mc.f_91074_.m_21206_().m_41619_() && mc.f_91074_.f_36096_.m_142621_().m_41619_())) {
                    actionMap.put(ButtonBindings.SWAP_HANDS, new Action(ActionDescriptions.SWAP_HANDS, Action.Side.LEFT));
                }
                if (mc.f_91074_.m_20159_()) {
                    actionMap.put(ButtonBindings.SNEAK, new Action(ActionDescriptions.DISMOUNT, Action.Side.RIGHT));
                } else if (verbose) {
                    actionMap.put(ButtonBindings.SNEAK, new Action(ActionDescriptions.SNEAK, Action.Side.RIGHT));
                }
                if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                    actionMap.put(ButtonBindings.DROP_ITEM, new Action(ActionDescriptions.DROP_ITEM, Action.Side.LEFT));
                }
            }
        }
        actionMap.forEach((binding, action) -> this.actions.put(binding.getButton(), (Action)action));
    }
}

