/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonIcons;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.Icons;
import com.mrcrayfish.controllable.client.SneakMode;
import com.mrcrayfish.controllable.client.SprintMode;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.components.ButtonBindingList;
import com.mrcrayfish.controllable.client.gui.components.ControllerList;
import com.mrcrayfish.controllable.client.gui.components.TabOptionEnumItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionSliderItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionTitleItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionToggleItem;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.widget.TabListWidget;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SettingsScreen
extends Screen {
    @Nullable
    private final Screen parent;
    private final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
    }, x$0 -> this.m_169411_((GuiEventListener)x$0));
    private ScreenRectangle tabArea;
    private TabNavigationBar navigationBar;
    private Button doneButton;
    private ButtonBinding selectedBinding;
    private int remainingTime;
    private int initialTab = 0;

    public SettingsScreen(@Nullable Screen parent) {
        super((Component)Component.m_237115_((String)"controllable.settings"));
        this.parent = parent;
    }

    public SettingsScreen(@Nullable Screen parent, int initialTab) {
        super((Component)Component.m_237115_((String)"controllable.settings"));
        this.parent = parent;
        this.initialTab = initialTab;
    }

    @Nullable
    public Screen getParent() {
        return this.parent;
    }

    protected void m_7856_() {
        this.navigationBar = TabNavigationBar.m_267630_((TabManager)this.tabManager, (int)this.f_96543_).m_267824_(new Tab[]{new ControllerTab(), new SettingsTab(), new BindingsTab()}).m_267625_();
        this.m_142416_((GuiEventListener)this.navigationBar);
        this.navigationBar.m_276089_(this.initialTab, false);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.f_96541_.m_91152_(this.parent)).m_252794_((this.f_96543_ - 200) / 2, this.f_96544_ - 25).m_252780_(200).m_253136_());
        this.m_267719_();
    }

    protected void m_267719_() {
        if (this.navigationBar != null) {
            this.navigationBar.m_267604_(this.f_96543_);
            this.navigationBar.m_267766_();
            ScreenRectangle navBarArea = this.navigationBar.m_264198_();
            this.tabArea = new ScreenRectangle(0, navBarArea.f_263800_() - 1, this.f_96543_, this.f_96544_ - navBarArea.f_263800_() - 30);
            this.tabManager.m_267817_(this.tabArea);
        }
        if (this.doneButton != null) {
            this.doneButton.m_252865_((this.f_96543_ - 200) / 2);
            this.doneButton.m_253211_(this.f_96544_ - 25);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (super.m_6050_(mouseX, mouseY, scroll)) {
            return true;
        }
        Tab currentTab = this.tabManager.m_267695_();
        if (currentTab == null) {
            return false;
        }
        ArrayList widgets = new ArrayList();
        currentTab.m_267609_(widgets::add);
        return widgets.stream().filter(widget -> widget.m_5953_(mouseX, mouseY) && widget.m_6050_(mouseX, mouseY, scroll)).count() > 0L;
    }

    public void m_86600_() {
        this.tabManager.m_267621_();
        if (this.isWaitingForButtonInput()) {
            --this.remainingTime;
            if (this.remainingTime <= 0) {
                this.selectedBinding = null;
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280039_(graphics);
        boolean waitingForInput = this.isWaitingForButtonInput();
        super.m_88315_(graphics, !waitingForInput ? mouseX : -1, !waitingForInput ? mouseY : -1, partialTick);
        if (waitingForInput) {
            PoseStack stack = graphics.m_280168_();
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.0f, 100.0f);
            graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -535818224, -267382768);
            ScreenHelper.drawRoundedBox(graphics, (int)((double)this.f_96543_ * 0.125), this.f_96544_ / 4, (int)((double)this.f_96543_ * 0.75), this.f_96544_ / 2, -1728053248);
            MutableComponent pressButtonLabel = Component.m_237115_((String)"controllable.gui.waiting_for_input").m_130940_(ChatFormatting.YELLOW);
            graphics.m_280653_(this.f_96547_, (Component)pressButtonLabel, this.f_96543_ / 2, this.f_96544_ / 2 - 10, -1);
            MutableComponent time = Component.m_237113_((String)Integer.toString((int)Math.ceil((double)this.remainingTime / 20.0)));
            MutableComponent inputCancelLabel = Component.m_237110_((String)"controllable.gui.input_cancel", (Object[])new Object[]{time});
            graphics.m_280653_(this.f_96547_, (Component)inputCancelLabel, this.f_96543_ / 2, this.f_96544_ / 2 + 3, -1);
            stack.m_85849_();
        }
    }

    public boolean m_7933_(int key, int action, int modifiers) {
        if (key == 256 && this.selectedBinding != null) {
            this.selectedBinding = null;
            return true;
        }
        if (this.navigationBar.m_269419_(key)) {
            return true;
        }
        return super.m_7933_(key, action, modifiers);
    }

    public void setSelectedBinding(ButtonBinding binding) {
        if (this.tabManager.m_267695_() instanceof BindingsTab) {
            this.selectedBinding = binding;
            this.remainingTime = 100;
        }
    }

    public boolean isWaitingForButtonInput() {
        if (this.selectedBinding != null && !(this.tabManager.m_267695_() instanceof BindingsTab)) {
            this.selectedBinding = null;
        }
        return this.selectedBinding != null;
    }

    public boolean processButton(int index) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setButton(index);
            this.selectedBinding = null;
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
            return true;
        }
        return false;
    }

    public class ControllerTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.m_237119_().m_7220_((Component)ClientHelper.getIconComponent(Icons.CONTROLLER)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"controllable.settings.tab.controller.title"));
        private final ControllerList list;

        public ControllerTab() {
            super(TITLE);
            GridLayout.RowHelper rootHelper = this.f_267367_.m_267750_(8).m_264606_(1);
            this.list = new ControllerList(SettingsScreen.this.f_96541_, 24);
            rootHelper.m_264139_((LayoutElement)new TabListWidget(() -> SettingsScreen.this.tabArea, this.list));
        }

        public void m_267681_() {
            this.list.tick();
        }
    }

    public class SettingsTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.m_237119_().m_7220_((Component)ClientHelper.getIconComponent(Icons.SETTINGS)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"controllable.settings.tab.settings.title"));

        public SettingsTab() {
            super(TITLE);
            Minecraft mc = Objects.requireNonNull(SettingsScreen.this.f_96541_);
            GridLayout.RowHelper rootHelper = this.f_267367_.m_267750_(8).m_264606_(1);
            TabSelectionList<TabSelectionList.BaseItem> optionsList = new TabSelectionList<TabSelectionList.BaseItem>(SettingsScreen.this.f_96541_, 24);
            MutableComponent updateMappings = ClientHelper.join(Icons.WORLD, (Component)Component.m_237115_((String)"controllable.gui.update_mappings"));
            MutableComponent restoreDefaults = ClientHelper.join(Icons.RESET, (Component)Component.m_237115_((String)"controllable.gui.restore_defaults"));
            optionsList.addEntry(new ButtonBindingList.TwoWidgetItem((AbstractWidget)Button.m_253074_((Component)updateMappings, btn -> {
                ConfirmationScreen updateConfirmation = new ConfirmationScreen(SettingsScreen.this, (Component)Component.m_237110_((String)"controllable.gui.update_mapping_message", (Object[])new Object[]{Component.m_237113_((String)"https://raw.githubusercontent.com/gabomdq/SDL_GameControllerDB/master/gamecontrollerdb.txt").m_130940_(ChatFormatting.YELLOW)}), result -> {
                    if (result.booleanValue()) {
                        Controllable.getManager().downloadMappings(SettingsScreen.this);
                        return false;
                    }
                    return true;
                });
                updateConfirmation.setPositiveText((Component)ClientHelper.join(Icons.DOWNLOAD, (Component)Component.m_237115_((String)"controllable.gui.download")));
                updateConfirmation.setNegativeText(CommonComponents.f_130656_);
                updateConfirmation.setIcon(ConfirmationScreen.Icon.INFO);
                mc.m_91152_((Screen)updateConfirmation);
            }).m_253136_(), (AbstractWidget)Button.m_253074_((Component)restoreDefaults, btn -> mc.m_91152_((Screen)new ConfirmationScreen(SettingsScreen.this, (Component)Component.m_237115_((String)"controllable.gui.restore_defaults"), result -> {
                FrameworkConfigManager.FrameworkConfigImpl config;
                if (result.booleanValue() && (config = FrameworkConfigManager.getInstance().getConfig(Config.CLIENT_CONFIG_ID)) != null) {
                    config.getAllProperties().forEach(AbstractProperty::restoreDefault);
                    mc.m_91152_((Screen)new SettingsScreen(SettingsScreen.this.parent, 1));
                    return false;
                }
                return true;
            }))).m_253136_()));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.m_237115_((String)"controllable.gui.title.gameplay").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionEnumItem<SneakMode>((Component)Component.m_237115_((String)"controllable.gui.sneak_mode"), (Component)Component.m_237115_((String)"controllable.gui.sneak_mode.desc"), () -> (Boolean)mc.f_91066_.m_231831_().m_231551_() != false ? SneakMode.TOGGLE : SneakMode.HOLD, sneakMode -> {
                mc.f_91066_.m_231831_().m_231514_((Object)(sneakMode == SneakMode.TOGGLE ? 1 : 0));
                mc.f_91066_.m_92169_();
            }));
            optionsList.addEntry(new TabOptionEnumItem<SprintMode>((Component)Component.m_237115_((String)"controllable.gui.sprint_mode"), (Component)Component.m_237115_((String)"controllable.gui.sprint_mode.desc"), () -> (Boolean)mc.f_91066_.m_231832_().m_231551_() != false ? SprintMode.TOGGLE : SprintMode.ONCE, sprintMode -> {
                mc.f_91066_.m_231832_().m_231514_((Object)(sprintMode == SprintMode.TOGGLE ? 1 : 0));
                mc.f_91066_.m_92169_();
            }));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.quickCraft));
            optionsList.addEntry(new TabOptionEnumItem<Thumbstick>(Config.CLIENT.client.options.radialThumbstick));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.spyglassSensitivity, 0.05));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.m_237115_((String)"controllable.gui.title.camera").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.rotationSpeed, 1.0));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.pitchSensitivity, 0.01));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.yawSensitivity, 0.01));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.invertLook));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.invertRotation));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.m_237115_((String)"controllable.gui.title.display").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionEnumItem<ButtonIcons>(Config.CLIENT.client.options.controllerIcons));
            optionsList.addEntry(new TabOptionEnumItem<ActionVisibility>(Config.CLIENT.client.options.showButtonHints));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.drawHintBackground));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.consoleHotbar));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.renderMiniPlayer));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.m_237115_((String)"controllable.gui.title.controller").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.autoSelect));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.virtualCursor));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.thumbstickDeadZone, 0.01));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.triggerDeadZone, 0.01));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.cursorSpeed, 1.0));
            optionsList.addEntry(new TabOptionEnumItem<Thumbstick>(Config.CLIENT.client.options.cursorThumbstick));
            optionsList.addEntry(new TabOptionEnumItem<CursorType>(Config.CLIENT.client.options.cursorType));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.listScrollSpeed, 1.0));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.hoverModifier, 0.05));
            if (!Minecraft.f_91002_) {
                optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.rumble));
            }
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.m_237115_((String)"controllable.gui.title.other").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.uiSounds));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.fpsPollingFix));
            rootHelper.m_264139_((LayoutElement)new TabListWidget(() -> SettingsScreen.this.tabArea, optionsList));
        }
    }

    public class BindingsTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.m_237119_().m_7220_((Component)ClientHelper.getIconComponent(Icons.BINDINGS)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"controllable.settings.tab.bindings.title"));

        public BindingsTab() {
            super(TITLE);
            GridLayout.RowHelper rootHelper = this.f_267367_.m_267750_(8).m_264606_(1);
            rootHelper.m_264139_((LayoutElement)new TabListWidget(() -> SettingsScreen.this.tabArea, new ButtonBindingList(SettingsScreen.this, SettingsScreen.this.f_96541_, 22)));
        }
    }
}

