/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.widget.ColorButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class RadialItemList
extends AbstractSelectionList<ButtonBindingEntry> {
    private final List<ButtonBindingData> bindings;
    private ButtonBinding selectedBinding;

    public RadialItemList(Minecraft mc, int width, int height, int top, int bottom, List<ButtonBindingData> bindings) {
        super(mc, width, height, top, bottom, 36);
        this.bindings = bindings;
        this.updateEntries();
    }

    private void updateEntries() {
        this.m_93516_();
        this.bindings.forEach(binding -> this.m_7085_((AbstractSelectionList.Entry)new ButtonBindingEntry((ButtonBindingData)binding)));
        ButtonBindingEntry selected = this.m_6702_().stream().filter(data -> data.getData().getBinding() == this.selectedBinding).findFirst().orElse(null);
        if (selected == null && this.m_6702_().size() > 0) {
            selected = (ButtonBindingEntry)((Object)this.m_6702_().get(0));
            this.selectedBinding = selected.getData().getBinding();
        }
        this.m_6987_((AbstractSelectionList.Entry)selected);
    }

    public int m_5759_() {
        return 260;
    }

    public int m_5747_() {
        return super.m_5747_();
    }

    public void m_142291_(NarrationElementOutput output) {
    }

    class ButtonBindingEntry
    extends ContainerObjectSelectionList.Entry<ButtonBindingEntry> {
        private final ButtonBindingData data;
        private final Component description;
        private final Button moveUpButton;
        private final Button moveDownButton;
        private Component label;
        private ColorButton colorButton;

        public ButtonBindingEntry(ButtonBindingData data) {
            this.data = data;
            this.description = Component.m_237115_((String)data.getBinding().getCategory());
            this.moveUpButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 35, 10, 10, button -> this.shiftBinding(false));
            this.moveDownButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 35, 10, 10, button -> this.shiftBinding(true));
            this.label = Component.m_237115_((String)data.getBinding().getLabelKey()).m_130940_(data.getColor());
            this.colorButton = new ColorButton(0, 0, button -> {
                data.setColor(this.colorButton.getColor());
                this.label = this.label.m_6881_().m_130940_(this.colorButton.getColor());
            });
            this.colorButton.setColor(data.getColor());
            this.updateButtons();
        }

        public ButtonBindingData getData() {
            return this.data;
        }

        private void shiftBinding(boolean down) {
            List<ButtonBindingData> bindings = RadialItemList.this.bindings;
            int index = bindings.indexOf(this.data);
            bindings.remove(this.data);
            index = Mth.m_14045_((int)(index + (down ? 1 : -1)), (int)0, (int)bindings.size());
            bindings.add(index, this.data);
            this.updateButtons();
            RadialItemList.this.updateEntries();
        }

        private void updateButtons() {
            int index = RadialItemList.this.bindings.indexOf(this.data);
            this.moveUpButton.f_93623_ = index > 0;
            this.moveDownButton.f_93623_ = index < RadialItemList.this.bindings.size() - 1;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)((Object)this.colorButton), (Object)this.moveUpButton, (Object)this.moveDownButton);
        }

        public void m_6311_(GuiGraphics graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = ((RadialItemList)RadialItemList.this).f_93386_.f_91062_;
            graphics.m_280430_(font, this.label, left + 5, top + 5, 0xFFFFFF);
            graphics.m_280430_(font, this.description, left + 5, top + 18, 0xFFFFFF);
            this.colorButton.f_93624_ = RadialItemList.this.m_93511_() == this;
            this.colorButton.m_252865_(left + RadialItemList.this.m_5759_() - 78);
            this.colorButton.m_253211_(top + 6);
            this.colorButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
            this.moveUpButton.f_93624_ = RadialItemList.this.m_93511_() == this;
            this.moveUpButton.m_252865_(left + RadialItemList.this.m_5759_() - 34);
            this.moveUpButton.m_253211_(top + 6);
            this.moveUpButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
            this.moveDownButton.f_93624_ = RadialItemList.this.m_93511_() == this;
            this.moveDownButton.m_252865_(left + RadialItemList.this.m_5759_() - 56);
            this.moveDownButton.m_253211_(top + 6);
            this.moveDownButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            RadialItemList.this.m_6987_((AbstractSelectionList.Entry)this);
            RadialItemList.this.selectedBinding = this.data.getBinding();
            return super.m_6375_(mouseX, mouseY, button);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, ButtonBindingEntry.this.label);
                }
            });
        }
    }
}

