/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ConfirmationScreen
extends Screen
implements IBackgroundTexture {
    private static final int FADE_LENGTH = 4;
    private static final int BRIGHTNESS = 32;
    private static final int MESSAGE_PADDING = 10;
    private final Screen parent;
    private final Component message;
    private final Icon icon;
    private final Function<Boolean, Boolean> handler;
    private Component positiveText = CommonComponents.f_130657_;
    private Component negativeText = CommonComponents.f_130658_;
    private ResourceLocation background = Screen.f_279548_;
    private int startY;
    private int endY;

    public ConfirmationScreen(Screen parent, Component message, Icon icon, Function<Boolean, Boolean> handler) {
        super(message);
        this.parent = parent;
        this.message = message;
        this.icon = icon;
        this.handler = handler;
    }

    protected void m_7856_() {
        List lines = this.f_96547_.m_92923_((FormattedText)this.message, 300);
        int n = this.f_96544_ / 2 - 10;
        int n2 = lines.size();
        Objects.requireNonNull(this.f_96547_);
        this.startY = n - n2 * (9 + 2) / 2 - 10 - 1;
        int n3 = lines.size();
        Objects.requireNonNull(this.f_96547_);
        this.endY = this.startY + n3 * (9 + 2) + 20;
        int offset = this.negativeText != null ? 105 : 50;
        this.m_142416_((GuiEventListener)ScreenUtil.button(this.f_96543_ / 2 - offset, this.endY + 10, 100, 20, this.positiveText, button -> {
            if (this.handler.apply(true).booleanValue()) {
                this.f_96541_.m_91152_(this.parent);
            }
        }));
        if (this.negativeText != null) {
            this.m_142416_((GuiEventListener)ScreenUtil.button(this.f_96543_ / 2 + 5, this.endY + 10, 100, 20, this.negativeText, button -> {
                if (this.handler.apply(false).booleanValue()) {
                    this.f_96541_.m_91152_(this.parent);
                }
            }));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        List lines = this.f_96547_.m_92923_((FormattedText)this.message, 300);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280411_(IconButton.ICONS, this.f_96543_ / 2 - 10, this.startY - 30, 20, 20, (float)this.icon.u(), (float)this.icon.v(), 10, 10, 64, 64);
        ConfirmationScreen.drawListBackground(0.0, this.f_96543_, this.startY, this.endY);
        for (int i = 0; i < lines.size(); ++i) {
            int lineWidth = this.f_96547_.m_92724_((FormattedCharSequence)lines.get(i));
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
            int n = this.f_96543_ / 2 - lineWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280648_(this.f_96547_, formattedCharSequence, n, this.startY + 10 + i * (9 + 2) + 1, 0xFFFFFF);
        }
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public void setPositiveText(Component positiveText) {
        this.positiveText = positiveText;
    }

    public void setNegativeText(@Nullable Component negativeText) {
        this.negativeText = negativeText;
    }

    public ConfirmationScreen setBackground(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public static void drawListBackground(double startX, double endX, double startY, double endY) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_5483_(startX, endY, 0.0).m_7421_((float)startX / 32.0f, (float)endY / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        buffer.m_5483_(endX, endY, 0.0).m_7421_((float)endX / 32.0f, (float)endY / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        buffer.m_5483_(endX, startY, 0.0).m_7421_((float)endX / 32.0f, (float)startY / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        buffer.m_5483_(startX, startY, 0.0).m_7421_((float)startX / 32.0f, (float)startY / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(startX, startY + 4.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_5483_(endX, startY + 4.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_5483_(endX, startY, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_5483_(startX, startY, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_5483_(startX, endY, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_5483_(endX, endY, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_5483_(endX, endY - 4.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_5483_(startX, endY - 4.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public static enum Icon {
        INFO(11, 44),
        WARNING(0, 11),
        ERROR(11, 11);

        private final int u;
        private final int v;

        private Icon(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int u() {
            return this.u;
        }

        public int v() {
            return this.v;
        }
    }
}

