/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.peripheral.generic.ComponentLookup;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralProvider;
import dan200.computercraft.shared.platform.InvalidateCallback;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Peripherals {
    private static final Logger LOG = LoggerFactory.getLogger(Peripherals.class);
    private static final Collection<IPeripheralProvider> providers = new LinkedHashSet<IPeripheralProvider>();
    private static final GenericPeripheralProvider<InvalidateCallback> genericProvider = new GenericPeripheralProvider();

    private Peripherals() {
    }

    public static synchronized void register(IPeripheralProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    public static void registerGenericLookup(ComponentLookup<InvalidateCallback> lookup) {
        genericProvider.registerLookup(lookup);
    }

    public static void registerGenericCapability(Capability<?> capability) {
        Objects.requireNonNull(capability, "Capability cannot be null");
        Peripherals.registerGenericLookup(new CapabilityLookup(capability));
    }

    public static @Nullable IPeripheral getPeripheral(ServerLevel world, BlockPos pos, Direction side, InvalidateCallback invalidate) {
        LazyOptional peripheral;
        if (!world.m_46739_(pos)) {
            return null;
        }
        BlockEntity block = world.m_7702_(pos);
        if (block != null && (peripheral = block.getCapability(Capabilities.CAPABILITY_PERIPHERAL, side)).isPresent()) {
            return (IPeripheral)CapabilityUtil.unwrap(peripheral, invalidate);
        }
        for (IPeripheralProvider peripheralProvider : providers) {
            try {
                LazyOptional<IPeripheral> peripheral2 = peripheralProvider.getPeripheral((Level)world, pos, side);
                if (!peripheral2.isPresent()) continue;
                return CapabilityUtil.unwrap(peripheral2, invalidate);
            }
            catch (Exception e) {
                LOG.error("Peripheral provider " + String.valueOf(peripheralProvider) + " errored.", (Throwable)e);
            }
        }
        return genericProvider.getPeripheral(world, pos, side, block, invalidate);
    }

    private record CapabilityLookup<T>(Capability<T> capability) implements ComponentLookup<InvalidateCallback>
    {
        @Override
        public @Nullable T find(ServerLevel level, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction side, InvalidateCallback invalidate) {
            return CapabilityUtil.unwrap(CapabilityUtil.getCapability((ICapabilityProvider)blockEntity, this.capability(), side), invalidate);
        }
    }
}

