/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawConfig;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawGenerator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.jetbrains.annotations.NotNull;

public class AlternateJigsawStructure
extends Structure {
    public static final Codec<AlternateJigsawStructure> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)AlternateJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)AlternateJigsawConfig.CODEC.forGetter(AlternateJigsawStructure::config)).apply((Applicative)instance, AlternateJigsawStructure::new)), AlternateJigsawStructure::validate).codec();
    public static final StructureType<AlternateJigsawStructure> TYPE = () -> CODEC;
    private final AlternateJigsawConfig config;

    private static DataResult<AlternateJigsawStructure> validate(AlternateJigsawStructure structure) {
        int i = switch (structure.m_226620_()) {
            default -> throw new IncompatibleClassChangeError();
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
        };
        return structure.config.maxDistanceFromCenter() + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)structure));
    }

    protected AlternateJigsawStructure(Structure.StructureSettings settings, AlternateJigsawConfig config) {
        super(settings);
        this.config = config;
    }

    public AlternateJigsawConfig config() {
        return this.config;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        int i = this.config.startHeight().m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), i, chunkPos.m_45605_());
        return AlternateJigsawGenerator.generate(context, this.config, false, this.config.size().m_214085_((RandomSource)context.f_226626_()), blockPos);
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return TYPE;
    }
}

