/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.processor.enums.RandomMode;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Passthrough;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class SetBlockProcessor
extends StructureProcessor {
    public static final Codec<SetBlockProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("state_provider").forGetter(SetBlockProcessor::blockState), (App)Codec.BOOL.fieldOf("preserve_state").orElse((Object)true).forGetter(SetBlockProcessor::preserveState), (App)RandomMode.CODEC.fieldOf("random_mode").orElse((Object)RandomMode.PER_BLOCK).forGetter(SetBlockProcessor::randomMode), (App)RuleBlockEntityModifier.f_276484_.fieldOf("block_entity_modifier").orElse((Object)Passthrough.f_276645_).forGetter(SetBlockProcessor::modifier)).apply((Applicative)instance, SetBlockProcessor::new));
    public static final StructureProcessorType<SetBlockProcessor> TYPE = () -> CODEC;
    private final BlockStateProvider stateProvider;
    private final boolean preserveState;
    private final RandomMode randomMode;
    private final RuleBlockEntityModifier modifier;

    public SetBlockProcessor(BlockStateProvider stateProvider, boolean preserveState, RandomMode randomMode, RuleBlockEntityModifier modifier) {
        this.stateProvider = stateProvider;
        this.preserveState = preserveState;
        this.randomMode = randomMode;
        this.modifier = modifier;
    }

    public BlockStateProvider blockState() {
        return this.stateProvider;
    }

    public boolean preserveState() {
        return this.preserveState;
    }

    public RandomMode randomMode() {
        return this.randomMode;
    }

    public RuleBlockEntityModifier modifier() {
        return this.modifier;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo relative, StructureTemplate.StructureBlockInfo absolute, StructurePlaceSettings settings) {
        if (levelReader instanceof WorldGenLevel) {
            WorldGenLevel level = (WorldGenLevel)levelReader;
            BlockPos samplePos = this.randomMode.select(pos, absolute);
            RandomSource random = RandomSource.m_216335_((long)level.m_7328_()).m_188582_().m_224542_(samplePos);
            BlockState state = this.blockState().m_213972_(random, samplePos);
            if (this.preserveState) {
                return this.withState(random, absolute, state.m_60734_().m_152465_(absolute.f_74676_()));
            }
            return this.withState(random, absolute, state);
        }
        return absolute;
    }

    private StructureTemplate.StructureBlockInfo withState(RandomSource random, StructureTemplate.StructureBlockInfo info, BlockState state) {
        return new StructureTemplate.StructureBlockInfo(info.f_74675_(), state, this.modifier.m_276854_(random, info.f_74677_()));
    }

    protected StructureProcessorType<?> m_6953_() {
        return TYPE;
    }
}

