/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public record VinesConfig(SimpleWeightedRandomList<Block> blocks, Optional<HolderSet<Block>> canPlaceOn, IntProvider maxLength) implements FeatureConfiguration
{
    private static final SimpleWeightedRandomList<Block> DEFAULT_BLOCK = SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50191_, 1).m_146270_();
    public static final Codec<VinesConfig> CODEC = ExtraCodecs.m_264370_((Codec)RecordCodecBuilder.create(instance -> instance.group((App)LithostitchedCodecs.singleOrWeightedList(BuiltInRegistries.f_256975_.m_194605_()).fieldOf("block").orElse(DEFAULT_BLOCK).forGetter(VinesConfig::blocks), (App)LithostitchedCodecs.BLOCK_SET.optionalFieldOf("can_place_on").forGetter(VinesConfig::canPlaceOn), (App)IntProvider.m_146545_((int)1, (int)256).fieldOf("max_length").orElse((Object)ConstantInt.m_146483_((int)1)).forGetter(VinesConfig::maxLength)).apply((Applicative)instance, VinesConfig::new)), VinesConfig::validate);

    private DataResult<VinesConfig> validate() {
        if (this.blocks.m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).anyMatch(block -> !(block instanceof VineBlock))) {
            return DataResult.error(() -> "State should be a vine block");
        }
        return DataResult.success((Object)this);
    }

    public boolean canPlaceOn(BlockState state) {
        return this.canPlaceOn.isEmpty() || state.m_204341_(this.canPlaceOn.get());
    }
}

