/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesGroupControl;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockController
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock,
IFramedSourceBlock {
    public BlockController(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!SecurityManager.canInteract(player, InteractionHand.MAIN_HAND, pos)) {
            return InteractionResult.PASS;
        }
        Direction blockDir = (Direction)state.m_61143_((Property)f_54117_);
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        ItemStack item = player.m_150109_().m_36056_();
        if (player.m_36335_().m_41519_(item.m_41720_())) {
            return InteractionResult.FAIL;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!item.m_41619_() && this.toggle(level, pos, player, item.m_41720_())) {
            return InteractionResult.SUCCESS;
        }
        if (blockDir != hit.m_82434_()) {
            return InteractionResult.CONSUME;
        }
        if (!level.f_46443_) {
            Item item2;
            if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue() && item.m_41619_()) {
                blockEntity.printDebugInfo();
            }
            if ((item2 = item.m_41720_()) instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote remote = (ItemUpgradeRemote)item2;
                item = ItemUpgradeRemote.setBoundController(item, blockEntity);
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, item);
                player.m_5661_((Component)Component.m_237110_((String)"message.storagedrawers.updated_remote_binding", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
            }
            blockEntity.interactPutItemsIntoInventory(player);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean toggle(Level world, BlockPos pos, Player player, Item item) {
        ItemKey itemKey;
        if (world.f_46443_ || item == null) {
            return false;
        }
        Item keyItem = item;
        if (item instanceof ItemKeyring) {
            ItemKeyring keyring = (ItemKeyring)item;
            keyItem = keyring.getKey().m_41720_();
        }
        if (keyItem instanceof ItemKey && !(itemKey = (ItemKey)keyItem).isEnabled()) {
            return false;
        }
        if (keyItem == ModItems.DRAWER_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.DRAWER);
        } else if (keyItem == ModItems.SHROUD_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.CONCEALMENT);
        } else if (keyItem == ModItems.QUANTIFY_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.QUANTIFY);
        } else if (keyItem == ModItems.SUSPEND_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.SUSPEND);
        } else if (keyItem instanceof ItemPersonalKey) {
            itemKey = (ItemPersonalKey)keyItem;
            this.togglePersonal(world, pos, player, ((ItemPersonalKey)itemKey).getSecurityProviderKey());
        } else {
            return false;
        }
        player.m_36335_().m_41524_(item, 5);
        return true;
    }

    public void toggle(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull EnumKeyType keyType) {
        if (level.f_46443_) {
            return;
        }
        if (!keyType.isEnabled()) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        IDrawerAttributesGroupControl controlAttrs = blockEntity.getGroupControllableAttributes(player);
        if (controlAttrs != null) {
            if (keyType == EnumKeyType.DRAWER) {
                controlAttrs.toggleItemLocked(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED);
            } else if (keyType == EnumKeyType.CONCEALMENT) {
                controlAttrs.toggleConcealed();
            } else if (keyType == EnumKeyType.QUANTIFY) {
                controlAttrs.toggleIsShowingQuantity();
            } else if (keyType == EnumKeyType.SUSPEND) {
                controlAttrs.toggleIsSuspended();
            }
        }
    }

    public void togglePersonal(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, String providerKey) {
        if (level.f_46443_) {
            return;
        }
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        if (Objects.equals(providerKey, "unlock")) {
            blockEntity.clearProtection();
            return;
        }
        ISecurityProvider provider = ModSecurity.registry.getProvider(providerKey);
        blockEntity.toggleProtection(player.m_36316_(), provider);
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (world.f_46443_) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.updateCache();
        world.m_186460_(pos, (Block)this, 100);
    }

    public BlockEntityController newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (BlockEntityController)ModServices.RESOURCE_FACTORY.createBlockEntityController().m_155267_(pos, state);
    }

    @Override
    public ItemStack makeFramedItem(ItemStack source, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        return FrameHelper.makeFramedItem((IFramedBlock)ModBlocks.FRAMED_CONTROLLER.get(), source, matSide, matTrim, matFront);
    }
}

