/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.base.BackpackScreen;
import com.yyz.yyzsbackpack.client.BackpackRenderer;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import com.yyz.yyzsbackpack.util.SlotManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class}, priority=1001)
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements BackpackScreen {
    @Shadow
    protected int f_97726_;
    @Shadow
    protected int f_97727_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Shadow
    @Final
    protected T f_97732_;
    @Shadow
    @Nullable
    protected Slot f_97734_;
    @Shadow
    protected boolean f_97738_;
    @Unique
    private Inventory inventory;
    @Unique
    private boolean shouldRenderBackpack = false;
    @Unique
    private boolean previousBackpackState = false;
    @Unique
    private Slot lastShiftHoveredSlot;
    @Unique
    private boolean shiftPressed;
    @Unique
    private int type;

    @Shadow
    protected abstract boolean m_7467_(double var1, double var3, int var5, int var6, int var7);

    @Shadow
    protected abstract void m_6597_(Slot var1, int var2, int var3, ClickType var4);

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", shift=At.Shift.AFTER)})
    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        BackpackRenderer.renderEquippedBackpackBackground(context, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, this.inventory, this.shouldRenderBackpack, (BackpackMenu)this.f_97732_);
        BackpackRenderer.renderBackpackPreview(context, this.f_96541_, this.f_97732_, this.f_97734_, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
    }

    @ModifyConstant(method={"checkHotbarMouseClicked"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPosition(int original) {
        return 40 + BackpackHelper.getSlotIndexOffset();
    }

    @ModifyConstant(method={"checkHotbarKeyPressed"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPositionHotbar(int original) {
        return 40 + BackpackHelper.getSlotIndexOffset();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void checkBackpackStateChange(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        RenderSystem.disableBlend();
        boolean currentState = BackpackHelper.shouldRenderBackpack(this.f_97732_, this.inventory);
        if (currentState != this.previousBackpackState) {
            this.shouldRenderBackpack = currentState;
            this.previousBackpackState = currentState;
            this.m_232761_();
        }
        RenderSystem.disableBlend();
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseClicked(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.f_97732_ instanceof BackpackMenu ? BackpackHelper.isClickOutsideExtendedBounds(this.inventory, this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button), mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, this.shouldRenderBackpack, (BackpackMenu)this.f_97732_) : this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button);
    }

    @Redirect(method={"mouseReleased"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseReleased(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.f_97732_ instanceof BackpackMenu ? BackpackHelper.isClickOutsideExtendedBounds(this.inventory, this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button), mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, this.shouldRenderBackpack, (BackpackMenu)this.f_97732_) : this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initializeFields(AbstractContainerMenu handler, Inventory inventory, Component component, CallbackInfo ci) {
        this.inventory = inventory;
        this.previousBackpackState = this.shouldRenderBackpack = BackpackHelper.shouldRenderBackpack(handler, this.inventory);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void updateBackpackSlotsPositionBeforeRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        RenderSystem.enableBlend();
        SlotManager.updateBackpackSlotPositions(this, this.f_97732_, this.inventory, this.f_97727_);
        RenderSystem.disableBlend();
    }

    @Override
    public List<Rect2i> getBackpackExclusionZones() {
        int xOffset = ((BackpackMenu)this.f_97732_).getBackpackGuiX();
        int yOffset = ((BackpackMenu)this.f_97732_).getBackpackGuiY();
        if (!this.shouldRenderBackpack) {
            return Collections.emptyList();
        }
        int columns = 0;
        ItemStack backpackStack = BackpackPlatform.getEquipped(this.inventory.f_35978_);
        Item item = backpackStack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpack = (BackpackItem)item;
            columns = backpack.getBackpackType().getColumns();
        }
        int baseWidth = 14 + columns * 18;
        int height = 174;
        int x = this.f_97735_ - baseWidth - 1 + xOffset;
        int y = this.f_97736_ + (this.f_97727_ - height) / 2 + yOffset;
        int actualWidth = baseWidth;
        if (xOffset != 0) {
            actualWidth = xOffset > 0 ? (actualWidth += xOffset) : (actualWidth -= xOffset);
            actualWidth = Math.max(actualWidth, baseWidth);
        }
        return Collections.singletonList(new Rect2i(x, y, actualWidth, height));
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")})
    private void onKeyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)82) && this.f_97732_.m_142621_().m_41619_() && this.f_97734_ != null) {
            this.m_6597_(this.f_97734_, this.f_97734_.f_40219_, 2, ClickType.QUICK_MOVE);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void onKeyPressed(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        if (Screen.m_96638_() && this.f_97732_.m_142621_().m_41619_()) {
            this.shiftPressed = true;
            this.type = i;
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    private void onKeyReleased(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        if (this.shiftPressed) {
            this.shiftPressed = false;
            this.lastShiftHoveredSlot = null;
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="TAIL")})
    private void onMouseMoved(double d, double e, int i, double f, double g, CallbackInfoReturnable<Boolean> cir) {
        if (this.shiftPressed && !this.f_97738_ && this.f_97734_ != null && this.f_97734_ != this.lastShiftHoveredSlot && this.f_97734_.m_6657_()) {
            this.m_6597_(this.f_97734_, this.f_97734_.f_40219_, this.type, ClickType.QUICK_MOVE);
            this.lastShiftHoveredSlot = this.f_97734_;
        }
    }
}

