/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.tables.block.entity.inventory.IChestItemHandler;

public abstract class ScalingChestItemHandler
extends ItemStackHandler
implements IChestItemHandler {
    protected static final int DEFAULT_MAX = 256;
    private int visualSize = 1;
    @Nullable
    private MantleBlockEntity parent;

    public ScalingChestItemHandler(int size) {
        super(size);
    }

    public ScalingChestItemHandler() {
        this(256);
    }

    public abstract boolean isItemValid(int var1, ItemStack var2);

    protected void onLoad() {
        int newLimit = this.getSlots();
        if (newLimit > 1 && this.getStackInSlot(newLimit - 1).m_41619_()) {
            while (newLimit > 1 && this.getStackInSlot(newLimit - 2).m_41619_()) {
                --newLimit;
            }
        }
        this.visualSize = newLimit;
    }

    private void updateVisualSize(int slotChanged, ItemStack stack) {
        int maxSlots = this.getSlots();
        if (slotChanged >= maxSlots) {
            return;
        }
        if (stack.m_41619_()) {
            if (slotChanged + 1 == this.visualSize || slotChanged + 2 == this.visualSize && this.getStackInSlot(this.visualSize - 1).m_41619_()) {
                while (this.visualSize > 1 && this.getStackInSlot(this.visualSize - 2).m_41619_()) {
                    --this.visualSize;
                }
            }
        } else if (this.visualSize < maxSlots && this.visualSize < slotChanged + 2) {
            this.visualSize = slotChanged + 2;
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.updateVisualSize(slot, stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack result = super.insertItem(slot, stack, simulate);
        if (!simulate) {
            this.updateVisualSize(slot, this.getStackInSlot(slot));
        }
        return result;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = super.extractItem(slot, amount, simulate);
        if (!simulate) {
            this.updateVisualSize(slot, this.getStackInSlot(slot));
        }
        return result;
    }

    protected void onContentsChanged(int slot) {
        if (this.parent != null) {
            this.parent.setChangedFast();
        }
    }

    @Override
    public int getVisualSize() {
        return this.visualSize;
    }

    @Override
    public void setParent(@Nullable MantleBlockEntity parent) {
        this.parent = parent;
    }
}

