/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.FallbackPredicateRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface ToolStackPredicate
extends IJsonPredicate<IToolStackView> {
    public static final ToolStackPredicate ANY = ToolStackPredicate.simple(tool -> true);
    public static final FallbackPredicateRegistry<IToolStackView, IToolContext> LOADER = new FallbackPredicateRegistry("Tool Stack Predicate", (IJsonPredicate)ANY, ToolContextPredicate.LOADER, t -> t, "tool");
    public static final ToolStackPredicate NOT_BROKEN = ToolStackPredicate.simple(tool -> !tool.isBroken());

    default public IJsonPredicate<IToolStackView> inverted() {
        return LOADER.invert((IJsonPredicate)this);
    }

    public static ToolStackPredicate simple(final Predicate<IToolStackView> predicate) {
        return (ToolStackPredicate)SingletonLoader.singleton(loader -> new ToolStackPredicate(){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
            }

            public boolean matches(IToolStackView tool) {
                return predicate.test(tool);
            }

            public RecordLoadable<? extends ToolStackPredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static IJsonPredicate<IToolStackView> context(IJsonPredicate<IToolContext> predicate) {
        return LOADER.fallback(predicate);
    }

    public static IJsonPredicate<IToolStackView> fallback(IJsonPredicate<Item> predicate) {
        return ToolStackPredicate.context(ToolContextPredicate.fallback(predicate));
    }

    public static IJsonPredicate<IToolStackView> set(Item ... items) {
        return ToolStackPredicate.fallback((IJsonPredicate<Item>)ItemPredicate.set((Item[])items));
    }

    public static IJsonPredicate<IToolStackView> tag(TagKey<Item> tag) {
        return ToolStackPredicate.fallback((IJsonPredicate<Item>)ItemPredicate.tag(tag));
    }

    @SafeVarargs
    public static IJsonPredicate<IToolStackView> and(IJsonPredicate<IToolStackView> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<IToolStackView> or(IJsonPredicate<IToolStackView> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

