/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.brigadier.CommandDispatcher;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.TectonicModifierPredicate;
import dev.worldgen.tectonic.TectonicRepositorySource;
import dev.worldgen.tectonic.client.gui.ConfigScreen;
import dev.worldgen.tectonic.command.TectonicCommand;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.worldgen.densityfunction.ConfigConstant;
import dev.worldgen.tectonic.worldgen.densityfunction.ConfigNoise;
import dev.worldgen.tectonic.worldgen.densityfunction.Invert;
import java.nio.file.Path;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="tectonic")
public class TectonicLexforge {
    public TectonicLexforge() {
        Tectonic.init(FMLPaths.CONFIGDIR.get());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::handleRegistries);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        if (ConfigHandler.getState().general.modEnabled) {
            boolean terralith = ModList.get().isLoaded("terralith");
            boolean increasedHeight = ConfigHandler.getState().globalTerrain.increasedHeight;
            boolean ultrasmooth = ConfigHandler.getState().globalTerrain.ultrasmooth;
            boolean noCarvers = !ConfigHandler.getState().caves.carversEnabled;
            this.addPack("tectonic");
            this.addPack("tectonic/overlay.mod");
            if (terralith) {
                this.addPack("tectonic/overlay.terratonic");
            }
            if (increasedHeight) {
                this.addPack("tectonic/overlay.increased_height");
            }
            if (increasedHeight && terralith) {
                this.addPack("tectonic/overlay.terratonic_increased_height");
            }
            if (ultrasmooth) {
                this.addPack("tectonic/overlay.ultrasmooth");
            }
            if (noCarvers) {
                this.addPack("tectonic/overlay.no_carvers");
            }
        }
    }

    private void handleRegistries(RegisterEvent event) {
        event.register(Registries.f_256746_, helper -> {
            helper.register(Tectonic.id("config_constant"), (Object)ConfigConstant.CODEC_HOLDER.f_216232_());
            helper.register(Tectonic.id("config_noise"), (Object)ConfigNoise.CODEC_HOLDER.f_216232_());
            helper.register(Tectonic.id("invert"), (Object)Invert.CODEC_HOLDER.f_216232_());
        });
        event.register(LithostitchedRegistryKeys.MODIFIER_PREDICATE_TYPE, helper -> helper.register(Tectonic.id("config"), TectonicModifierPredicate.CODEC));
    }

    private void registerCommands(RegisterCommandsEvent event) {
        TectonicCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void addPack(String packName) {
        Path resourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/" + packName.toLowerCase()});
        TectonicRepositorySource.PACKS.add(Pack.m_245429_((String)("tectonic/" + packName.toLowerCase()), (Component)Component.m_237115_((String)("pack_name.tectonic." + packName)), (boolean)false, string -> new PathPackResources(resourcePath.getFileName().toString(), resourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onLoadComplete(FMLLoadCompleteEvent event) {
            ModContainer container = (ModContainer)ModList.get().getModContainerById("tectonic").orElseThrow(() -> new IllegalStateException("Create mod container missing on LoadComplete"));
            container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> new ConfigScreen((Screen)parent)));
        }
    }
}

