/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.api.bogeymenu.v0.BogeyMenuManager;
import com.railwayteam.railways.api.bogeymenu.v0.entry.CategoryEntry;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowDoubleScotchYokeBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowScotchYokeBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowSmallBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.HandcarBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.ArchbarBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.BlombergBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.FreightBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.ModernBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.PassengerBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.Y25BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled0100Display;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled0120Display;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled040Display;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled060Display;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled080Display;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium10010TenderDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium202TrailingDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium404TrailingDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium606TenderDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium606TrailingDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium808TenderDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumQuadrupleWheelDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumQuintupleWheelDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumSingleWheelDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumStandardDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumTripleWheelDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.CoilspringBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.LeafspringBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.SingleaxleBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.triple_axle.HeavyweightBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.triple_axle.RadialBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideComicallyLargeScotchYokeBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideDefaultBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideScotchYokeBogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyDisplay;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CRBogeyStyles {
    public static final String SINGLEAXLE_CYCLE_GROUP = "singleaxles";
    public static final String DOUBLEAXLE_CYCLE_GROUP = "doubleaxles";
    public static final String TRIPLEAXLE_CYCLE_GROUP = "tripleaxles";
    public static final String QUADRUPLEAXLE_CYCLE_GROUP = "quadrupleaxles";
    public static final String QUINTUPLEAXLE_CYCLE_GROUP = "quintupleaxles";
    public static final String SEXTUPLEAXLE_CYCLE_GROUP = "sextupleaxles";
    public static final CategoryEntry STANDARD_CATEGORY = CRBogeyStyles.registerCategory(AllBogeyStyles.STANDARD_CYCLE_GROUP);
    public static final CategoryEntry SINGLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("singleaxles");
    public static final CategoryEntry DOUBLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("doubleaxles");
    public static final CategoryEntry TRIPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("tripleaxles");
    public static final CategoryEntry QUADRUPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("quadrupleaxles");
    public static final CategoryEntry QUINTUPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("quintupleaxles");
    public static final CategoryEntry SEXTUPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("sextupleaxles");
    private static final Map<Pair<BogeyStyle, TrackMaterial.TrackType>, BogeyStyle> STYLES_FOR_GAUGES = new HashMap<Pair<BogeyStyle, TrackMaterial.TrackType>, BogeyStyle>();
    private static final Map<BogeyStyle, BogeyStyle> STYLES_TO_STANDARD_GAUGE = new HashMap<BogeyStyle, BogeyStyle>();
    private static final Set<BogeyStyle> SUB_LISTED_STYLES = new HashSet<BogeyStyle>();
    private static final Map<BogeyStyle, List<BogeyStyle>> SUB_STYLES = new HashMap<BogeyStyle, List<BogeyStyle>>();
    private static final List<BogeyStyle> EMPTY = ImmutableList.of();
    public static final BogeyStyle MONOBOGEY = CRBogeyStyles.create("monobogey", "monobogey").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.monobogey")).size(BogeySizes.SMALL, CRBlocks.MONO_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(MonoBogeyDisplay::new)).build();
    public static final BogeyStyle INVISIBLE = CRBogeyStyles.create("invisible", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.invisible")).size(BogeySizes.SMALL, CRBlocks.INVISIBLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new InvisibleBogeyRenderer(), InvisibleBogeyVisual::new)).contactParticle((ParticleOptions)new CubeParticleData()).build();
    public static final BogeyStyle INVISIBLE_MONOBOGEY = CRBogeyStyles.create("invisible_monobogey", "monobogey").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.invisible_monobogey")).size(BogeySizes.SMALL, CRBlocks.INVISIBLE_MONO_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new InvisibleBogeyRenderer(), InvisibleBogeyVisual::new)).contactParticle((ParticleOptions)new CubeParticleData()).build();
    public static final BogeyStyle SINGLEAXLE = CRBogeyStyles.create("singleaxle", "singleaxles").size(BogeySizes.SMALL, CRBlocks.SINGLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(SingleaxleBogeyDisplay::new)).build();
    public static final BogeyStyle LEAFSPRING = CRBogeyStyles.create("leafspring", "singleaxles").size(BogeySizes.SMALL, CRBlocks.SINGLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(LeafspringBogeyDisplay::new)).build();
    public static final BogeyStyle COILSPRING = CRBogeyStyles.create("coilspring", "singleaxles").size(BogeySizes.SMALL, CRBlocks.SINGLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(CoilspringBogeyDisplay::new)).build();
    public static final BogeyStyle FREIGHT = CRBogeyStyles.create("freight", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(FreightBogeyDisplay::new)).build();
    public static final BogeyStyle ARCHBAR = CRBogeyStyles.create("archbar", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(ArchbarBogeyDisplay::new)).build();
    public static final BogeyStyle PASSENGER = CRBogeyStyles.create("passenger", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.DOUBLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(PassengerBogeyDisplay::new)).build();
    public static final BogeyStyle MODERN = CRBogeyStyles.create("modern", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.DOUBLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(ModernBogeyDisplay::new)).build();
    public static final BogeyStyle BLOMBERG = CRBogeyStyles.create("blomberg", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.DOUBLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(BlombergBogeyDisplay::new)).build();
    public static final BogeyStyle Y25 = CRBogeyStyles.create("y25", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(Y25BogeyDisplay::new)).build();
    public static final BogeyStyle HEAVYWEIGHT = CRBogeyStyles.create("heavyweight", "tripleaxles").size(BogeySizes.SMALL, CRBlocks.TRIPLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(HeavyweightBogeyDisplay::new)).build();
    public static final BogeyStyle RADIAL = CRBogeyStyles.create("radial", "tripleaxles").size(BogeySizes.SMALL, CRBlocks.TRIPLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(RadialBogeyDisplay::new)).build();
    public static final BogeyStyle WIDE_DEFAULT = CRBogeyStyles.create("wide_default", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.wide_default")).size(BogeySizes.SMALL, CRBlocks.WIDE_DOUBLEAXLE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(WideDefaultBogeyDisplay::new)).size(BogeySizes.LARGE, CRBlocks.WIDE_SCOTCH_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(WideScotchYokeBogeyDisplay::new)).build();
    public static final BogeyStyle WIDE_COMICALLY_LARGE = CRBogeyStyles.create("wide_comically_large", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.wide_comically_large")).size(BogeySizes.LARGE, CRBlocks.WIDE_COMICALLY_LARGE_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(WideComicallyLargeScotchYokeBogeyDisplay::new)).build();
    public static final BogeyStyle NARROW_DEFAULT = CRBogeyStyles.create("narrow_default", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.narrow_default")).size(BogeySizes.SMALL, CRBlocks.NARROW_SMALL_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(NarrowSmallBogeyDisplay::new)).size(BogeySizes.LARGE, CRBlocks.NARROW_SCOTCH_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(NarrowScotchYokeBogeyDisplay::new)).build();
    public static final BogeyStyle NARROW_DOUBLE_SCOTCH = CRBogeyStyles.create("narrow_double_scotch", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.narrow_double_scotch")).size(BogeySizes.LARGE, CRBlocks.NARROW_DOUBLE_SCOTCH_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(NarrowDoubleScotchYokeBogeyDisplay::new)).build();
    public static final BogeyStyle HANDCAR = CRBogeyStyles.create("handcar", "handcar_cycle_group").size(BogeySizes.SMALL, CRBlocks.HANDCAR, () -> () -> BogeyDisplay.createSizeRenderer(HandcarBogeyDisplay::new)).soundEvent(() -> ((AllSoundEvents.SoundEntry)AllSoundEvents.COGS).getMainEvent()).build();
    public static final BogeyStyle MEDIUM_STANDARD = CRBogeyStyles.create("medium_standard", "doubleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_standard")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(MediumStandardDisplay::new)).build();
    public static final BogeyStyle MEDIUM_SINGLE_WHEEL = CRBogeyStyles.create("medium_single_wheel", "singleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_single_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_BOGEY, () -> () -> BogeyDisplay.createSizeRenderer(MediumSingleWheelDisplay::new)).build();
    public static final BogeyStyle MEDIUM_TRIPLE_WHEEL = CRBogeyStyles.create("medium_triple_wheel", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_triple_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_TRIPLE_WHEEL, () -> () -> BogeyDisplay.createSizeRenderer(MediumTripleWheelDisplay::new)).build();
    public static final BogeyStyle MEDIUM_QUADRUPLE_WHEEL = CRBogeyStyles.create("medium_quadruple_wheel", "quadrupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_quadruple_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUADRUPLE_WHEEL, () -> () -> BogeyDisplay.createSizeRenderer(MediumQuadrupleWheelDisplay::new)).build();
    public static final BogeyStyle MEDIUM_QUINTUPLE_WHEEL = CRBogeyStyles.create("medium_quintuple_wheel", "quintupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_quintuple_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUINTUPLE_WHEEL, () -> () -> BogeyDisplay.createSizeRenderer(MediumQuintupleWheelDisplay::new)).build();
    public static final BogeyStyle MEDIUM_2_0_2_TRAILING = CRBogeyStyles.create("medium_2_0_2_trailing", "singleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_2_0_2_trailing")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_2_0_2_TRAILING, () -> () -> BogeyDisplay.createSizeRenderer(Medium202TrailingDisplay::new)).build();
    public static final BogeyStyle MEDIUM_4_0_4_TRAILING = CRBogeyStyles.create("medium_4_0_4_trailing", "doubleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_4_0_4_trailing")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_4_0_4_TRAILING, () -> () -> BogeyDisplay.createSizeRenderer(Medium404TrailingDisplay::new)).build();
    public static final BogeyStyle MEDIUM_6_0_6_TRAILING = CRBogeyStyles.create("medium_6_0_6_trailing", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_6_0_6_trailing")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_TRIPLE_WHEEL, () -> () -> BogeyDisplay.createSizeRenderer(Medium606TrailingDisplay::new)).build();
    public static final BogeyStyle MEDIUM_6_0_6_TENDER = CRBogeyStyles.create("medium_6_0_6_tender", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_6_0_6_tender")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_TRIPLE_WHEEL, () -> () -> BogeyDisplay.createSizeRenderer(Medium606TenderDisplay::new)).build();
    public static final BogeyStyle MEDIUM_8_0_8_TENDER = CRBogeyStyles.create("medium_8_0_8_tender", "quadrupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_8_0_8_tender")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUADRUPLE_WHEEL, () -> () -> BogeyDisplay.createSizeRenderer(Medium808TenderDisplay::new)).build();
    public static final BogeyStyle MEDIUM_10_0_10_TENDER = CRBogeyStyles.create("medium_10_0_10_tender", "quintupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_10_0_10_tender")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUINTUPLE_WHEEL, () -> () -> BogeyDisplay.createSizeRenderer(Medium10010TenderDisplay::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_4_0 = CRBogeyStyles.create("large_create_style_0_4_0", "doubleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_4_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_4_0, () -> () -> BogeyDisplay.createSizeRenderer(LargeCreateStyled040Display::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_6_0 = CRBogeyStyles.create("large_create_style_0_6_0", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_6_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_6_0, () -> () -> BogeyDisplay.createSizeRenderer(LargeCreateStyled060Display::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_8_0 = CRBogeyStyles.create("large_create_style_0_8_0", "quadrupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_8_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_8_0, () -> () -> BogeyDisplay.createSizeRenderer(LargeCreateStyled080Display::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_10_0 = CRBogeyStyles.create("large_create_style_0_10_0", "quintupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_10_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_10_0, () -> () -> BogeyDisplay.createSizeRenderer(LargeCreateStyled0100Display::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_12_0 = CRBogeyStyles.create("large_create_style_0_12_0", "sextupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_12_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_12_0, () -> () -> BogeyDisplay.createSizeRenderer(LargeCreateStyled0120Display::new)).build();

    public static void map(BogeyStyle from, TrackMaterial.TrackType toType, BogeyStyle toStyle) {
        CRBogeyStyles.map(from, toType, toStyle, true);
    }

    public static void map(BogeyStyle from, TrackMaterial.TrackType toType, BogeyStyle toStyle, boolean reverseToStandardGauge) {
        STYLES_FOR_GAUGES.put((Pair<BogeyStyle, TrackMaterial.TrackType>)Pair.of((Object)from, (Object)toType), toStyle);
        if (reverseToStandardGauge) {
            CRBogeyStyles.mapReverse(toStyle, from);
        }
    }

    public static void mapReverse(BogeyStyle gaugeStyle, BogeyStyle standardStyle) {
        STYLES_TO_STANDARD_GAUGE.put(gaugeStyle, standardStyle);
    }

    public static boolean styleFitsTrack(BogeyStyle style, TrackMaterial.TrackType trackType) {
        AbstractBogeyBlock<?> bogeyBlock = CRBogeyStyles.getNextBlock(style);
        return bogeyBlock.getValidPathfindingTypes(style).contains(trackType) && trackType != CRTrackMaterials.CRTrackType.MONORAIL ^ bogeyBlock instanceof InvisibleMonoBogeyBlock;
    }

    public static Optional<BogeyStyle> getMapped(BogeyStyle from, TrackMaterial.TrackType toType) {
        return CRBogeyStyles.getMappedRecursive(from, toType, false);
    }

    private static Optional<BogeyStyle> getMappedRecursive(BogeyStyle from, TrackMaterial.TrackType toType, boolean recursive) {
        if (CRBogeyStyles.getNextBlock(from).getValidPathfindingTypes(from).contains(toType)) {
            return Optional.of(from);
        }
        Pair key = Pair.of((Object)from, (Object)toType);
        if (STYLES_FOR_GAUGES.containsKey(key)) {
            return Optional.of(STYLES_FOR_GAUGES.get(key));
        }
        if (toType == TrackMaterial.TrackType.STANDARD && STYLES_TO_STANDARD_GAUGE.containsKey(from)) {
            return Optional.of(STYLES_TO_STANDARD_GAUGE.get(from));
        }
        if (toType != TrackMaterial.TrackType.STANDARD && !recursive) {
            return CRBogeyStyles.getMappedRecursive(from, TrackMaterial.TrackType.STANDARD, true).flatMap(standardStyle -> CRBogeyStyles.getMappedRecursive(standardStyle, toType, true));
        }
        return Optional.empty();
    }

    public static Optional<BogeyStyle> getMapped(BogeyStyle from, TrackMaterial.TrackType toType, boolean forceFit) {
        Optional<BogeyStyle> mapped = CRBogeyStyles.getMapped(from, toType);
        if (!forceFit || toType == TrackMaterial.TrackType.STANDARD && mapped.isEmpty()) {
            return mapped;
        }
        if (mapped.isEmpty() || !CRBogeyStyles.getNextBlock(mapped.get()).getValidPathfindingTypes(mapped.get()).contains(toType)) {
            return AllBogeyStyles.BOGEY_STYLES.values().stream().filter(style -> CRBogeyStyles.styleFitsTrack(style, toType)).findFirst();
        }
        return mapped;
    }

    public static AbstractBogeyBlock<?> getNextBlock(BogeyStyle style) {
        return style.getNextBlock((BogeySizes.BogeySize)style.validSizes().stream().max((a, b) -> Float.compare(a.wheelRadius(), b.wheelRadius())).orElseThrow());
    }

    public static void listUnder(BogeyStyle target, BogeyStyle parent) {
        SUB_LISTED_STYLES.add(target);
        List sub = SUB_STYLES.computeIfAbsent(parent, s -> new ArrayList());
        if (!sub.contains(target)) {
            sub.add(target);
        }
    }

    public static boolean hideInSelectionMenu(BogeyStyle style) {
        return SUB_LISTED_STYLES.contains(style);
    }

    public static List<BogeyStyle> getSubStyles(BogeyStyle style) {
        return SUB_STYLES.getOrDefault(style, EMPTY);
    }

    public static BogeyStyle.Builder create(String name, String cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), Railways.asResource(cycleGroup)).displayName((Component)Component.m_237115_((String)("railways.bogeys.styles." + name)));
    }

    public static BogeyStyle.Builder create(String name, ResourceLocation cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), cycleGroup);
    }

    public static BogeyStyle.Builder create(ResourceLocation name, ResourceLocation cycleGroup) {
        return new BogeyStyle.Builder(name, cycleGroup);
    }

    public static CategoryEntry registerCategory(String name) {
        return CRBogeyStyles.registerCategory("railways", name);
    }

    public static CategoryEntry registerCategory(ResourceLocation id) {
        return CRBogeyStyles.registerCategory(id.m_135827_(), id.m_135815_());
    }

    public static CategoryEntry registerCategory(String modid, String name) {
        MutableComponent categoryName = Component.m_237115_((String)(modid + ".gui.bogey_menu.category." + name));
        ResourceLocation categoryId = new ResourceLocation(modid, "bogey_menu/category/" + name);
        return BogeyMenuManager.INSTANCE.registerCategory((Component)categoryName, categoryId);
    }

    private static void addToCategory(CategoryEntry category, BogeyStyle style) {
        CRBogeyStyles.addToCategory(category, style, 23.0f);
    }

    private static void addToCategory(CategoryEntry category, BogeyStyle style, float scale) {
        String bogeyName = style.id.m_135815_();
        if (style == AllBogeyStyles.STANDARD) {
            bogeyName = "default";
        }
        ResourceLocation icon = Railways.asResource("textures/gui/bogey_icons/" + bogeyName + "_icon.png");
        BogeyMenuManager.INSTANCE.addToCategory(category, style, icon, scale);
    }

    private static void setScalesForSizes(BogeyStyle style, BogeySizes.BogeySize size, float scale) {
        BogeyMenuManager.INSTANCE.setScalesForBogeySizes(style, size, scale);
    }

    public static void register() {
        Railways.LOGGER.info("Registered bogey styles from railways");
        CRBogeyStyles.map(AllBogeyStyles.STANDARD, CRTrackMaterials.CRTrackType.WIDE_GAUGE, WIDE_DEFAULT);
        CRBogeyStyles.map(AllBogeyStyles.STANDARD, CRTrackMaterials.CRTrackType.NARROW_GAUGE, NARROW_DEFAULT);
        CRBogeyStyles.mapReverse(NARROW_DOUBLE_SCOTCH, AllBogeyStyles.STANDARD);
        CRBogeyStyles.mapReverse(WIDE_COMICALLY_LARGE, AllBogeyStyles.STANDARD);
        CRBogeyStyles.listUnder(WIDE_DEFAULT, AllBogeyStyles.STANDARD);
        CRBogeyStyles.listUnder(NARROW_DEFAULT, AllBogeyStyles.STANDARD);
        CRBogeyStyles.setScalesForSizes(WIDE_DEFAULT, BogeySizes.SMALL, 20.0f);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, INVISIBLE);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, WIDE_COMICALLY_LARGE, 17.0f);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, AllBogeyStyles.STANDARD);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, NARROW_DOUBLE_SCOTCH);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, SINGLEAXLE);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, COILSPRING);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, LEAFSPRING);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, MEDIUM_SINGLE_WHEEL);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, MEDIUM_2_0_2_TRAILING);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, MODERN);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, BLOMBERG);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, Y25);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, FREIGHT);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, PASSENGER);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, ARCHBAR);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, MEDIUM_STANDARD);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, MEDIUM_4_0_4_TRAILING);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_4_0);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, HEAVYWEIGHT, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, RADIAL, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, MEDIUM_6_0_6_TRAILING, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, MEDIUM_6_0_6_TENDER, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_6_0, 20.0f);
        CRBogeyStyles.addToCategory(QUADRUPLEAXLE_CATEGORY, MEDIUM_QUADRUPLE_WHEEL, 19.0f);
        CRBogeyStyles.addToCategory(QUADRUPLEAXLE_CATEGORY, MEDIUM_8_0_8_TENDER, 19.0f);
        CRBogeyStyles.addToCategory(QUADRUPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_8_0, 17.0f);
        CRBogeyStyles.addToCategory(QUINTUPLEAXLE_CATEGORY, MEDIUM_QUINTUPLE_WHEEL, 17.0f);
        CRBogeyStyles.addToCategory(QUINTUPLEAXLE_CATEGORY, MEDIUM_10_0_10_TENDER, 17.0f);
        CRBogeyStyles.addToCategory(QUINTUPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_10_0, 15.0f);
        CRBogeyStyles.addToCategory(SEXTUPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_12_0, 13.0f);
        if (Utils.isDevEnv()) {
            CategoryEntry ALL_TEST_CATEGORY = CRBogeyStyles.registerCategory("railways", "all_test");
            for (BogeyStyle style : AllBogeyStyles.BOGEY_STYLES.values()) {
                if (CRBogeyStyles.hideInSelectionMenu(style)) continue;
                CRBogeyStyles.addToCategory(ALL_TEST_CATEGORY, style);
            }
        }
    }
}

