/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin_interfaces.CarriageBogeyUtils;
import com.railwayteam.railways.mixin_interfaces.ICarriageBufferDistanceTracker;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.MixinVariables;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Carriage.class}, remap=false)
public abstract class MixinCarriage
implements ICarriageConductors,
ICarriageBufferDistanceTracker {
    @Shadow
    public Train train;
    private final List<UUID> railways$controllingConductors = new ArrayList<UUID>();
    @Unique
    @Nullable
    private Integer railways$leadingBufferDistance = null;
    @Unique
    @Nullable
    private Integer railways$trailingBufferDistance = null;

    @Shadow
    public abstract CarriageBogey leadingBogey();

    @Shadow
    public abstract CarriageBogey trailingBogey();

    @Shadow
    public abstract TravellingPoint getLeadingPoint();

    @Shadow
    public abstract TravellingPoint getTrailingPoint();

    @Override
    public List<UUID> railways$getControllingConductors() {
        return this.railways$controllingConductors;
    }

    @Override
    @Nullable
    public Integer railways$getLeadingDistance() {
        return this.railways$leadingBufferDistance;
    }

    @Override
    @Nullable
    public Integer railways$getTrailingDistance() {
        return this.railways$trailingBufferDistance;
    }

    @Override
    public void railways$setLeadingDistance(int distance) {
        this.railways$leadingBufferDistance = distance;
    }

    @Override
    public void railways$setTrailingDistance(int distance) {
        this.railways$trailingBufferDistance = distance;
    }

    @WrapOperation(method={"updateConductors"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/CarriageContraptionEntity;checkConductors()Lnet/createmod/catnip/data/Couple;")})
    private Couple<Boolean> addControllingConductors(CarriageContraptionEntity instance, Operation<Couple<Boolean>> original) {
        this.railways$controllingConductors.clear();
        Contraption contraption = instance.getContraption();
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            for (Entity passenger : instance.m_20197_()) {
                Couple validSides;
                BlockPos seatOf;
                if (!(passenger instanceof ConductorEntity) || (seatOf = cc.getSeatOf(passenger.m_20148_())) == null || (validSides = (Couple)cc.conductorSeats.get(seatOf)) == null || !((Boolean)validSides.getFirst()).booleanValue() && !((Boolean)validSides.getSecond()).booleanValue()) continue;
                this.railways$controllingConductors.add(passenger.m_20148_());
            }
        }
        return (Couple)original.call(new Object[]{instance});
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeControllingConductors(DimensionPalette dimensions, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        ListTag listTag = new ListTag();
        for (UUID uuid : this.railways$controllingConductors) {
            CompoundTag uuidTag = new CompoundTag();
            uuidTag.m_128362_("UUID", uuid);
            listTag.add((Object)uuidTag);
        }
        tag.m_128365_("ControllingConductors", (Tag)listTag);
        if (this.railways$leadingBufferDistance != null) {
            tag.m_128405_("LeadingBufferDistance", this.railways$leadingBufferDistance.intValue());
        }
        if (this.railways$trailingBufferDistance != null) {
            tag.m_128405_("TrailingBufferDistance", this.railways$trailingBufferDistance.intValue());
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void readControllingConductors(CompoundTag tag, TrackGraph graph, DimensionPalette dimensions, CallbackInfoReturnable<Carriage> cir) {
        Carriage carriage = (Carriage)cir.getReturnValue();
        List<UUID> controllingConductors = ((ICarriageConductors)carriage).railways$getControllingConductors();
        controllingConductors.clear();
        if (tag.m_128425_("ControllingConductors", 9)) {
            ListTag listTag = tag.m_128437_("ControllingConductors", 10);
            for (Tag item : listTag) {
                CompoundTag uuidTag;
                if (!(item instanceof CompoundTag) || !(uuidTag = (CompoundTag)item).m_128403_("UUID")) continue;
                controllingConductors.add(uuidTag.m_128342_("UUID"));
            }
        }
        if (tag.m_128425_("LeadingBufferDistance", 3)) {
            ((ICarriageBufferDistanceTracker)carriage).railways$setLeadingDistance(tag.m_128451_("LeadingBufferDistance"));
        }
        if (tag.m_128425_("TrailingBufferDistance", 3)) {
            ((ICarriageBufferDistanceTracker)carriage).railways$setTrailingDistance(tag.m_128451_("TrailingBufferDistance"));
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void markTravelStart(Level level, TrackGraph graph, double distance, TravellingPoint toFollowForward, TravellingPoint toFollowBackward, int type, CallbackInfoReturnable<Double> cir) {
        if (this.train.navigation.isActive()) {
            MixinVariables.trackEdgeCarriageTravelling = true;
        }
    }

    @Inject(method={"travel"}, at={@At(value="RETURN")})
    private void markTravelEnd(Level level, TrackGraph graph, double distance, TravellingPoint toFollowForward, TravellingPoint toFollowBackward, int type, CallbackInfoReturnable<Double> cir) {
        MixinVariables.trackEdgeCarriageTravelling = false;
    }

    @ModifyExpressionValue(method={"isOnIncompatibleTrack"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/bogey/AbstractBogeyBlock;isOnIncompatibleTrack(Lcom/simibubi/create/content/trains/entity/Carriage;Z)Z", ordinal=0)})
    private boolean allowUniversalTrackLeading(boolean original) {
        return this.railways$isIncompatible(original, true);
    }

    @ModifyExpressionValue(method={"isOnIncompatibleTrack"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/bogey/AbstractBogeyBlock;isOnIncompatibleTrack(Lcom/simibubi/create/content/trains/entity/Carriage;Z)Z", ordinal=1)})
    private boolean allowUniversalTrackTrailing(boolean original) {
        return this.railways$isIncompatible(original, false);
    }

    @Unique
    private boolean railways$isIncompatible(boolean original, boolean leading) {
        TravellingPoint point;
        CarriageBogey bogey = leading ? this.leadingBogey() : this.trailingBogey();
        TravellingPoint travellingPoint = point = leading ? this.getLeadingPoint() : this.getTrailingPoint();
        if (point.edge == null) {
            return false;
        }
        if (point.edge.getTrackMaterial().trackType == CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return false;
        }
        if (CarriageBogeyUtils.getType(bogey).getTrackType(bogey.getStyle()) == CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return false;
        }
        return original;
    }

    @Inject(method={"manageEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowTravellingWithoutLevel(Level level, CallbackInfo ci) {
        if (level == null) {
            ci.cancel();
        }
    }
}

