/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.Railways;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SpriteCopyingBakedModel
implements BakedModel {
    protected final BakedModel baseModel;
    protected final BakedModel spriteSourceModel;

    public SpriteCopyingBakedModel(BakedModel baseModel, BakedModel spriteSourceModel) {
        this.baseModel = baseModel;
        this.spriteSourceModel = spriteSourceModel;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState pState, @Nullable Direction pSide, RandomSource pRand) {
        List nullQuads;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        TextureAtlasSprite overrideSprite = this.spriteSourceModel.m_6160_();
        BakedQuad overrideQuad = null;
        List sourceQuads = this.spriteSourceModel.m_213637_(pState, pSide, pRand);
        if (!sourceQuads.isEmpty()) {
            overrideSprite = ((BakedQuad)sourceQuads.get(0)).m_173410_();
            overrideQuad = (BakedQuad)sourceQuads.get(0);
        } else if (pSide != null && !(nullQuads = this.spriteSourceModel.m_213637_(pState, null, pRand)).isEmpty()) {
            overrideSprite = ((BakedQuad)nullQuads.get(0)).m_173410_();
            overrideQuad = (BakedQuad)nullQuads.get(0);
        }
        for (BakedQuad quad : this.baseModel.m_213637_(pState, pSide, pRand)) {
            if (overrideSprite == null || overrideQuad == null) {
                Railways.LOGGER.error("No overriding sprites found for side " + (pSide == null ? "null" : pSide.toString()) + " blockstate: " + (pState == null ? "null" : pState.toString()));
            }
            quads.add(new BakedQuad(this.transformVertices(quad.m_111303_(), quad.m_173410_(), overrideQuad != null ? overrideQuad : quad), quad.m_111305_(), quad.m_111306_(), overrideSprite != null ? overrideSprite : quad.m_173410_(), true));
        }
        return quads;
    }

    private int[] transformVertices(int[] baseVertices, TextureAtlasSprite baseSprite, BakedQuad uvSource) {
        TextureAtlasSprite goalSprite = uvSource.m_173410_();
        int[] newVertices = (int[])baseVertices.clone();
        for (int i = 0; i < baseVertices.length; i += 8) {
            newVertices[i + 4] = Float.floatToRawIntBits(Float.intBitsToFloat(baseVertices[i + 4]) - baseSprite.m_118409_() + goalSprite.m_118409_());
            newVertices[i + 5] = Float.floatToRawIntBits(Float.intBitsToFloat(baseVertices[i + 5]) - baseSprite.m_118411_() + goalSprite.m_118411_());
        }
        return newVertices;
    }

    public boolean m_7541_() {
        return this.spriteSourceModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.spriteSourceModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.spriteSourceModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteSourceModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }
}

